/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.validation.constraints;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gmt.modisco.infra.browser.custom.CustomizableFeatures;
import org.eclipse.gmt.modisco.infra.browser.custom.StaticFeatureValue;
import org.eclipse.gmt.modisco.infra.browser.custom.util.UicustomUtil;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontsValidation
extends AbstractModelConstraint {
    private static Set<String> allSystemFonts = null;

    public IStatus validate(IValidationContext context) {
        StaticFeatureValue value;
        CustomizableFeatures customizedFeature;
        EObject eObject = context.getTarget();
        EMFEventType eType = context.getEventType();
        if (eType == EMFEventType.NULL && eObject instanceof StaticFeatureValue && (customizedFeature = UicustomUtil.getCustomizedFeature(value = (StaticFeatureValue)eObject)) == CustomizableFeatures.FONT_NAME && !this.isValidFont(value.getValue())) {
            return context.createFailureStatus(new Object[]{value.getValue()});
        }
        return context.createSuccessStatus();
    }

    private boolean isValidFont(String fontName) {
        return FontsValidation.getAllsystemfonts().contains(fontName);
    }

    public static Set<String> getAllsystemfonts() {
        if (allSystemFonts == null) {
            FontData[] fontDatas2;
            FontData[] fontDatas1;
            allSystemFonts = new HashSet<String>();
            Display display = new Display();
            FontData[] fontDataArray = fontDatas1 = display.getFontList(null, false);
            int n = fontDatas1.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fontData = fontDataArray[n2];
                allSystemFonts.add(fontData.getName());
                ++n2;
            }
            FontData[] fontDataArray2 = fontDatas2 = display.getFontList(null, true);
            int n3 = fontDatas2.length;
            n = 0;
            while (n < n3) {
                FontData fontData = fontDataArray2[n];
                allSystemFonts.add(fontData.getName());
                ++n;
            }
            display.dispose();
        }
        return allSystemFonts;
    }
}

