/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.validation.constraints;

import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gmt.modisco.common.core.utils.PathUtils;
import org.eclipse.gmt.modisco.infra.browser.custom.CustomizableFeatures;
import org.eclipse.gmt.modisco.infra.browser.custom.StaticFeatureValue;
import org.eclipse.gmt.modisco.infra.browser.custom.util.OverlayIconInfo;
import org.eclipse.gmt.modisco.infra.browser.custom.util.UicustomUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class IconsValidation
extends AbstractModelConstraint {
    private static final int MAIN_ICON_WIDTH = 16;
    private static final int MAIN_ICON_HEIGHT = 16;
    private static final int OVERLAY_ICON_WIDTH = 8;
    private static final int OVERLAY_ICON_HEIGHT = 8;

    public IStatus validate(IValidationContext context) {
        EObject eObject = context.getTarget();
        EMFEventType eType = context.getEventType();
        if (eType == EMFEventType.NULL && eObject instanceof StaticFeatureValue) {
            StaticFeatureValue value = (StaticFeatureValue)eObject;
            CustomizableFeatures customizedFeature = UicustomUtil.getCustomizedFeature(value);
            if (!(customizedFeature != CustomizableFeatures.ICON && customizedFeature != CustomizableFeatures.FACET_MAIN_ICON || this.isValidIcon(value.getValue(), 16, 16))) {
                return context.createFailureStatus(new Object[]{value.getValue(), 16, 16});
            }
            if (customizedFeature == CustomizableFeatures.FACET_OVERLAY_ICON) {
                try {
                    OverlayIconInfo overlayIconInfo = UicustomUtil.decodeOverlayIcon(value.getValue());
                    if (!this.isValidIcon(overlayIconInfo.getPath(), 8, 8)) {
                        return context.createFailureStatus(new Object[]{overlayIconInfo.getPath(), 8, 8});
                    }
                }
                catch (Exception e) {
                    return context.createFailureStatus(new Object[]{value.getValue(), 8, 8});
                }
            }
        }
        return context.createSuccessStatus();
    }

    private boolean isValidIcon(String path, int expectedWidth, int expectedHeight) {
        InputStream inputStream = PathUtils.getResourceStream((IPath)new Path(path));
        if (inputStream != null) {
            try {
                Image image = new Image((Device)Display.getDefault(), inputStream);
                boolean valid = expectedWidth == image.getBounds().width && expectedHeight == image.getBounds().height;
                inputStream.close();
                image.dispose();
                return valid;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

