/*******************************************************************************
 * Copyright (c) 2009, 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.browser.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.AbstractModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.jface.dialogs.MessageDialog;

public final class QueryUtil {

	private QueryUtil() {
		// cannot be instantiated
	}

	public static Object basicEvaluate(final ModelQuery modelQuery, final EObject context) {
		final ModelQuerySetCatalog querySetCatalog = ModelQuerySetCatalog.getSingleton();
		try {
			final AbstractModelQuery modelQueryImpl = querySetCatalog.getModelQueryImpl(modelQuery);
			return modelQueryImpl.basicEvaluate(context);
		} catch (final ModelQueryException e) {
			MessageDialog.openError(null, Messages.QueryUtil_QueryError, e.getClass().getSimpleName() + " : " //$NON-NLS-1$
					+ e.getMessage());
			MoDiscoBrowserPlugin.logException(e);
			return null;
		}
	}
}
