/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmt.modisco.common.core.utils.ModelUtils;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstancesForMetaclasses {
    private final TreeMap<String, InstancesForMetaclass> modelElements = new TreeMap();
    private final ArrayList<InstancesForMetaclass> rootMetaclasses = new ArrayList();
    private final BrowserConfiguration browserConfiguration;

    public InstancesForMetaclasses(BrowserConfiguration browserConfiguration) {
        this.browserConfiguration = browserConfiguration;
    }

    public InstancesForMetaclass[] getInstancesForMetaclasses() {
        Collection<InstancesForMetaclass> instancesForMetaclasses = this.modelElements.values();
        return instancesForMetaclasses.toArray(new InstancesForMetaclass[instancesForMetaclasses.size()]);
    }

    public InstancesForMetaclass getInstancesForMetaclass(String metaclassQualifiedName) {
        return this.modelElements.get(metaclassQualifiedName);
    }

    public void addElementsFrom(ResourceSet resourceSet) {
        EList resources = resourceSet.getResources();
        if (resources.size() == 0) {
            return;
        }
        Resource resource = (Resource)resources.get(0);
        this.addElementsFrom(resource);
    }

    public void addElementsFrom(Resource resource) {
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            this.addModelElement(eObject);
        }
    }

    private void addModelElement(EObject element) {
        String classQualifiedName = ModelUtils.getMetaclassQualifiedName((EClassifier)element.eClass());
        InstancesForMetaclass instancesForMetaclass = this.modelElements.get(classQualifiedName);
        if (instancesForMetaclass == null) {
            instancesForMetaclass = new InstancesForMetaclass(element.eClass(), this, this.browserConfiguration);
            this.modelElements.put(classQualifiedName, instancesForMetaclass);
        }
        instancesForMetaclass.add(element, true);
        try {
            for (Facet facet : this.browserConfiguration.getFacetContext().getFacets(element)) {
                String facetQualifiedName = ModelUtils.getMetaclassQualifiedName((EClassifier)facet);
                InstancesForMetaclass instancesForFacet = this.modelElements.get(facetQualifiedName);
                if (instancesForFacet == null) {
                    instancesForFacet = new InstancesForMetaclass((EClass)facet, this, this.browserConfiguration);
                    this.modelElements.put(facetQualifiedName, instancesForFacet);
                }
                instancesForFacet.add(element, false);
            }
        }
        catch (ModelQueryException e) {
            MoDiscoBrowserPlugin.logException(e);
        }
    }

    public void addMetaclasses(Collection<EClass> metaclasses) {
        for (EClass eClass : metaclasses) {
            this.addMetaclass(eClass);
        }
    }

    public void addMetaclass(EClass eClass) {
        String metaclassQualifiedName = ModelUtils.getMetaclassQualifiedName((EClassifier)eClass);
        if (this.modelElements.get(metaclassQualifiedName) == null) {
            InstancesForMetaclass instancesForMetaclass = new InstancesForMetaclass(eClass, this, this.browserConfiguration);
            this.modelElements.put(metaclassQualifiedName, instancesForMetaclass);
        }
    }

    public void buildDerivationTree() {
        InstancesForMetaclass instancesForMetaclass;
        InstancesForMetaclass[] instancesByMetaclass = this.getInstancesForMetaclasses();
        this.rootMetaclasses.clear();
        InstancesForMetaclass[] instancesForMetaclassArray = instancesByMetaclass;
        int n = instancesByMetaclass.length;
        int n2 = 0;
        while (n2 < n) {
            instancesForMetaclass = instancesForMetaclassArray[n2];
            instancesForMetaclass.clearSubclasses();
            ++n2;
        }
        instancesForMetaclassArray = instancesByMetaclass;
        n = instancesByMetaclass.length;
        n2 = 0;
        while (n2 < n) {
            instancesForMetaclass = instancesForMetaclassArray[n2];
            instancesForMetaclass.buildParentsSubclasses();
            if (instancesForMetaclass.getEClass().getESuperTypes().isEmpty()) {
                this.rootMetaclasses.add(instancesForMetaclass);
            }
            ++n2;
        }
    }

    public InstancesForMetaclass[] getRootMetaclasses() {
        return this.rootMetaclasses.toArray(new InstancesForMetaclass[this.rootMetaclasses.size()]);
    }

    public void removeMetaClasses(Collection<? extends EClass> metaclasses) {
        for (EClass eClass : metaclasses) {
            String metaclassQualifiedName = ModelUtils.getMetaclassQualifiedName((EClassifier)eClass);
            this.modelElements.remove(metaclassQualifiedName);
        }
    }
}

