/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.gmt.modisco.common.core.builder.AbstractMoDiscoCatalog;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.common.core.utils.ModelUtils;
import org.eclipse.gmt.modisco.common.ui.controls.FormStyleSashForm;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.adapters.PropertySourceAdapterFactory;
import org.eclipse.gmt.modisco.infra.browser.core.AttributeItem;
import org.eclipse.gmt.modisco.infra.browser.core.BigListItem;
import org.eclipse.gmt.modisco.infra.browser.core.ITreeElement;
import org.eclipse.gmt.modisco.infra.browser.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.infra.browser.core.InstancesForMetaclasses;
import org.eclipse.gmt.modisco.infra.browser.core.LinkItem;
import org.eclipse.gmt.modisco.infra.browser.core.MetaclassList;
import org.eclipse.gmt.modisco.infra.browser.core.ModelElementItem;
import org.eclipse.gmt.modisco.infra.browser.core.QueryItem;
import org.eclipse.gmt.modisco.infra.browser.core.SearchResults;
import org.eclipse.gmt.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.gmt.modisco.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.gmt.modisco.infra.browser.customization.CustomizationEngine;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserActionBarContributor;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserContentProvider;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserLabelProvider;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserNavigationLocation;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserSettingsPersistence;
import org.eclipse.gmt.modisco.infra.browser.editors.CustomTreePainter;
import org.eclipse.gmt.modisco.infra.browser.editors.DragAdapter;
import org.eclipse.gmt.modisco.infra.browser.editors.FacetTooltip;
import org.eclipse.gmt.modisco.infra.browser.editors.IBrowserSelectionChangedListener;
import org.eclipse.gmt.modisco.infra.browser.editors.LeftPane;
import org.eclipse.gmt.modisco.infra.browser.editors.MetaclassViewer;
import org.eclipse.gmt.modisco.infra.browser.editors.TreeToolBar;
import org.eclipse.gmt.modisco.infra.browser.editors.WorkspaceChangeListener;
import org.eclipse.gmt.modisco.infra.browser.queries.SelectedQueriesManager;
import org.eclipse.gmt.modisco.infra.browser.queries.SelectedQuery;
import org.eclipse.gmt.modisco.infra.browser.util.EMFUtil;
import org.eclipse.gmt.modisco.infra.common.ui.editorInputs.IResourceEditorInput;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.FacetSet;
import org.eclipse.gmt.modisco.infra.facet.core.FacetSetCatalog;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreBrowser
extends EditorPart
implements ISelectionProvider,
IMenuListener,
IViewerProvider,
INavigationLocationProvider {
    private static final int MAIN_FORM_MARGIN_HEIGHT = 6;
    private static final int MAIN_FORM_MARGIN_WIDTH = 4;
    private static final int RIGHT_PANE_SASH_WEIGHT = 65;
    private static final int LEFT_PANE_SASH_WEIGHT = 35;
    public static final String EDITOR_ID = "org.eclipse.gmt.modisco.infra.browser.editorID";
    private static final String PROPERTY_VIEW_ID = "org.eclipse.ui.views.PropertySheet";
    private ResourceSet fResourceSet;
    private Resource model;
    private ComposedAdapterFactory adapterFactoryWithRegistry;
    private PropertySheetPage propertySheetPage;
    private TreeViewer treeViewer;
    private Tree fTree;
    private MetaclassViewer metaclassViewer;
    private ISelectionChangedListener selectionChangedListener;
    private final Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private ISelection editorSelection = StructuredSelection.EMPTY;
    private final WorkspaceChangeListener resourceChangeListener;
    private final BrowserConfiguration browserConfiguration = new BrowserConfiguration(this);
    private Composite parentComposite;
    private Text searchBox;
    private Job searchJob = null;
    private Object savedInput;
    private IPropertyChangeListener fontChangeListener;
    private BrowserConfiguration.ChangeListener fCustomizationEngineChangeListener = null;
    private AbstractMoDiscoCatalog.ModiscoCatalogChangeListener fFacetsChangeListener = null;
    private Job refreshJob = null;
    private boolean browingRegistryResource;
    private FormStyleSashForm sashForm;
    private CustomTreePainter customTreePainter;
    private FormToolkit formToolkit;
    private Form form;
    private LeftPane leftPane;
    private TreeToolBar instancesToolBar;
    private BrowserSettingsPersistence settingsPersistence;

    public EcoreBrowser() {
        this.browserConfiguration.load();
        this.resourceChangeListener = new WorkspaceChangeListener(this);
    }

    public void setSelectionToViewer(Collection<?> selection) {
        if (selection != null && !selection.isEmpty() && this.treeViewer != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(selection.toArray()), true);
        }
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    public MetaclassViewer getMetaclassViewer() {
        return this.metaclassViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
    }

    protected Resource createModel() {
        Resource result = null;
        this.fResourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        this.browingRegistryResource = false;
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        try {
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof FileEditorInput) {
                result = this.fResourceSet.getResource(resourceURI, true);
            } else if (editorInput instanceof IResourceEditorInput) {
                IResourceEditorInput resourceEditorInput = (IResourceEditorInput)editorInput;
                result = resourceEditorInput.getResource();
                this.fResourceSet.getResources().add((Object)result);
                this.browingRegistryResource = true;
                this.setPartName(result.getURI().toString());
            } else {
                String resolveURI = resourceURI.toString();
                EPackage ePackage = this.fResourceSet.getPackageRegistry().getEPackage(resolveURI);
                if (ePackage != null) {
                    result = ePackage.eResource();
                    if (result != null) {
                        this.fResourceSet.getResources().add((Object)result);
                        this.browingRegistryResource = true;
                        this.setPartName(ePackage.getName());
                    }
                } else {
                    MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)Messages.EcoreBrowser_cannotOpenModelFromURI, (String)NLS.bind((String)Messages.EcoreBrowser_cannotFindEPackageWithThatURI, (Object)resolveURI));
                }
            }
        }
        catch (Exception e) {
            MoDiscoBrowserPlugin.logException(e);
            MessageDialog.openError((Shell)this.parentComposite.getShell(), (String)Messages.EcoreBrowser_errorLoadingModel, (String)e.toString());
            this.fResourceSet.getResource(resourceURI, false);
        }
        return result;
    }

    public void createPartControl(Composite parent) {
        this.formToolkit = new FormToolkit(parent.getDisplay());
        this.form = this.formToolkit.createForm(parent);
        this.parentComposite = parent;
        parent.setLayout((Layout)new FillLayout());
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 4;
        fillLayout.marginHeight = 6;
        this.form.getBody().setLayout((Layout)fillLayout);
        ComposedAdapterFactory.Descriptor.Registry registry = ComposedAdapterFactory.Descriptor.Registry.INSTANCE;
        this.adapterFactoryWithRegistry = new ComposedAdapterFactory(registry);
        this.browserConfiguration.setAdapterFactoryWithRegistry(this.adapterFactoryWithRegistry);
        this.initResourceSet();
        this.settingsPersistence = new BrowserSettingsPersistence(this.getMetamodelURI(), (IWorkbenchPart)this, this.browserConfiguration);
        this.browserConfiguration.setSelectedQueriesManager(new SelectedQueriesManager());
        this.sashForm = new FormStyleSashForm(this.form.getBody(), 256, this.formToolkit){

            protected void createContents() {
                EcoreBrowser.this.createLeftPane((Composite)this);
                EcoreBrowser.this.createTreePane((Composite)this);
            }
        };
        this.setupInitialTreeFont();
        this.sashForm.setWeights(new int[]{35, 65});
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EcoreBrowser.this.markNavigationLocation();
            }
        });
        this.metaclassViewer.selectRootElement();
        this.createContextMenuFor((StructuredViewer)this.treeViewer);
        DragAdapter.create((StructuredViewer)this.treeViewer);
        IDialogSettings settingsForCurrentMetamodel = this.settingsPersistence.loadLastSettingsForCurrentMetamodel();
        List<Facet> lastFacets = this.settingsPersistence.getLastFacets(settingsForCurrentMetamodel);
        for (Facet facet : lastFacets) {
            this.browserConfiguration.loadFacet(facet);
        }
        this.loadDefaultCustomization();
        List<MetamodelView> lastCustomizations = this.settingsPersistence.getLastCustomizations(settingsForCurrentMetamodel);
        this.loadCustomizations(lastCustomizations);
        this.reloadModel();
        this.reloadOnFacetChange();
    }

    public String getMetamodelURI() {
        try {
            EObject eObject;
            EClass eClass;
            EList contents = this.model.getContents();
            if (contents.size() > 0 && (eClass = (eObject = (EObject)contents.get(0)).eClass()) != null) {
                return eClass.getEPackage().getNsURI();
            }
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)MoDiscoBrowserPlugin.getPlugin());
        }
        return "";
    }

    protected void initResourceSet() {
        this.fResourceSet = this.createResourceSet();
        this.browserConfiguration.setResourceSet(this.fResourceSet);
        HashSet<Resource> browsedResources = new HashSet<Resource>();
        if (this.model == null) {
            this.model = this.createModel();
        }
        Resource mainResource = this.model;
        browsedResources.add(mainResource);
        this.loadDefaultFacetSet(mainResource);
        this.addReferencedResources(mainResource, browsedResources);
        this.browserConfiguration.setBrowsedResources(browsedResources);
        this.browserConfiguration.initInstancesForMetaclasses();
        InstancesForMetaclasses instancesForMetaclasses = this.browserConfiguration.getInstancesForMetaclasses();
        instancesForMetaclasses.addMetaclasses(this.browserConfiguration.getAllClasses());
        instancesForMetaclasses.buildDerivationTree();
        this.browserConfiguration.getFacetContext().setResources(browsedResources);
        for (Resource resource : browsedResources) {
            instancesForMetaclasses.addElementsFrom(resource);
        }
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    private void loadDefaultFacetSet(Resource resource) {
        for (EObject root : resource.getContents()) {
            EPackage rootEPackage = root.eClass().getEPackage();
            FacetSet facetSet = FacetSetCatalog.getSingleton().getDefaultFacetSet(rootEPackage);
            if (facetSet == null) continue;
            this.browserConfiguration.getFacetContext().addFacetSet(facetSet);
        }
    }

    private void addReferencedResources(Resource resource, Set<Resource> allResources) {
        this.addReferencedResourcesInternal(resource, allResources, 1);
    }

    private void addReferencedResourcesInternal(Resource resource, Set<Resource> allResources, int currentDepth) {
        HashSet<Resource> directReferencedResources = new HashSet<Resource>();
        for (EObject root : resource.getContents()) {
            Map externalReferences = EcoreUtil.ExternalCrossReferencer.find((EObject)root);
            if (externalReferences.isEmpty()) continue;
            int loadingDepth = this.browserConfiguration.getReferencedResourcesLoadingDepth();
            if (loadingDepth == -2) {
                int defaultLoadingDepth = MoDiscoBrowserPlugin.getPlugin().getPreferenceStore().getInt("browser_loading_depth");
                if (MoDiscoBrowserPlugin.getPlugin().getPreferenceStore().getBoolean("browser_ask_loading_depth")) {
                    loadingDepth = this.askUserForDepthToLoadReferencedResources(defaultLoadingDepth);
                } else {
                    loadingDepth = defaultLoadingDepth;
                    if (loadingDepth < -1) {
                        loadingDepth = 0;
                    }
                }
                this.browserConfiguration.setReferencedResourcesLoadingDepth(loadingDepth);
            }
            if (loadingDepth != -1 && loadingDepth < currentDepth) {
                return;
            }
            for (EObject external : externalReferences.keySet()) {
                Resource externalResource = external.eIsProxy() ? EcoreUtil.resolve((EObject)external, (EObject)root).eResource() : external.eResource();
                if (externalResource != null) {
                    directReferencedResources.add(externalResource);
                    continue;
                }
                MoDiscoLogger.logError((String)("Failed to load an external element: " + external.eClass().getName() + " " + EcoreUtil.getURI((EObject)external)), (Plugin)MoDiscoBrowserPlugin.getPlugin());
            }
        }
        int loadingDepth = this.browserConfiguration.getReferencedResourcesLoadingDepth();
        for (Resource directlyReferencedResource : directReferencedResources) {
            if (allResources.contains(directlyReferencedResource)) continue;
            allResources.add(directlyReferencedResource);
            if (loadingDepth != -1 && currentDepth + 1 > loadingDepth) continue;
            this.addReferencedResourcesInternal(directlyReferencedResource, allResources, currentDepth + 1);
        }
    }

    private int askUserForDepthToLoadReferencedResources(int initialValue) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String inputText) {
                if ("*".equals(inputText)) {
                    return null;
                }
                try {
                    Integer.parseInt(inputText);
                }
                catch (NumberFormatException e) {
                    return NLS.bind((String)Messages.EcoreBrowser_notAPositiveInteger, (Object)inputText);
                }
                return null;
            }
        };
        String initialValueStr = initialValue == -1 ? "*" : Integer.toString(initialValue);
        InputDialog inputDialog = new InputDialog(this.getSite().getShell(), Messages.EcoreBrowser_selectDepthReferencedResources, String.valueOf(Messages.EcoreBrowser_modelContainsProxies) + Messages.EcoreBrowser_chooseLoadProxiesDepth, initialValueStr, validator);
        if (inputDialog.open() == 0) {
            String value = inputDialog.getValue();
            if (value == null) {
                return 0;
            }
            if ("*".equals(value)) {
                return -1;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                MoDiscoBrowserPlugin.logException(e);
                return 0;
            }
        }
        return 0;
    }

    public void reloadModel() {
        this.initResourceSet();
        this.metaclassViewer.reload();
        this.internalRefreshTree();
    }

    protected void reloadModelViewer() {
        this.metaclassViewer.reload();
        this.internalRefreshTree();
    }

    protected void createLeftPane(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 320);
        section.setText(Messages.EcoreBrowser_metaclasses);
        Composite listPaneComposite = this.formToolkit.createComposite((Composite)section);
        section.setClient((Control)listPaneComposite);
        this.leftPane = new LeftPane((Composite)section, listPaneComposite, this.browserConfiguration, this.formToolkit);
        Composite toolBar = this.leftPane.getToolBarComposite();
        section.setTextClient((Control)toolBar);
        listPaneComposite.setLayout((Layout)new FillLayout());
        this.metaclassViewer = this.leftPane.getMetaclassViewer();
        this.metaclassViewer.addSelectionChangedListener(new MetaclassListViewerSelectionChangedListener());
    }

    protected void createTreePane(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 320);
        section.setText(Messages.EcoreBrowser_instances);
        Composite treePane = this.formToolkit.createComposite((Composite)section, 0);
        section.setClient((Control)treePane);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        treePane.setLayout((Layout)layout);
        Composite treeToolBar = this.createTreeToolBar((Composite)section);
        section.setTextClient((Control)treeToolBar);
        this.createSearchPanel(treePane);
        this.fTree = this.formToolkit.createTree(treePane, 2050);
        GridData treeGridData = new GridData();
        treeGridData.grabExcessHorizontalSpace = true;
        treeGridData.grabExcessVerticalSpace = true;
        treeGridData.horizontalAlignment = 4;
        treeGridData.verticalAlignment = 4;
        this.fTree.setLayoutData((Object)treeGridData);
        this.fTree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    EcoreBrowser.this.searchBox.setText("");
                    EcoreBrowser.this.search();
                } else if (e.keyCode == 13) {
                    EcoreBrowser.this.handleEnter();
                } else if (e.keyCode == 99 && e.stateMask == 262144) {
                    EcoreBrowser.this.handleCopyToClipboard();
                } else if (e.keyCode == 127) {
                    EcoreBrowser.this.handleDel();
                }
            }
        });
        this.customTreePainter = new CustomTreePainter(this.fTree, this.browserConfiguration);
        FacetTooltip.create(this.fTree, this.customTreePainter);
        this.treeViewer = new TreeViewer(this.fTree);
        this.treeViewer.setUseHashlookup(true);
        this.hookViewerToSelection((Viewer)this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new BrowserContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new BrowserLabelProvider());
        this.registerShowPropertyViewOnDblClick(this.fTree);
    }

    protected void handleEnter() {
        ISelection selection = this.getEditorSelection();
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            Object selectedElement = treeSelection.getFirstElement();
            if (selectedElement instanceof ModelElementItem) {
                this.browse();
            } else if (selectedElement instanceof AttributeItem || selectedElement instanceof LinkItem) {
                this.openPropertiesView();
            } else if (selectedElement instanceof QueryItem) {
                QueryItem queryItem = (QueryItem)selectedElement;
                SelectedQuery query = queryItem.getQuery();
                query.executeQuery();
            }
        }
    }

    protected void handleDel() {
        ISelection selection = this.getEditorSelection();
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            for (Object selectedElement : treeSelection) {
                if (!(selectedElement instanceof QueryItem)) continue;
                QueryItem queryItem = (QueryItem)selectedElement;
                this.browserConfiguration.getSelectedQueriesManager().remove(queryItem.getQuery());
            }
        }
    }

    private void handleCopyToClipboard() {
        ISelection selection = this.getEditorSelection();
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            StringBuilder builder = new StringBuilder();
            Iterator iterator = treeSelection.iterator();
            while (iterator.hasNext()) {
                Object selectedElement;
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                if ((selectedElement = iterator.next()) instanceof ModelElementItem) {
                    ModelElementItem modelElementItem = (ModelElementItem)selectedElement;
                    builder.append(modelElementItem.getName());
                    continue;
                }
                if (selectedElement instanceof AttributeItem) {
                    AttributeItem attributeItem = (AttributeItem)selectedElement;
                    String valueText = attributeItem.getValueText();
                    String strEquals = " = ";
                    if (valueText.startsWith(" = ")) {
                        builder.append(valueText.substring(" = ".length()));
                        continue;
                    }
                    builder.append(valueText);
                    continue;
                }
                if (selectedElement instanceof LinkItem) {
                    LinkItem linkItem = (LinkItem)selectedElement;
                    builder.append(linkItem.getReference().getName());
                    continue;
                }
                if (selectedElement instanceof ITreeElement) {
                    ITreeElement treeElement = (ITreeElement)selectedElement;
                    builder.append(treeElement.getText());
                    continue;
                }
                builder.append(selectedElement.toString());
            }
            Clipboard clipboard = new Clipboard(Display.getDefault());
            clipboard.setContents(new Object[]{builder.toString()}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    private void setupInitialTreeFont() {
        this.setupPreferredFont();
        this.fontChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.jface.dialogfont")) {
                    EcoreBrowser.this.setupPreferredFont();
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fontChangeListener);
    }

    private void setupPreferredFont() {
        FontDescriptor descriptor = FontDescriptor.createFrom((Font)JFaceResources.getDialogFont());
        descriptor = descriptor.increaseHeight(this.browserConfiguration.getFontSizeDelta());
        Font customFont = descriptor.createFont((Device)Display.getDefault());
        descriptor = descriptor.setStyle(2);
        Font customItalicFont = descriptor.createFont((Device)Display.getDefault());
        this.browserConfiguration.setCustomFont(customFont);
        this.browserConfiguration.setCustomItalicFont(customItalicFont);
        this.fTree.setFont(customFont);
        this.treeViewer.refresh();
        this.metaclassViewer.setFont(customFont);
        this.metaclassViewer.refresh();
    }

    private Composite createTreeToolBar(Composite parent) {
        Composite treeToolBarComposite = new Composite(parent, 64);
        this.instancesToolBar = TreeToolBar.create(treeToolBarComposite, this);
        return treeToolBarComposite;
    }

    private void registerShowPropertyViewOnDblClick(final Tree tree) {
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                boolean handled = false;
                if (event.button == 1) {
                    TreeItem[] selection;
                    TreeItem[] treeItemArray = selection = tree.getSelection();
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem treeItem = treeItemArray[n2];
                        Object element = treeItem.getData();
                        if (element instanceof QueryItem) {
                            QueryItem queryItem = (QueryItem)element;
                            SelectedQuery query = queryItem.getQuery();
                            query.executeQuery();
                            handled = true;
                        }
                        ++n2;
                    }
                    if (!handled) {
                        EcoreBrowser.this.openPropertiesView();
                    }
                }
            }
        });
    }

    protected void createSearchPanel(Composite parent) {
        Composite searchPanel = new Composite(parent, 0);
        searchPanel.setLayout((Layout)new GridLayout());
        searchPanel.setLayout((Layout)new FillLayout());
        GridData searchPanelGridData = new GridData();
        searchPanelGridData.grabExcessHorizontalSpace = true;
        searchPanelGridData.horizontalAlignment = 4;
        searchPanel.setLayoutData((Object)searchPanelGridData);
        this.searchBox = new Text(searchPanel, 128);
        this.searchBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    EcoreBrowser.this.search();
                } else if (e.keyCode == 27) {
                    EcoreBrowser.this.searchBox.setText("");
                    EcoreBrowser.this.search();
                }
            }
        });
        this.searchBox.setMessage(Messages.EcoreBrowser_typeFilterText);
    }

    protected void search() {
        final String searchText = this.searchBox.getText().toLowerCase();
        if (searchText.trim().length() == 0) {
            if (this.savedInput != null && this.savedInput != this.treeViewer.getInput()) {
                this.treeViewer.setInput(this.savedInput);
            }
            return;
        }
        final List<EClass> selectedMetaclasses = this.findSelectedEClasses();
        if (selectedMetaclasses.isEmpty()) {
            return;
        }
        this.searchJob = new Job(Messages.EcoreBrowser_jobName_SearchInModelEditor){

            protected IStatus run(IProgressMonitor monitor) {
                ResourceSet resourceSet = EcoreBrowser.this.fResourceSet;
                EList resources = resourceSet.getResources();
                if (resources.size() < 1) {
                    return Status.OK_STATUS;
                }
                final SearchResults searchResults = new SearchResults(EcoreBrowser.this.browserConfiguration);
                Resource resource = (Resource)resources.get(0);
                TreeIterator allContents = resource.getAllContents();
                while (allContents.hasNext()) {
                    ModelElementItem modelElementItem;
                    String objectText;
                    EObject eObject = (EObject)allContents.next();
                    if (selectedMetaclasses.contains(eObject.eClass()) && (objectText = (modelElementItem = new ModelElementItem(eObject, null, EcoreBrowser.this.browserConfiguration)).getName().toLowerCase()).contains(searchText)) {
                        searchResults.add(eObject);
                    }
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        EcoreBrowser.this.treeViewer.setSelection(null);
                        EcoreBrowser.this.treeViewer.setInput((Object)searchResults);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.searchJob.setUser(true);
        this.searchJob.setPriority(30);
        this.searchJob.schedule();
    }

    private List<EClass> findSelectedEClasses() {
        ArrayList<EClass> selectedMetaclasses = new ArrayList<EClass>();
        ISelection selection = this.metaclassViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (!(element instanceof InstancesForMetaclass)) continue;
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)element;
                this.addMetaclassToSelection(instancesForMetaclass, selectedMetaclasses, this.browserConfiguration.isDisplayInstancesOfSubclasses());
            }
        }
        return selectedMetaclasses;
    }

    private void addMetaclassToSelection(InstancesForMetaclass instancesForMetaclass, ArrayList<EClass> selectedMetaclasses, boolean addSubclasses) {
        selectedMetaclasses.add(instancesForMetaclass.getEClass());
        if (addSubclasses) {
            InstancesForMetaclass[] subclasses;
            InstancesForMetaclass[] instancesForMetaclassArray = subclasses = instancesForMetaclass.getSubclasses();
            int n = subclasses.length;
            int n2 = 0;
            while (n2 < n) {
                InstancesForMetaclass subclass = instancesForMetaclassArray[n2];
                this.addMetaclassToSelection(subclass, selectedMetaclasses, addSubclasses);
                ++n2;
            }
        }
    }

    public void setShowEmptyLinks(boolean value) {
        this.browserConfiguration.setShowEmptyLinks(value);
        this.internalRefreshTree();
    }

    public boolean isShowEmptyLinks() {
        return this.browserConfiguration.isShowEmptyLinks();
    }

    public void setSortInstances(boolean value) {
        this.browserConfiguration.setSortInstances(value);
        this.internalRefreshTree();
    }

    public boolean isSortInstances() {
        return this.browserConfiguration.isSortInstances();
    }

    public void setShowDerivedLinks(boolean value) {
        this.browserConfiguration.setShowDerivedLinks(value);
        this.internalRefreshTree();
    }

    public boolean isShowDerivedLinks() {
        return this.browserConfiguration.isShowDerivedLinks();
    }

    public void setShowFullQualifiedNames(boolean value) {
        this.browserConfiguration.setShowFullQualifiedNames(value);
        this.internalRefreshTree();
        this.metaclassViewer.refresh();
    }

    public boolean isShowFullQualifiedNames() {
        return this.browserConfiguration.isShowFullQualifiedNames();
    }

    public void setShowMultiplicity(boolean value) {
        this.browserConfiguration.setShowMultiplicity(value);
        this.internalRefreshTree();
    }

    public boolean isShowMultiplicity() {
        return this.browserConfiguration.isShowMultiplicity();
    }

    public void setShowOppositeLinks(boolean value) {
        this.browserConfiguration.setShowOppositeLinks(value);
        this.internalRefreshTree();
    }

    public boolean isShowOppositeLinks() {
        return this.browserConfiguration.isShowOppositeLinks();
    }

    public void setShowContainer(boolean value) {
        this.browserConfiguration.setShowContainer(value);
        this.internalRefreshTree();
    }

    public boolean isShowContainer() {
        return this.browserConfiguration.isShowContainer();
    }

    public void setSortLinks(boolean value) {
        this.browserConfiguration.setSortLinks(value);
        this.internalRefreshTree();
    }

    public boolean isSortLinks() {
        return this.browserConfiguration.isSortLinks();
    }

    public void setSortLinksByType(boolean value) {
        this.browserConfiguration.setSortLinksByType(value);
        this.internalRefreshTree();
    }

    public boolean isSortLinksByType() {
        return this.browserConfiguration.isSortLinksByType();
    }

    public void setShowAttributes(boolean value) {
        this.browserConfiguration.setShowAttributes(value);
        this.internalRefreshTree();
    }

    public boolean isShowAttributes() {
        return this.browserConfiguration.isShowAttributes();
    }

    public void setShowEmptyAttributes(boolean value) {
        this.browserConfiguration.setShowEmptyAttributes(value);
        this.internalRefreshTree();
    }

    public boolean isShowEmptyAttributes() {
        return this.browserConfiguration.isShowEmptyAttributes();
    }

    public void setFontSizeDelta(int value) {
        this.browserConfiguration.setFontSizeDelta(value);
        this.setupPreferredFont();
    }

    public int getFontSizeDelta() {
        return this.browserConfiguration.getFontSizeDelta();
    }

    public void setShowOrdering(boolean value) {
        this.browserConfiguration.setShowOrdering(value);
        this.internalRefreshTree();
    }

    public boolean isShowOrdering() {
        return this.browserConfiguration.isShowOrdering();
    }

    public void setShowTypeOfLinks(boolean value) {
        this.browserConfiguration.setShowTypeOfLinks(value);
        this.internalRefreshTree();
    }

    public boolean isShowTypeOfLinks() {
        return this.browserConfiguration.isShowTypeOfLinks();
    }

    public void setShowElementIDs(boolean value) {
        this.browserConfiguration.setShowElementIDs(value);
        this.internalRefreshTree();
    }

    public boolean isShowElementIDs() {
        return this.browserConfiguration.isShowElementIDs();
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage(){};
            this.propertySheetPage.setPropertySourceProvider(new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    PropertySourceAdapterFactory propertySourceAdapterFactory = new PropertySourceAdapterFactory(EcoreBrowser.this.browserConfiguration);
                    Object adapted = propertySourceAdapterFactory.adapt(object, IPropertySource.class);
                    if (adapted instanceof IPropertySource) {
                        IPropertySource propertySource = (IPropertySource)adapted;
                        return propertySource;
                    }
                    return null;
                }
            });
        }
        return this.propertySheetPage;
    }

    public boolean isDirty() {
        return false;
    }

    public void doSave(IProgressMonitor progressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        try {
            this.setSite((IWorkbenchPartSite)site);
            this.setInputWithNotify(editorInput);
            this.setPartName(editorInput.getName());
            site.setSelectionProvider((ISelectionProvider)this);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            MoDiscoBrowserPlugin.logException(e);
        }
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return EcoreBrowser.unwrapSelection(this.editorSelection);
    }

    public ISelection getEditorSelection() {
        return this.editorSelection;
    }

    public static ISelection unwrapSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<Object> elements = new ArrayList<Object>();
            for (Object element : structuredSelection) {
                if (element instanceof ModelElementItem) {
                    ModelElementItem modelElementItem = (ModelElementItem)element;
                    elements.add(modelElementItem.getEObject());
                    continue;
                }
                if (element instanceof LinkItem) {
                    LinkItem linkItem = (LinkItem)element;
                    elements.add(linkItem.getReference());
                    continue;
                }
                if (element instanceof AttributeItem) {
                    AttributeItem attributeItem = (AttributeItem)element;
                    elements.add(attributeItem.getAttribute());
                    continue;
                }
                elements.add(element);
            }
            return new StructuredSelection(elements);
        }
        return selection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            if (listener instanceof IBrowserSelectionChangedListener) {
                listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                continue;
            }
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, EcoreBrowser.unwrapSelection(selection)));
        }
        this.setStatusLineMessage(selection);
    }

    private void hookViewerToSelection(Viewer viewer) {
        if (viewer == null) {
            return;
        }
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    EcoreBrowser.this.setSelection(selectionChangedEvent.getSelection());
                }
            };
        }
        viewer.addSelectionChangedListener(this.selectionChangedListener);
        this.setSelection(viewer.getSelection());
    }

    public void setStatusLineMessage(ISelection selection) {
        block5: {
            IStatusLineManager statusLineManager;
            block6: {
                statusLineManager = this.getActionBars().getStatusLineManager();
                if (statusLineManager == null) break block5;
                if (!(selection instanceof IStructuredSelection)) break block6;
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(Messages.EcoreBrowser_noObjectSelected);
                        break;
                    }
                    case 1: {
                        Object object = collection.iterator().next();
                        if (object instanceof ITreeElement) {
                            ITreeElement treeElement = (ITreeElement)object;
                            statusLineManager.setMessage(NLS.bind((String)Messages.EcoreBrowser_singleObjectSelected, (Object)treeElement.getText()));
                            break;
                        }
                        break block5;
                    }
                    default: {
                        statusLineManager.setMessage(NLS.bind((String)Messages.EcoreBrowser_multiObjectSelected, (Object)Integer.toString(collection.size())));
                        break;
                    }
                }
                break block5;
            }
            statusLineManager.setMessage("");
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public BrowserActionBarContributor getActionBarContributor() {
        return (BrowserActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        this.adapterFactoryWithRegistry.dispose();
        this.sashForm.dispose();
        if (!this.browingRegistryResource) {
            final EList resources = this.fResourceSet.getResources();
            Job cleanupJob = new Job(Messages.EcoreBrowser_jobName_UnloadResources){

                protected IStatus run(IProgressMonitor monitor) {
                    for (Resource resource : resources) {
                        resource.unload();
                    }
                    return Status.OK_STATUS;
                }
            };
            cleanupJob.setPriority(50);
            cleanupJob.setSystem(true);
            cleanupJob.schedule();
        }
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.treeViewer != null && this.selectionChangedListener != null) {
            this.treeViewer.removeSelectionChangedListener(this.selectionChangedListener);
            this.selectionChangedListener = null;
        }
        this.browserConfiguration.setCustomFont(null);
        this.browserConfiguration.setCustomItalicFont(null);
        this.browserConfiguration.clearEditor();
        JFaceResources.getFontRegistry().removeListener(this.fontChangeListener);
        this.customTreePainter.dispose();
        this.browserConfiguration.getCustomizationEngine().dispose();
        this.fCustomizationEngineChangeListener = null;
        FacetSetCatalog.getSingleton().removeChangeListener(this.fFacetsChangeListener);
        this.formToolkit.dispose();
        super.dispose();
    }

    public void browse() {
        ITreeSelection treeSelection;
        Object selectedElement;
        ISelection selection = this.getEditorSelection();
        if (selection instanceof ITreeSelection && (selectedElement = (treeSelection = (ITreeSelection)selection).getFirstElement()) instanceof ModelElementItem) {
            ModelElementItem modelElementItem = (ModelElementItem)selectedElement;
            this.browseTo(modelElementItem);
        }
    }

    public void browseTo(ModelElementItem modelElementItem) {
        EObject modelElement = modelElementItem.getEObject();
        this.browseTo(modelElement);
    }

    public void browseTo(EObject modelElement) {
        this.markNavigationLocation();
        String classQualifiedName = ModelUtils.getMetaclassQualifiedName((EClassifier)modelElement.eClass());
        this.metaclassViewer.selectMetaclass(classQualifiedName);
        TreePath treePath = this.findTreePathForElement(modelElement);
        if (treePath != null) {
            this.treeViewer.setSelection(null);
            this.treeViewer.setSelection((ISelection)new TreeSelection(treePath), true);
            this.markNavigationLocation();
        }
    }

    public void browseToByURI(URI eProxyURI) {
        EObject eObject = EMFUtil.findElementByURI(eProxyURI, this.fResourceSet);
        if (eObject != null) {
            this.browseTo(eObject);
        }
    }

    private TreePath findTreePathForElement(EObject eObject) {
        Object input = this.treeViewer.getInput();
        if (input instanceof MetaclassList) {
            MetaclassList metaclassListItemProvider = (MetaclassList)input;
            Collection<?> elements = metaclassListItemProvider.getElements();
            for (Object element : elements) {
                ModelElementItem other;
                if (element instanceof BigListItem) {
                    BigListItem bigListItemProvider = (BigListItem)element;
                    List<ModelElementItem> subElements = bigListItemProvider.getChildren();
                    for (Object e : subElements) {
                        ModelElementItem other2;
                        if (!(e instanceof ModelElementItem) || !(other2 = (ModelElementItem)e).getEObject().equals(eObject)) continue;
                        return new TreePath(new Object[]{e});
                    }
                }
                if (!(element instanceof ModelElementItem) || !(other = (ModelElementItem)element).getEObject().equals(eObject)) continue;
                return new TreePath(new Object[]{element});
            }
        }
        return null;
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new BrowserNavigationLocation((IEditorPart)this);
    }

    public INavigationLocation createNavigationLocation() {
        String firstSelectedMetaclass = this.metaclassViewer.getFirstSelectedMetaclassQualifiedName();
        return new BrowserNavigationLocation((IEditorPart)this, firstSelectedMetaclass, (ITreeSelection)this.treeViewer.getSelection());
    }

    protected void markNavigationLocation() {
        this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
    }

    public void restoreLocation(String metaclassQualifiedName, ITreeSelection selection) {
        this.metaclassViewer.selectMetaclass(metaclassQualifiedName);
        this.treeViewer.setSelection((ISelection)selection);
    }

    public void refreshTreeDelayed() {
        if (this.refreshJob == null) {
            this.refreshJob = new Job(Messages.EcoreBrowser_refreshingModelViewers){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            EcoreBrowser.this.internalRefreshTree();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
        } else {
            this.refreshJob.cancel();
        }
        this.refreshJob.setPriority(10);
        this.refreshJob.schedule();
    }

    private void internalRefreshTree() {
        if (!this.treeViewer.getTree().isDisposed()) {
            try {
                this.treeViewer.getTree().setRedraw(false);
                this.treeViewer.refresh();
            }
            finally {
                this.treeViewer.getTree().setRedraw(true);
            }
        }
    }

    public BrowserConfiguration getBrowserConfiguration() {
        return this.browserConfiguration;
    }

    private void openPropertiesView() {
        try {
            this.getEditorSite().getPage().showView(PROPERTY_VIEW_ID);
        }
        catch (PartInitException e) {
            MoDiscoBrowserPlugin.logException(e);
        }
    }

    public ResourceSet getResourceSet() {
        return this.fResourceSet;
    }

    public void loadCustomizations(List<MetamodelView> customizationsToLoad) {
        CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
        if (this.fCustomizationEngineChangeListener == null) {
            this.fCustomizationEngineChangeListener = new BrowserConfiguration.ChangeListener(){

                public void changed() {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            EcoreBrowser.this.getMetaclassViewer().refresh();
                            EcoreBrowser.this.refreshTreeDelayed();
                        }
                    });
                }
            };
            customizationEngine.addChangeListener(this.fCustomizationEngineChangeListener);
        }
        customizationEngine.clear();
        for (MetamodelView customizationToLoad : customizationsToLoad) {
            customizationEngine.registerCustomization(customizationToLoad);
        }
        customizationEngine.loadCustomizations();
    }

    private void loadDefaultCustomization() {
        this.loadCustomizations(CustomizationsCatalog.getInstance().getRegistryDefaultCustomizations());
    }

    protected TreeToolBar getInstancesToolBar() {
        return this.instancesToolBar;
    }

    protected void reloadOnFacetChange() {
        if (this.fFacetsChangeListener == null) {
            this.fFacetsChangeListener = new AbstractMoDiscoCatalog.ModiscoCatalogChangeListener(){

                private void changed() {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ArrayList<String> facetsToReload = new ArrayList<String>();
                            Set<Facet> loadedFacets = EcoreBrowser.this.getBrowserConfiguration().getLoadedFacets();
                            for (Facet facet : loadedFacets) {
                                FacetSet facetSet = (FacetSet)facet.eContainer();
                                facetsToReload.add(String.valueOf(facetSet.getName()) + "#" + facet.getName());
                            }
                            EcoreBrowser.this.getBrowserConfiguration().cleanFacets(false);
                            Collection allFacetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
                            for (FacetSet facetSet : allFacetSets) {
                                EList facets = facetSet.getFacets();
                                block2: for (Facet facet : facets) {
                                    for (String fullname : facetsToReload) {
                                        if (!fullname.equals(String.valueOf(facetSet.getName()) + "#" + facet.getName())) continue;
                                        EcoreBrowser.this.getBrowserConfiguration().loadFacet(facet);
                                        continue block2;
                                    }
                                }
                            }
                            EcoreBrowser.this.reloadModel();
                        }
                    });
                }

                public void removed(IFile file) {
                    this.changed();
                }

                public void changed(EObject eObject, IFile file) {
                    this.changed();
                }

                public void added(EObject eObject, IFile file) {
                    this.changed();
                }
            };
            FacetSetCatalog.getSingleton().addChangeListener(this.fFacetsChangeListener);
        }
    }

    private final class MetaclassListViewerSelectionChangedListener
    implements ISelectionChangedListener {
        private final HashMap<String, ITreeSelection> selections = new HashMap();
        private String lastSelectedMetaclass = null;

        private MetaclassListViewerSelectionChangedListener() {
        }

        private InstancesForMetaclass[] getEntriesForSelection(ISelection selection) {
            ArrayList<InstancesForMetaclass> instancesForMetaclasses = new ArrayList<InstancesForMetaclass>();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object element : structuredSelection) {
                    if (!(element instanceof InstancesForMetaclass)) continue;
                    InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)element;
                    instancesForMetaclasses.add(instancesForMetaclass);
                }
            }
            return instancesForMetaclasses.toArray(new InstancesForMetaclass[instancesForMetaclasses.size()]);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.lastSelectedMetaclass != null) {
                this.selections.put(this.lastSelectedMetaclass, (ITreeSelection)EcoreBrowser.this.treeViewer.getSelection());
            }
            ISelection metaclassSelection = event.getSelection();
            InstancesForMetaclass[] entries = this.getEntriesForSelection(metaclassSelection);
            ITreeSelection savedSelection = null;
            MetaclassList input = null;
            if (entries.length > 0) {
                savedSelection = this.selections.get(entries[0].getClassQualifiedName());
                String[] selectedMetaclassesNames = new String[entries.length];
                int i = 0;
                InstancesForMetaclass[] instancesForMetaclassArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    InstancesForMetaclass entry = instancesForMetaclassArray[n2];
                    selectedMetaclassesNames[i++] = entry.getClassQualifiedName();
                    ++n2;
                }
                input = new MetaclassList(EcoreBrowser.this.browserConfiguration, selectedMetaclassesNames);
                this.lastSelectedMetaclass = entries[0].getClassQualifiedName();
            } else {
                this.lastSelectedMetaclass = null;
            }
            try {
                EcoreBrowser.this.treeViewer.getTree().setRedraw(false);
                EcoreBrowser.this.searchBox.setText("");
                EcoreBrowser.this.treeViewer.setSelection(null);
                EcoreBrowser.this.treeViewer.setInput(input);
                EcoreBrowser.this.savedInput = input;
                EcoreBrowser.this.treeViewer.setSelection((ISelection)savedSelection, true);
            }
            finally {
                EcoreBrowser.this.treeViewer.getTree().setRedraw(true);
            }
            EcoreBrowser.this.markNavigationLocation();
        }
    }
}

