/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmt.modisco.common.core.utils.UriUtils;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class WorkspaceChangeListener
implements IResourceChangeListener {
    private final EcoreBrowser fBrowser;

    public WorkspaceChangeListener(EcoreBrowser browser) {
        this.fBrowser = browser;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta eventDelta = event.getDelta();
        try {
            class ResourceDeltaVisitor
            implements IResourceDeltaVisitor {
                private final ResourceSet resourceSet;

                ResourceDeltaVisitor() {
                    this.resourceSet = WorkspaceChangeListener.this.fBrowser.getResourceSet();
                }

                public boolean visit(final IResourceDelta delta) {
                    Resource resource;
                    if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(UriUtils.createUri((String)delta.getFullPath().toString()), false)) != null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                if (delta.getKind() == 2) {
                                    EcoreBrowser browser = WorkspaceChangeListener.this.fBrowser;
                                    browser.getSite().getPage().closeEditor((IEditorPart)browser, false);
                                    return;
                                }
                                WorkspaceChangeListener.this.fBrowser.reloadModel();
                            }
                        });
                        return false;
                    }
                    return true;
                }
            }
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
            eventDelta.accept((IResourceDeltaVisitor)visitor);
        }
        catch (CoreException exception) {
            MoDiscoBrowserPlugin.logException(exception);
        }
    }
}

