/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors;

import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.actions.BrowseAction;
import org.eclipse.gmt.modisco.infra.browser.actions.DecreaseFontSizeAction;
import org.eclipse.gmt.modisco.infra.browser.actions.ExecuteQueryAction;
import org.eclipse.gmt.modisco.infra.browser.actions.ExecuteSelectedQueryAction;
import org.eclipse.gmt.modisco.infra.browser.actions.IBrowserActionBarContributor;
import org.eclipse.gmt.modisco.infra.browser.actions.IncreaseFontSizeAction;
import org.eclipse.gmt.modisco.infra.browser.actions.LoadCustomizationsAction;
import org.eclipse.gmt.modisco.infra.browser.actions.LoadFacetsAction;
import org.eclipse.gmt.modisco.infra.browser.actions.OpenTableEditorAction;
import org.eclipse.gmt.modisco.infra.browser.actions.RefreshViewerAction;
import org.eclipse.gmt.modisco.infra.browser.actions.RemoveQueryAction;
import org.eclipse.gmt.modisco.infra.browser.actions.RestoreFontSizeAction;
import org.eclipse.gmt.modisco.infra.browser.actions.SelectQueryAction;
import org.eclipse.gmt.modisco.infra.browser.actions.ShowPropertiesViewAction;
import org.eclipse.gmt.modisco.infra.browser.core.ModelElementItem;
import org.eclipse.gmt.modisco.infra.browser.core.QueryItem;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.editors.IBrowserSelectionChangedListener;
import org.eclipse.gmt.modisco.infra.browser.editors.table.TableEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.EditorActionBarContributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserActionBarContributor
extends EditorActionBarContributor
implements IBrowserSelectionChangedListener,
IMenuListener,
IBrowserActionBarContributor {
    private IEditorPart fActiveEditor;
    private ISelectionProvider selectionProvider;
    private final IAction showPropertiesViewAction = new ShowPropertiesViewAction();
    private final IAction openTableEditorAction = new OpenTableEditorAction(this);
    private final IAction refreshViewerAction = new RefreshViewerAction(this);
    private final IAction selectQueryAction = new SelectQueryAction(this);
    private final IAction executeSelectedQueryAction = new ExecuteSelectedQueryAction(this);
    private final IAction removeQueryAction = new RemoveQueryAction(this);
    private final IAction executeQueryAction = new ExecuteQueryAction(this);
    private ISelection fSelection;
    private final Action browseAction = new BrowseAction(this);
    private final Action increaseFontSizeAction = new IncreaseFontSizeAction(this);
    private final Action decreaseFontSizeAction = new DecreaseFontSizeAction(this);
    private final Action restoreFontSizeAction = new RestoreFontSizeAction(this);
    private final Action loadCustomizationsAction = new LoadCustomizationsAction(this);
    private final Action loadFacetsAction = new LoadFacetsAction(this);

    @Override
    public EcoreBrowser getBrowser() {
        return (EcoreBrowser)this.fActiveEditor;
    }

    @Override
    public ISelection getSelection() {
        return this.fSelection;
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.increaseFontSizeAction);
        toolBarManager.add((IAction)this.decreaseFontSizeAction);
        toolBarManager.add((IAction)this.restoreFontSizeAction);
        toolBarManager.add((IAction)this.loadCustomizationsAction);
        toolBarManager.add((IAction)this.loadFacetsAction);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.fActiveEditor = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else if (part instanceof EcoreBrowser) {
            EcoreBrowser browser = (EcoreBrowser)part;
            this.selectionProvider = browser.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (browser.getEditorSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, browser.getEditorSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fSelection = event.getSelection();
    }

    private void updateActions(ISelection selection) {
        this.browseAction.setEnabled(this.enableBrowse(selection));
        this.openTableEditorAction.setEnabled(TableEditor.canBeOpenedOnSelection(selection));
    }

    private boolean enableBrowse(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                return false;
            }
            Object element = structuredSelection.getFirstElement();
            if (element instanceof ModelElementItem) {
                return true;
            }
        }
        return false;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        int nSelectedQueries;
        this.updateActions(this.getSelection());
        menuManager.add((IAction)this.browseAction);
        menuManager.add(this.openTableEditorAction);
        int nSelectedModelElementItems = this.selectionCount(ModelElementItem.class);
        if (nSelectedModelElementItems > 0) {
            menuManager.add(this.executeQueryAction);
            menuManager.add(this.selectQueryAction);
            if (nSelectedModelElementItems > 1) {
                this.selectQueryAction.setText(Messages.SelectQueryAction_addQueryOnElements);
            } else {
                this.selectQueryAction.setText(Messages.SelectQueryAction_addQueryOnElement);
            }
        }
        if ((nSelectedQueries = this.selectionCount(QueryItem.class)) > 0) {
            menuManager.add(this.executeSelectedQueryAction);
            menuManager.add(this.removeQueryAction);
            if (nSelectedQueries > 1) {
                this.executeSelectedQueryAction.setText(Messages.ExecuteQueryAction_executeQueries);
                this.removeQueryAction.setText(Messages.RemoveQueryAction_removeQueries);
            } else {
                this.executeSelectedQueryAction.setText(Messages.ExecuteQueryAction_executeSelectedQuery);
                this.removeQueryAction.setText(Messages.RemoveQueryAction_removeQuery);
            }
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.showPropertiesViewAction);
        menuManager.add(this.refreshViewerAction);
    }

    private int selectionCount(Class<?> clazz) {
        ISelection selection = this.getSelection();
        int count = 0;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (!clazz.isAssignableFrom(element.getClass())) continue;
                ++count;
            }
        }
        return count;
    }

    public IEditorPart getActiveEditor() {
        return this.fActiveEditor;
    }
}

