/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.gmt.modisco.common.core.utils.StringUtils;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.core.LinkItem;
import org.eclipse.gmt.modisco.infra.browser.core.ModelElementItem;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.editors.table.ColumnDescription;
import org.eclipse.gmt.modisco.infra.browser.editors.table.TableEditorContentProvider;
import org.eclipse.gmt.modisco.infra.browser.editors.table.TableEditorInput;
import org.eclipse.gmt.modisco.infra.browser.editors.table.TableEditorLabelProvider;
import org.eclipse.gmt.modisco.infra.browser.editors.table.TableEditorToolBar;
import org.eclipse.gmt.modisco.infra.browser.editors.table.TableSorter;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.facet.FacetStructuralFeature;
import org.eclipse.gmt.modisco.infra.facet.core.FacetContext;
import org.eclipse.gmt.modisco.infra.query.runtime.ModelQueryResult;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditor
extends EditorPart {
    private static final int LABEL_COLUMN_WIDTH = 125;
    private static final int DEFAULT_COLUMN_WIDTH = 100;
    private static final int MAX_INITIAL_COLUMN_WIDTH = 300;
    public static final String EDITOR_ID = "org.eclipse.gmt.modisco.infra.browser.table.editorID";
    private static final int USE_VIRTUAL_THRESHOLD = 1000;
    private static final String KEY_EMPTY_HIDDEN = "emptyHidden";
    private static final String KEY_NOT_COMMON_HIDDEN = "notCommonHidden";
    private TableViewer tableViewer;
    private TableEditorInput tableEditorInput;
    private TableEditorLabelProvider tableEditorLabelProvider;
    private List<ColumnDescription> columnsConfiguration;
    private TableEditorToolBar toolBar;
    private TableEditorContentProvider tableEditorContentProvider;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof TableEditorInput)) {
            throw new PartInitException("Input should be of type TableEditorInput");
        }
        this.tableEditorInput = (TableEditorInput)input;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(this.tableEditorInput);
        this.setPartName(Messages.TableEditor_tableViewer);
    }

    public void createPartControl(Composite parent) {
        Composite editorComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 2;
        editorComposite.setLayout((Layout)gridLayout);
        this.createToolBar(editorComposite);
        this.toolBar.setLabelText(this.tableEditorInput.getDescription());
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.horizontalAlignment = 4;
        tableGridData.verticalAlignment = 4;
        int virtualFlag = 0;
        if (this.tableEditorInput.getElements().size() > 1000) {
            virtualFlag = 0x10000000;
        }
        this.tableViewer = new TableViewer(editorComposite, 0x10304 | virtualFlag);
        this.tableViewer.getTable().setLayoutData((Object)tableGridData);
        this.tableViewer.getTable().setFont(this.tableEditorInput.getBrowserConfiguration().getCustomFont());
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableEditorContentProvider = new TableEditorContentProvider();
        this.columnsConfiguration = this.createColumnConfiguration(false);
        this.tableEditorLabelProvider = new TableEditorLabelProvider(this.columnsConfiguration, this.tableEditorInput.getBrowserConfiguration(), this.tableEditorInput.getContextMap());
        this.createColumns(this.columnsConfiguration);
        this.tableViewer.setContentProvider((IContentProvider)this.tableEditorContentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableEditorLabelProvider);
        this.tableViewer.setInput((Object)this.tableEditorInput);
        this.createContextMenu();
        this.registerOpenListeners();
        this.registerCloseWhenMainEditorClosed();
        this.packColumns();
    }

    private void createToolBar(Composite parent) {
        Composite toolBarComposite = new Composite(parent, 0);
        this.toolBar = new TableEditorToolBar(toolBarComposite, this);
    }

    private void registerCloseWhenMainEditorClosed() {
        EcoreBrowser editor = this.tableEditorInput.getBrowserConfiguration().getEditor();
        if (editor == null) {
            return;
        }
        editor.getEditorSite().getPage().addPartListener(new IPartListener(){

            public void partClosed(IWorkbenchPart part) {
                EcoreBrowser browser = TableEditor.this.tableEditorInput.getBrowserConfiguration().getEditor();
                if (browser != null && part == browser) {
                    TableEditor.this.getSite().getPage().closeEditor((IEditorPart)TableEditor.this, false);
                }
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        });
    }

    private void createContextMenu() {
        final Menu menu = new Menu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                MenuItem[] menuItems;
                Point clickedPoint = new Point(e.x, e.y);
                Point widgetRelativeClickedPoint = Display.getDefault().map(null, (Control)TableEditor.this.tableViewer.getTable(), clickedPoint);
                ViewerCell cell = TableEditor.this.tableViewer.getCell(widgetRelativeClickedPoint);
                int column = cell == null ? 0 : cell.getColumnIndex();
                MenuItem[] menuItemArray = menuItems = menu.getItems();
                int n = menuItems.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem menuItem = menuItemArray[n2];
                    menuItem.dispose();
                    ++n2;
                }
                ColumnDescription columnDescription = (ColumnDescription)TableEditor.this.columnsConfiguration.get(column);
                EObject element = null;
                Object mainElement = TableEditor.this.getSelectedElement();
                if (!(mainElement instanceof EObject)) {
                    return;
                }
                EObject mainModelElement = (EObject)mainElement;
                if (columnDescription.getType() == ColumnDescription.Type.REFERENCE) {
                    boolean oneElement = true;
                    if (columnDescription.getReference().isMany()) {
                        EList list = (EList)TableEditor.this.getStructuralFeatureValue(mainModelElement, (EStructuralFeature)columnDescription.getReference());
                        boolean bl = oneElement = list.size() == 1;
                    }
                    if (oneElement) {
                        element = TableEditor.this.findElementToOpenInModelBrowser(column);
                        if (element != null) {
                            this.createBrowseMenuItemFor(element);
                        }
                    } else {
                        this.createViewInTableMenuItemFor(mainModelElement, columnDescription.getReference());
                    }
                } else if (columnDescription.getType() == ColumnDescription.Type.ECONTAINER && (element = mainModelElement.eContainer()) != null) {
                    this.createBrowseMenuItemFor(element);
                }
                if (element != mainModelElement) {
                    this.createBrowseMenuItemFor(mainModelElement);
                }
                menu.setLocation(clickedPoint);
                menu.setVisible(true);
            }

            private void createBrowseMenuItemFor(final EObject element) {
                if (element == null) {
                    return;
                }
                String text = TableEditor.this.tableEditorLabelProvider.getTextFor(element);
                MenuItem browseMenuItem = new MenuItem(menu, 8);
                browseMenuItem.setText(NLS.bind((String)Messages.TableEditor_browse, (Object)StringUtils.truncateBeforeNewline((String)text)));
                browseMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TableEditor.this.openElementInModelBrowser(element);
                    }
                });
            }

            private void createViewInTableMenuItemFor(final EObject parentElement, final EReference reference) {
                final EList elements = (EList)TableEditor.this.getStructuralFeatureValue(parentElement, (EStructuralFeature)reference);
                MenuItem menuItem = new MenuItem(menu, 8);
                menuItem.setText(Messages.openTableEditorOnSelection);
                if (elements.size() == 0) {
                    menuItem.setEnabled(false);
                }
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BrowserConfiguration browserConfiguration = TableEditor.this.tableEditorInput.getBrowserConfiguration();
                        String description = TableEditor.getEditorDescriptionFor(parentElement, reference, browserConfiguration);
                        TableEditor.openOn(TableEditor.this.tableEditorInput.getBrowserConfiguration(), (List<? extends Object>)elements, description);
                    }
                });
            }
        });
    }

    private void registerOpenListeners() {
        this.tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ViewerCell cell = TableEditor.this.tableViewer.getCell(new Point(e.x, e.y));
                int column = cell == null ? 0 : cell.getColumnIndex();
                TableEditor.this.openSelectionInModelBrowser(column);
            }
        });
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    TableEditor.this.openSelectionInModelBrowser(0);
                }
            }
        });
    }

    private void packColumns() {
        TableColumn[] tableColumns;
        TableColumn[] tableColumnArray = tableColumns = this.tableViewer.getTable().getColumns();
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.pack();
            if (tableColumn.getWidth() > 300) {
                tableColumn.setWidth(300);
            }
            ++n2;
        }
    }

    private List<ColumnDescription> createColumnConfiguration(boolean hideEmptyColumns) {
        TableEditorInput.ElementsDescription elementsDescription = this.tableEditorInput.getElementsDescription();
        ArrayList<ColumnDescription> columns = new ArrayList<ColumnDescription>();
        columns.add(new ColumnDescription(ColumnDescription.Type.DEFAULT_LABEL));
        columns.add(new ColumnDescription(ColumnDescription.Type.METACLASS_NAME));
        if (elementsDescription.containsEObjects()) {
            columns.add(new ColumnDescription(ColumnDescription.Type.ECONTAINER));
        }
        if (this.tableEditorInput.getContextMap() != null) {
            columns.add(new ColumnDescription(ColumnDescription.Type.CONTEXT));
        }
        for (EAttribute attribute : this.tableEditorInput.getAttributes()) {
            if (hideEmptyColumns && this.isEmpty(attribute)) continue;
            columns.add(new ColumnDescription(attribute));
        }
        for (EReference reference : this.tableEditorInput.getReferences()) {
            if (reference.isDerived() || hideEmptyColumns && this.isEmpty(reference)) continue;
            columns.add(new ColumnDescription(reference));
        }
        for (EReference reference : this.tableEditorInput.getReferences()) {
            if (!reference.isDerived() || hideEmptyColumns && this.isEmpty(reference)) continue;
            columns.add(new ColumnDescription(reference));
        }
        return columns;
    }

    private boolean isEmpty(EReference reference) {
        Object[] elements;
        Object[] objectArray = elements = this.tableEditorContentProvider.getElements(this.tableEditorInput);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            EObject eObject;
            Object element = objectArray[n2];
            if (element instanceof EObject && this.hasStructuralFeature(eObject = (EObject)element, (EStructuralFeature)reference)) {
                EList list;
                Object value = this.getStructuralFeatureValue(eObject, (EStructuralFeature)reference);
                if (reference.isMany() ? !(list = (EList)value).isEmpty() : value != null) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean isEmpty(EAttribute attribute) {
        Object[] elements;
        Object[] objectArray = elements = this.tableEditorContentProvider.getElements(this.tableEditorInput);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            EObject eObject;
            Object element = objectArray[n2];
            if (element instanceof EObject && this.hasStructuralFeature(eObject = (EObject)element, (EStructuralFeature)attribute)) {
                EList list;
                Object value = this.getStructuralFeatureValue(eObject, (EStructuralFeature)attribute);
                if (attribute.isMany() ? !(list = (EList)value).isEmpty() : value != null) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private void createColumns(List<ColumnDescription> columns) {
        int columnIndex = 0;
        for (ColumnDescription columnDescription : columns) {
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
            TableColumn tableColumn = column.getColumn();
            tableColumn.setWidth(100);
            tableColumn.setResizable(true);
            tableColumn.setMoveable(true);
            column.getColumn().setData((Object)columnDescription);
            switch (columnDescription.getType()) {
                case DEFAULT_LABEL: {
                    tableColumn.setText(Messages.TableEditor_columnName_Label);
                    tableColumn.setWidth(125);
                    break;
                }
                case METACLASS_NAME: {
                    tableColumn.setText(Messages.TableEditor_columnName_Metaclass);
                    break;
                }
                case CONTEXT: {
                    tableColumn.setText(Messages.TableEditor_ColumnName_queryContext);
                    break;
                }
                case ECONTAINER: {
                    tableColumn.setText("/eContainer");
                    break;
                }
                case ATTRIBUTE: {
                    EAttribute attribute = columnDescription.getAttribute();
                    if (attribute.isDerived()) {
                        tableColumn.setText("/" + attribute.getName());
                    } else {
                        tableColumn.setText(attribute.getName());
                    }
                    tableColumn.setImage(ImageProvider.getInstance().getAttributeIcon());
                    break;
                }
                case REFERENCE: {
                    EReference reference = columnDescription.getReference();
                    String multiplicity = LinkItem.getMultiplicity(reference);
                    if (reference.isDerived()) {
                        tableColumn.setText("/" + reference.getName() + multiplicity);
                    } else {
                        tableColumn.setText(String.valueOf(reference.getName()) + multiplicity);
                    }
                    tableColumn.setImage(LinkItem.getImageFor(reference));
                    break;
                }
                default: {
                    MoDiscoBrowserPlugin.logWarning("Unhandled column description type");
                }
            }
            final int fColumnIndex = columnIndex++;
            TableSorter tableSorter = new TableSorter(this.tableViewer, column){

                protected int doCompare(Viewer viewer, Object e1, Object e2) {
                    String label1 = TableEditor.this.tableEditorLabelProvider.getColumnText(e1, fColumnIndex);
                    String label2 = TableEditor.this.tableEditorLabelProvider.getColumnText(e2, fColumnIndex);
                    return label1.compareToIgnoreCase(label2);
                }
            };
        }
    }

    public void setFocus() {
        if (this.tableViewer != null) {
            this.tableViewer.getTable().setFocus();
        }
    }

    public static boolean canBeOpenedOnSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof LinkItem) {
                LinkItem linkItem = (LinkItem)structuredSelection.getFirstElement();
                return linkItem.getChildren().size() > 0;
            }
            boolean empty = true;
            for (Object selectedElement : structuredSelection) {
                if (selectedElement instanceof ModelElementItem) {
                    empty = false;
                    continue;
                }
                return false;
            }
            return !empty;
        }
        return false;
    }

    public static void openOn(BrowserConfiguration browserConfiguration, List<? extends Object> elements, String description) {
        TableEditorInput input = new TableEditorInput(browserConfiguration, elements, description);
        TableEditor.openOn(input);
    }

    private static void openOn(TableEditorInput input) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)input, (String)EDITOR_ID, (boolean)true);
        }
        catch (PartInitException e) {
            MoDiscoBrowserPlugin.logException(e);
        }
    }

    public static void openOn(List<ModelQueryResult> result) {
        ArrayList<Object> elements = new ArrayList<Object>();
        HashMap<Object, EObject> contextMap = new HashMap<Object, EObject>();
        for (ModelQueryResult modelQueryResult : result) {
            Object value = modelQueryResult.getValue();
            TableEditor.flattenToList(value, elements, modelQueryResult.getSource(), contextMap);
        }
        String description = NLS.bind((String)Messages.TableEditor_Description_modelQueryResults, (Object)elements.size());
        BrowserConfiguration browserConfiguration = new BrowserConfiguration();
        ComposedAdapterFactory.Descriptor.Registry registry = ComposedAdapterFactory.Descriptor.Registry.INSTANCE;
        ComposedAdapterFactory adapterFactoryWithRegistry = new ComposedAdapterFactory(registry);
        browserConfiguration.setAdapterFactoryWithRegistry(adapterFactoryWithRegistry);
        TableEditorInput input = new TableEditorInput(browserConfiguration, elements, description, contextMap);
        TableEditor.openOn(input);
    }

    private static void flattenToList(Object value, List<Object> elements, EObject context, Map<Object, EObject> contextMap) {
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            for (Object element : iterable) {
                TableEditor.flattenToList(element, elements, context, contextMap);
            }
        } else {
            elements.add(value);
            contextMap.put(value, context);
        }
    }

    private void openSelectionInModelBrowser(int column) {
        EObject element = this.findElementToOpenInModelBrowser(column);
        if (element != null) {
            this.openElementInModelBrowser(element);
        }
    }

    private Object getSelectedElement() {
        ISelection selection = this.tableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.getFirstElement();
        }
        return null;
    }

    private EObject findElementToOpenInModelBrowser(int column) {
        Object mainElement = this.getSelectedElement();
        if (mainElement == null) {
            return null;
        }
        EObject mainModelElement = mainElement instanceof EObject ? (EObject)mainElement : null;
        EObject targetObject = null;
        if (column > 0) {
            ColumnDescription columnDescription = this.columnsConfiguration.get(column);
            switch (columnDescription.getType()) {
                case ATTRIBUTE: {
                    Object value;
                    if (mainModelElement == null || !((value = this.getStructuralFeatureValue(mainModelElement, (EStructuralFeature)columnDescription.getAttribute())) instanceof EObject)) break;
                    targetObject = (EObject)value;
                    break;
                }
                case REFERENCE: {
                    if (mainModelElement == null) break;
                    Object value = this.getStructuralFeatureValue(mainModelElement, (EStructuralFeature)columnDescription.getReference());
                    if (columnDescription.getReference().isMany()) {
                        EList list = (EList)value;
                        if (list.size() != 1) break;
                        targetObject = (EObject)list.get(0);
                        break;
                    }
                    targetObject = (EObject)value;
                    break;
                }
                case ECONTAINER: {
                    EObject value;
                    if (mainModelElement == null || !((value = mainModelElement.eContainer()) instanceof EObject)) break;
                    targetObject = value;
                    break;
                }
                case CONTEXT: {
                    Map<Object, EObject> contextMap = this.tableEditorInput.getContextMap();
                    if (contextMap == null) break;
                    targetObject = contextMap.get(mainElement);
                    break;
                }
            }
        }
        if (targetObject != null) {
            return targetObject;
        }
        return mainModelElement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openElementInModelBrowser(EObject element) {
        EcoreBrowser editor = this.tableEditorInput.getBrowserConfiguration().getEditor();
        if (editor != null) {
            editor.getSite().getPage().activate((IWorkbenchPart)editor);
            editor.browseTo(element);
            return;
        }
        Resource resource = element.eResource();
        if (resource != null) {
            IEditorReference[] editorReferences;
            ResourceSet resourceSet = resource.getResourceSet();
            IEditorReference[] iEditorReferenceArray = editorReferences = this.getSite().getPage().getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                EcoreBrowser browser;
                IEditorReference editorReference = iEditorReferenceArray[n2];
                IEditorPart anEditor = editorReference.getEditor(false);
                if (anEditor instanceof EcoreBrowser && (browser = (EcoreBrowser)anEditor).getResourceSet() == resourceSet) {
                    browser.browseTo(element);
                    browser.getSite().getPage().activate((IWorkbenchPart)browser);
                    return;
                }
                ++n2;
            }
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            URIEditorInput editorInput;
            URI elementURI = EcoreUtil.getURI((EObject)element);
            URI resourceURI = elementURI.trimFragment();
            if (resourceURI.isPlatformResource()) {
                String platformString = resourceURI.toPlatformString(true);
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
                if (!(res instanceof IFile)) {
                    MoDiscoBrowserPlugin.logError("Cannot open model: " + resourceURI);
                    return;
                }
                IFile file = (IFile)res;
                editorInput = new FileEditorInput(file);
            } else {
                editorInput = new URIEditorInput(resourceURI);
            }
            IEditorPart newEditor = IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)editorInput, (String)"org.eclipse.gmt.modisco.infra.browser.editorID", (boolean)true);
            if (!(newEditor instanceof EcoreBrowser)) return;
            EcoreBrowser browser = (EcoreBrowser)newEditor;
            browser.browseToByURI(elementURI);
            return;
        }
        catch (PartInitException e) {
            MoDiscoBrowserPlugin.logException(e);
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void setHideEmptyColumns(boolean hideEmptyColumns) {
        try {
            this.tableViewer.getControl().setRedraw(false);
            for (ColumnDescription columnDescription : this.columnsConfiguration) {
                boolean bEmpty = false;
                if (columnDescription.getType() == ColumnDescription.Type.ATTRIBUTE) {
                    bEmpty = this.isEmpty(columnDescription.getAttribute());
                } else if (columnDescription.getType() == ColumnDescription.Type.REFERENCE) {
                    bEmpty = this.isEmpty(columnDescription.getReference());
                }
                TableColumn column = this.findColumn(columnDescription);
                if (hideEmptyColumns && bEmpty) {
                    if (column == null) continue;
                    column.setData(KEY_EMPTY_HIDDEN, (Object)Boolean.TRUE);
                    this.hideColumn(column);
                    continue;
                }
                if (hideEmptyColumns || Boolean.TRUE != column.getData(KEY_EMPTY_HIDDEN)) continue;
                column.setData(KEY_EMPTY_HIDDEN, (Object)Boolean.FALSE);
                this.showEmptyColumn(column);
            }
        }
        finally {
            this.tableViewer.getControl().setRedraw(true);
        }
    }

    public void setOnlyShowCommonColumns(boolean onlyShowCommonColumns) {
        try {
            this.tableViewer.getControl().setRedraw(false);
            EClass[] metaclasses = this.tableEditorInput.getMetaclasses();
            for (ColumnDescription columnDescription : this.columnsConfiguration) {
                boolean common = true;
                if (columnDescription.getType() == ColumnDescription.Type.ATTRIBUTE) {
                    common = this.isCommon((EStructuralFeature)columnDescription.getAttribute(), metaclasses);
                } else if (columnDescription.getType() == ColumnDescription.Type.REFERENCE) {
                    common = this.isCommon((EStructuralFeature)columnDescription.getReference(), metaclasses);
                }
                TableColumn column = this.findColumn(columnDescription);
                if (onlyShowCommonColumns && !common) {
                    if (column == null) continue;
                    column.setData(KEY_NOT_COMMON_HIDDEN, (Object)Boolean.TRUE);
                    this.hideColumn(column);
                    continue;
                }
                if (onlyShowCommonColumns || Boolean.TRUE != column.getData(KEY_NOT_COMMON_HIDDEN)) continue;
                column.setData(KEY_NOT_COMMON_HIDDEN, (Object)Boolean.FALSE);
                this.showEmptyColumn(column);
            }
        }
        finally {
            this.tableViewer.getControl().setRedraw(true);
        }
    }

    private void hideColumn(TableColumn column) {
        column.setWidth(0);
        column.setResizable(false);
    }

    private void showEmptyColumn(TableColumn column) {
        if (Boolean.TRUE != column.getData(KEY_EMPTY_HIDDEN) && Boolean.TRUE != column.getData(KEY_NOT_COMMON_HIDDEN)) {
            column.pack();
            column.setResizable(true);
        }
    }

    private boolean isCommon(EStructuralFeature feature, EClass[] metaclasses) {
        EClass[] eClassArray = metaclasses;
        int n = metaclasses.length;
        int n2 = 0;
        while (n2 < n) {
            EClass metaclass = eClassArray[n2];
            if (!metaclass.getEAllStructuralFeatures().contains((Object)feature)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private TableColumn findColumn(ColumnDescription columnDescription) {
        TableColumn[] columns;
        TableColumn[] tableColumnArray = columns = this.tableViewer.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            if (tableColumn.getData() == columnDescription) {
                return tableColumn;
            }
            ++n2;
        }
        return null;
    }

    public static String getEditorDescriptionFor(EObject parent, EReference reference, BrowserConfiguration browserConfiguration) {
        String parentLabel = new ModelElementItem(parent, null, browserConfiguration).getText();
        return NLS.bind((String)Messages.TableEditor_contentsDescription, (Object)parentLabel, (Object)reference.getName());
    }

    private Object getStructuralFeatureValue(EObject eObject, EStructuralFeature structuralFeature) {
        if (structuralFeature instanceof FacetStructuralFeature) {
            try {
                FacetContext facetContext = this.tableEditorInput.getBrowserConfiguration().getFacetContext();
                return facetContext.get(eObject, structuralFeature);
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException(e);
                return null;
            }
        }
        return eObject.eGet(structuralFeature);
    }

    private boolean hasStructuralFeature(EObject eObject, EStructuralFeature structuralFeature) {
        EClass eClass = eObject.eClass();
        FacetContext facetContext = this.tableEditorInput.getBrowserConfiguration().getFacetContext();
        if (facetContext.getFacetFeatures(eObject).contains(structuralFeature)) {
            return true;
        }
        return eClass.getEAllStructuralFeatures().contains((Object)structuralFeature);
    }
}

