/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.infra.discoverymanager.ui.actions;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryManager;
import org.eclipse.gmt.modisco.infra.discoverymanager.handlers.DiscovererHandler;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;

/**
 * @author Gabriel Barbier
 * 
 */
public class ContributionItemForMoDiscoMenu extends ContributionItem {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.action.ContributionItem#fill(org.eclipse.swt.widgets
	 * .Menu, int)
	 */
	@Override
	public void fill(final Menu menu, final int index) {
		super.fill(menu, index);
		/*
		 * Before adding the MoDisco menu, we have to be sure that it will
		 * contains some items or sub-menus ...
		 * 
		 * And items and sub-menus will be available only if they match selected
		 * resources.
		 * 
		 * first, retrieve selected resource
		 * 
		 * second, check if available discoverers handle it
		 * 
		 * third, if discoverers list is not empty, we will create a menu item
		 * for each. For each menu item, we have to links menu action to menu
		 * events like usual menu.
		 */
		final List<DiscovererHandler> discoverers = new ArrayList<DiscovererHandler>();
		// retrieve selected item
		try {
			IWorkbenchWindow workbenchWindow = (IWorkbenchWindow) menu.getShell().getData();
			ISelectionService selectionService = workbenchWindow.getSelectionService();
			// ClassCastException in Eclipse 3.5 : TextSelection /
			// IStructuredSelection ...
			if ((selectionService.getSelection() != null)
					&& (selectionService.getSelection() instanceof IStructuredSelection)
					&& (selectionService.getSelection().isEmpty() == false)) {
				IStructuredSelection selection = (IStructuredSelection) selectionService
						.getSelection();
				/*
				 * for a multiple selection, we have to check each selected
				 * object separatly.
				 */
				Object[] selectedObjects = selection.toArray();
				for (DiscovererHandler discoverer : DiscoveryManager
						.getDefault().getDiscovererHandlers()) {
					boolean applyTo = true;
					for (int i = 0; applyTo && (i < selectedObjects.length); i++) {
						Object selectedObject = selectedObjects[i];
						/* check discoverer compatibility */
						applyTo = discoverer.isApplicableTo(selectedObject);
					}
					if (applyTo) {
						discoverers.add(discoverer);
					}
				}

				if (discoverers.size() > 0) {
					MenuItem modiscoItem = new MenuItem(menu, SWT.CASCADE, index);
					modiscoItem.setText(Messages.ContributionItemForMoDiscoMenu_0);

					modiscoItem.setImage(this.getMoDiscoImage());

					// Add MoDisco menu
					Menu modiscoMenu = new Menu(modiscoItem);
					modiscoItem.setMenu(modiscoMenu);
					for (DiscovererHandler discoverer : discoverers) {
						// management of intermediate menu
						this.createMenuForDiscoverer(discoverer, modiscoMenu,
								selectedObjects);
					}
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	private final void createMenuForDiscoverer(DiscovererHandler discoverer,
			Menu modiscoMenu, Object[] selectedObjects) {
		Menu parentMenu = modiscoMenu;
		if ((discoverer.getPaths() != null)
				&& (discoverer.getPaths().length > 0)) {
			for (String pathEntry : discoverer.getPaths()) {
				MenuItem intermediateMenu = null;
				for (MenuItem item : parentMenu.getItems()) {
					if (item.getText().equalsIgnoreCase(pathEntry)) {
						intermediateMenu = item;
					}
				}
				if (intermediateMenu == null) {
					intermediateMenu = new MenuItem(parentMenu, SWT.CASCADE,
							parentMenu.getItemCount());
					intermediateMenu.setText(pathEntry);
					parentMenu = new Menu(intermediateMenu);
					intermediateMenu.setMenu(parentMenu);
				} else {
					parentMenu = intermediateMenu.getMenu();
				}
			}
		}
		// final menu
		MenuItem discovererMenu = new MenuItem(parentMenu, SWT.PUSH, 0);
		discovererMenu.setText(discoverer.getName());
		discovererMenu.setImage(this.getMoDiscoImage());
		MenuListenerHandler handler = new MenuListenerHandler(discoverer,
				selectedObjects, null);
		discovererMenu.addSelectionListener(handler);
	}

	private Image image;

	private final Image getMoDiscoImage() {
		if (this.image == null) {
			ImageDescriptor descriptor = DiscoveryManager
					.getImageDescriptor("logoMoDiscoMini.gif");
			if (descriptor != null) {
				this.image = descriptor.createImage();
			}
		}
		return this.image;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.action.ContributionItem#isDynamic()
	 */
	@Override
	public boolean isDynamic() {
		return true;
	}

}
