/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.discoverymanager.ui.launch.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryManager;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.ui.launch.data.DiscoveryParameterDisplay;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParameterUtils {
    private static final ParameterUtils instance = new ParameterUtils();
    private Map<Class<?>, Class<? extends CellEditor>> discovererCellEditors;

    private ParameterUtils() {
    }

    public static ParameterUtils getInstance() {
        return instance;
    }

    private Map<Class<?>, Class<? extends CellEditor>> getDiscovererCellEditors() {
        if (this.discovererCellEditors == null) {
            this.discovererCellEditors = new HashMap();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("org.eclipse.gmt.modisco.cellcontenteditors");
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    String targetType = element.getAttribute("targetType");
                    String editorImplementation = element.getAttribute("editorImplementation");
                    if (targetType != null && editorImplementation != null) {
                        try {
                            Class<?> targetTypeClass = Class.forName(targetType);
                            Class<?> editorClass = Class.forName(editorImplementation);
                            this.discovererCellEditors.put(targetTypeClass, editorClass);
                        }
                        catch (ClassNotFoundException e) {
                            String message = "A problem occured when instantiating discoverer cell editor configuration: " + element.getValue();
                            Status status = new Status(2, "org.eclipse.gmt.modisco.infra.discoverymanager", message, (Throwable)e);
                            DiscoveryManager.getDefault().getLog().log((IStatus)status);
                        }
                    } else {
                        String message = "A problem occured when retrieving discoverer cell editor configuration: " + element.getValue();
                        Status status = new Status(2, "org.eclipse.gmt.modisco.infra.discoverymanager", message);
                        DiscoveryManager.getDefault().getLog().log((IStatus)status);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.discovererCellEditors;
    }

    public Object deserializeParameterValue(DiscoveryParameter parameter, ILaunchConfiguration configuration) {
        HashSet result = null;
        Class<?> type = parameter.getType();
        try {
            if (configuration.hasAttribute(parameter.getName())) {
                if (type.equals(String.class)) {
                    String value = configuration.getAttribute(parameter.getName(), "");
                    result = value;
                } else if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                    int value = configuration.getAttribute(parameter.getName(), 0);
                    result = value;
                } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                    boolean value = configuration.getAttribute(parameter.getName(), false);
                    result = value;
                } else if (List.class.isAssignableFrom(type)) {
                    List value = configuration.getAttribute(parameter.getName(), Collections.emptyList());
                    result = value;
                } else if (Set.class.isAssignableFrom(type)) {
                    HashSet value = new HashSet();
                    List list = configuration.getAttribute(parameter.getName(), Collections.emptyList());
                    value.addAll(list);
                    result = value;
                } else if (Map.class.isAssignableFrom(type)) {
                    Map value = configuration.getAttribute(parameter.getName(), Collections.emptyMap());
                    result = value;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateParameterValue(DiscoveryParameterDisplay parameter, ILaunchConfiguration configuration) {
        if (configuration != null) {
            Object value = this.deserializeParameterValue(parameter, configuration);
            parameter.setValue(value);
        }
    }

    public void serializeParameterValue(DiscoveryParameterDisplay parameter, ILaunchConfigurationWorkingCopy configuration) {
        Object value = parameter.getValue();
        Class<?> type = parameter.getType();
        if (value != null) {
            if (type.equals(String.class)) {
                configuration.setAttribute(parameter.getName(), (String)value);
            } else if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                configuration.setAttribute(parameter.getName(), ((Integer)value).intValue());
            } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                configuration.setAttribute(parameter.getName(), ((Boolean)value).booleanValue());
            } else if (List.class.isAssignableFrom(type)) {
                configuration.setAttribute(parameter.getName(), (List)value);
            } else if (Set.class.isAssignableFrom(type)) {
                ArrayList list = new ArrayList();
                list.addAll((Set)value);
                configuration.setAttribute(parameter.getName(), list);
            } else if (Map.class.isAssignableFrom(type)) {
                configuration.setAttribute(parameter.getName(), (Map)value);
            } else {
                configuration.setAttribute(parameter.getName(), value.toString());
            }
        } else {
            configuration.removeAttribute(parameter.getName());
        }
    }

    public boolean canEdit(DiscoveryParameterDisplay parameter) {
        boolean result = false;
        Class<?> type = parameter.getType();
        result = this.getDiscovererCellEditors().containsKey(type);
        return result;
    }

    public CellEditor getCellEditor(DiscoveryParameterDisplay parameter, Composite parent) {
        CellEditor cellEditor = null;
        Class<?> type = parameter.getType();
        Class<? extends CellEditor> cellEditorClass = this.getDiscovererCellEditors().get(type);
        try {
            CellEditor cellEditorTemp = cellEditorClass.newInstance();
            cellEditorTemp.create(parent);
            cellEditor = cellEditorTemp;
        }
        catch (SecurityException e) {
            String message = "A problem occured when instantiating discoverer cell editor : " + cellEditorClass;
            Status status = new Status(2, "org.eclipse.gmt.modisco.infra.discoverymanager", message, (Throwable)e);
            DiscoveryManager.getDefault().getLog().log((IStatus)status);
        }
        catch (IllegalArgumentException e) {
            String message = "A problem occured when instantiating discoverer cell editor : " + cellEditorClass;
            Status status = new Status(2, "org.eclipse.gmt.modisco.infra.discoverymanager", message, (Throwable)e);
            DiscoveryManager.getDefault().getLog().log((IStatus)status);
        }
        catch (InstantiationException e) {
            String message = "A problem occured when instantiating discoverer cell editor : " + cellEditorClass;
            Status status = new Status(2, "org.eclipse.gmt.modisco.infra.discoverymanager", message, (Throwable)e);
            DiscoveryManager.getDefault().getLog().log((IStatus)status);
        }
        catch (IllegalAccessException e) {
            String message = "A problem occured when instantiating discoverer cell editor : " + cellEditorClass;
            Status status = new Status(2, "org.eclipse.gmt.modisco.infra.discoverymanager", message, (Throwable)e);
            DiscoveryManager.getDefault().getLog().log((IStatus)status);
        }
        return cellEditor;
    }

    public void initializeValueFromEditingSupport(DiscoveryParameterDisplay parameter, Object value) {
        parameter.setValue(value);
    }

    public Object retrieveValueForEditingSupport(DiscoveryParameterDisplay parameter) {
        Object result = null;
        result = parameter.getValue();
        return result;
    }
}

