/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Frederic MADIOT (Mia-Software) - meta-model design
 *     Gregoire DUPE (Mia-Software) - design and implementation
 * 
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.infra.facet;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.gmt.modisco.infra.query.ModelQuery;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Facet</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * context Facet inv: self.conditionQuery.scope->exists(e|self.extendedClass.isSuperTypeOf(self.superType))
 * 
 * context Facet inv: self.conditionQuery.retrunType.name == "EBoolean"
 * 
 * context Facet inv: self.eStructuralFeature.isKindOf(FacetStructuralFeature)
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.infra.facet.Facet#getConditionQuery <em>Condition Query</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.gmt.modisco.infra.facet.FacetPackage#getFacet()
 * @model
 * @generated
 */
public interface Facet extends EClass {
	/**
	 * Returns the value of the '<em><b>Condition Query</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Condition Query</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Condition Query</em>' reference.
	 * @see #setConditionQuery(ModelQuery)
	 * @see org.eclipse.gmt.modisco.infra.facet.FacetPackage#getFacet_ConditionQuery()
	 * @model
	 * @generated
	 */
	ModelQuery getConditionQuery();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.infra.facet.Facet#getConditionQuery <em>Condition Query</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Condition Query</em>' reference.
	 * @see #getConditionQuery()
	 * @generated
	 */
	void setConditionQuery(ModelQuery value);

} // Facet
