/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.facet.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.FacetSet;
import org.eclipse.gmt.modisco.infra.facet.plugin.FacetPlugin;

public class ExtendedClassValidation
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObject = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        try {
            IStatus result = null;
            if (eType == EMFEventType.NULL) {
                Facet facet = (Facet)eObject;
                EList superTypes = facet.getESuperTypes();
                for (EClass superType : superTypes) {
                    boolean found = superType.getEPackage().getNsURI().equals(EcorePackage.eINSTANCE.getNsURI());
                    EPackage ePackage = ((FacetSet)facet.getEPackage()).getExtendedPackage();
                    if (ePackage.getEClassifiers().contains((Object)superType)) {
                        found = true;
                    }
                    if (found) {
                        result = ctx.createSuccessStatus();
                        continue;
                    }
                    result = ctx.createFailureStatus(new Object[]{superType.getName(), facet.getName()});
                    break;
                }
            } else {
                result = ctx.createSuccessStatus();
            }
            return result;
        }
        catch (NullPointerException e) {
            Status status = new Status(2, "org.eclipse.gmt.modisco.infra.facet", "Unexpected null value in " + eObject.eResource().getURI().toString(), (Throwable)e);
            FacetPlugin.getDefault().getLog().log((IStatus)status);
            return ctx.createSuccessStatus();
        }
    }
}

