/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.core;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmt.modisco.common.core.builder.IModiscoBuilder;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.query.core.Activator;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilder
implements IModiscoBuilder {
    protected static final String FILE_EXTENSION = "querySet";

    public IProject[] build(IncrementalProjectBuilder builder, int kind, Map<?, ?> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(builder);
        } else {
            IProject project = builder.getProject();
            IResourceDelta delta = builder.getDelta(project);
            if (delta == null) {
                this.fullBuild(builder);
            } else {
                this.incrementalBuild(builder, delta);
            }
        }
        return null;
    }

    private void incrementalBuild(IncrementalProjectBuilder builder, IResourceDelta iResourceDelta) {
        try {
            iResourceDelta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    String fileExtension = resource.getFileExtension();
                    if (resource instanceof IFile && fileExtension != null && fileExtension.equals(QueryBuilder.FILE_EXTENSION)) {
                        switch (delta.getKind()) {
                            case 1: {
                                ModelQuerySetCatalog.getSingleton().addWSFile((IFile)resource);
                                break;
                            }
                            case 2: {
                                ModelQuerySetCatalog.getSingleton().removeWSFile((IFile)resource);
                                break;
                            }
                            case 4: {
                                ModelQuerySetCatalog.getSingleton().removeWSFile((IFile)resource);
                                ModelQuerySetCatalog.getSingleton().addWSFile((IFile)resource);
                                break;
                            }
                            case 8: {
                                ModelQuerySetCatalog.getSingleton().addWSFile((IFile)resource);
                                break;
                            }
                            case 16: {
                                ModelQuerySetCatalog.getSingleton().removeWSFile((IFile)resource);
                                break;
                            }
                            default: {
                                Status status = new Status(4, "org.eclipse.gmt.modisco.infra.query.core", "Unknown delta kind: " + delta.getKind(), (Throwable)new Exception());
                                Activator.getDefault().getLog().log((IStatus)status);
                            }
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (String)("Failed to build: " + builder.getProject()), (Plugin)Activator.getDefault());
        }
    }

    private void fullBuild(IncrementalProjectBuilder builder) {
        try {
            builder.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    String fileExtension = resource.getFileExtension();
                    if (fileExtension != null && fileExtension.equals(QueryBuilder.FILE_EXTENSION)) {
                        try {
                            ModelQuerySetCatalog.getSingleton().addWSFile((IFile)resource);
                        }
                        catch (ClassCastException e) {
                            Status status = new Status(4, "org.eclipse.gmt.modisco.infra.query.core", "Failed to build: " + resource.getProject().getName(), (Throwable)e);
                            Activator.getDefault().getLog().log((IStatus)status);
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.gmt.modisco.infra.query.core", "Failed to build: " + builder.getProject(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    public void clean(IncrementalProjectBuilder builder, IProgressMonitor monitor) throws CoreException {
        try {
            builder.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    boolean continueValue = true;
                    if (resource instanceof IProject) {
                        ModelQuerySetCatalog.getSingleton().clean((IProject)resource);
                        continueValue = false;
                    }
                    return continueValue;
                }
            });
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.gmt.modisco.infra.query.core", "Failed to clean: " + builder.getProject(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }
}

