/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.core;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.Activator;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.osgi.framework.Bundle;

public final class ReferedFileHandler {
    private Bundle bundle;
    private IProject project;
    private String location;

    public ReferedFileHandler(String containerName, String fileLocation, ModelQuery modelQuery) {
        if (modelQuery == null) {
            throw new RuntimeException("The modelQueryParameter is null");
        }
        if (containerName == null || containerName.length() == 0) {
            String projectName = null;
            try {
                Resource resource = modelQuery.eResource();
                URI querySetModelUri = resource.getURI();
                if (!querySetModelUri.isPlatform()) {
                    throw new Exception();
                }
                projectName = querySetModelUri.segment(1);
            }
            catch (Exception e) {
                URI querySetModelUri = ModelQuerySetCatalog.getSingleton().getURI(modelQuery.getModelQuerySet().getName());
                projectName = querySetModelUri.segment(1);
            }
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (!this.project.exists()) {
                this.bundle = Platform.getBundle((String)projectName);
                this.project = null;
            }
        } else {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(containerName);
            if (!this.project.exists()) {
                this.bundle = Platform.getBundle((String)containerName);
                this.project = null;
            }
        }
        this.location = fileLocation;
    }

    ReferedFileHandler(IProject project, Bundle bundle, String asmLocation) {
        this.bundle = bundle;
        this.project = project;
        this.location = asmLocation;
    }

    public boolean exists() {
        boolean exists = false;
        try {
            if (this.project != null) {
                IFile file = this.project.getFile((IPath)new Path(this.location));
                exists = file.exists();
            } else if (this.bundle != null) {
                exists = this.bundle.getResource(this.location) != null;
            }
        }
        catch (Exception e) {
            Status status = new Status(2, "org.eclipse.gmt.modisco.infra.query.core", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return exists;
    }

    public InputStream getInputStream() throws Exception {
        InputStream inputStream;
        if (this.project != null) {
            IFile file = this.project.getFile((IPath)new Path(this.location));
            inputStream = file.getContents();
        } else if (this.bundle != null) {
            inputStream = this.bundle.getResource(this.location).openStream();
        } else {
            throw new ModelQueryExecutionException("ASM file not found. project=" + this.project + "bundle=" + this.bundle + " location=" + this.location);
        }
        return inputStream;
    }

    public IFile getWSFile() {
        IFile file;
        if (this.project != null) {
            Path path = new Path(this.location);
            file = this.project.getFile((IPath)path);
        } else {
            file = null;
        }
        return file;
    }
}

