/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - design and implementation
 */
package com.example.query;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.gmt.modisco.omg.kdm.core.KDMEntity;

public class MyQuery implements IJavaModelQuery {

	@Override
	public Object basicEvaluate(EObject context,
			List<ModelQueryParameterValue> parameterValues)
			throws ModelQueryExecutionException {
		if (!(context instanceof KDMEntity)) {
			ModelQueryExecutionException e = new ModelQueryExecutionException(
					"Wrong context type");
			throw e;
		}
		KDMEntity kdmEntity = (KDMEntity) context;
		return kdmEntity.getStereotype().size();
	}
}
