/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.query.JavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.ui.Activator;
import org.eclipse.gmt.modisco.infra.query.ui.Messages;
import org.eclipse.gmt.modisco.infra.query.ui.exceptions.ClassAlreadyExistsException;
import org.eclipse.gmt.modisco.infra.query.ui.exceptions.ResourceURIExpectedException;
import org.eclipse.gmt.modisco.infra.query.ui.wizards.NewClassCreationWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;

public class CreateJavaQueryImplClass
implements IActionDelegate {
    private ISelection selection2;

    public void run(IAction action) {
        ArrayList<JavaModelQuery> selectedQueries = new ArrayList<JavaModelQuery>();
        if (this.selection2 instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.selection2;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof JavaModelQuery)) continue;
                JavaModelQuery element = (JavaModelQuery)selectedElement;
                selectedQueries.add(element);
            }
        }
        for (JavaModelQuery query : selectedQueries) {
            try {
                NewClassCreationWizard wizard = new NewClassCreationWizard(query);
                IWorkbench workbench = Activator.getDefault().getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                Shell shell = window.getShell();
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.create();
                dialog.open();
            }
            catch (ResourceURIExpectedException e) {
                MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CreateJavaQueryImplClass_0, (String)Messages.CreateJavaQueryImplClass_1);
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
            catch (ClassAlreadyExistsException e) {
                MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CreateJavaQueryImplClass_2, (String)Messages.CreateJavaQueryImplClass_3);
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CreateJavaQueryImplClass_4, (String)Messages.CreateJavaQueryImplClass_5);
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection2 = selection;
    }
}

