/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.plugin.QueryPlugin;

public class ScopeValidation
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObject = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL) {
            if (eObject instanceof ModelQuery) {
                ModelQuery modelQuery = (ModelQuery)eObject;
                EList<EClass> scopes = modelQuery.getScope();
                boolean found = false;
                for (EClass scope : scopes) {
                    for (EPackage ePackage : modelQuery.getModelQuerySet().getAssociatedMetamodels()) {
                        if (!ePackage.getEClassifiers().contains((Object)scope)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return ctx.createFailureStatus(new Object[]{scope.getName(), modelQuery.getName()});
                }
            } else {
                Exception e = new Exception("Wrong validation context. ModelQuery object was expected, " + eObject.eClass().getName() + " object found.");
                Status status = new Status(4, "org.eclipse.gmt.modisco.infra.query", e.getMessage(), (Throwable)e);
                QueryPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        return ctx.createSuccessStatus();
    }
}

