/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.java.browser.extension;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmt.modisco.infra.browser.extensions.naming.AbstractNameProvider;
import org.eclipse.gmt.modisco.java.*;
import org.eclipse.gmt.modisco.java.Package;

/**
 * @generated
 */
public class NameProvider extends AbstractNameProvider {
// Start of user code for additional methods and attributes
	private final Object getFeature(EObject eObject, String featureName) {
		Object result = null;
		if (eObject != null) {
			EClass eClass = eObject.eClass();
			EStructuralFeature structuralFeature = eClass.getEStructuralFeature(featureName);
			if (structuralFeature != null) {
				result = eObject.eGet(structuralFeature);
			}
		}
		return result;
	}
// End of user code

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getUnresolvedClassDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getUnresolvedInterfaceDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getUnresolvedAnnotationDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getUnresolvedEnumDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getClassDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getInterfaceDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getUnresolvedMethodDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getUnresolvedTypeDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getAnnotationTypeDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getEnumDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getTypeDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getUnresolvedAnnotationTypeMemberDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getUnresolvedLabeledStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getUnresolvedSingleVariableDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getUnresolvedVariableDeclarationFragmentName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getAbstractTypeDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getConstructorDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getEnumConstantDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	@SuppressWarnings("unchecked")
	private final String getFieldDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// FieldDeclaration -> fragments
		Object fragments = getFeature(eObject, "fragments");
		String res = "";
		if (fragments instanceof EList) {
			EList<EObject> eFragments = (EList<EObject>) fragments;
			int nbFragments = eFragments.size();
			for(int i = 0; i < nbFragments; i++){
				if(i > 0 && i < nbFragments) res += ", ";
				res += getName(eFragments.get(i));
			}
			name = res;
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getMethodDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getPrimitiveTypeBooleanName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getPrimitiveTypeByteName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getPrimitiveTypeCharName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getPrimitiveTypeDoubleName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getPrimitiveTypeShortName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getPrimitiveTypeFloatName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getPrimitiveTypeIntName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getPrimitiveTypeLongName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getPrimitiveTypeVoidName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getSuperMethodInvocationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// SuperMethodInvocation -> method
		Object method = getFeature(eObject, "method");
		if (method instanceof EObject) {
			EObject eMethod = (EObject) method;
			name = this.getName(eMethod);
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getUnresolvedTypeName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getAbstractMethodDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getAnnotationTypeMemberDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getArrayTypeName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// ArrayType -> elementType
		Object elementType = getFeature(eObject, "elementType");
		if (elementType instanceof EObject) {
			EObject eElementType = (EObject) elementType;
			name = this.getName(eElementType);
		}
		return name;
	}

	/**
	 * 
	 */
	private final String getClassInstanceCreationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// ClassInstanceCreation -> type
		Object type = getFeature(eObject, "type");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			name = this.getName(eType);
		}
		return name;
	}

	/**
	 * 
	 */
	private final String getConstructorInvocationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// ConstructorInvocation -> method
		Object method = getFeature(eObject, "method");
		if (method instanceof EObject) {
			EObject eMethod = (EObject) method;
			name = this.getName(eMethod);
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getInitializerName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getLabeledStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getMethodInvocationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// MethodInvocation -> method
		Object method = getFeature(eObject, "method");
		if (method instanceof EObject) {
			EObject eMethod = (EObject) method;
			name = this.getName(eMethod);
		}
		return name;
	}

	/**
	 * 
	 */
	private final String getParameterizedTypeName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// ParameterizedType -> type
		Object type = getFeature(eObject, "type");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			name = this.getName(eType);
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getPrimitiveTypeName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getSingleVariableDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getSuperConstructorInvocationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// SuperConstructorInvocation -> method
		Object method = getFeature(eObject, "method");
		if (method instanceof EObject) {
			EObject eMethod = (EObject) method;
			name = this.getName(eMethod);
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getSuperFieldAccessName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getThisExpressionName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getTypeParameterName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	@SuppressWarnings("unchecked")
	private final String getVariableDeclarationExpressionName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// VariableDeclarationExpression -> type + fragments
		String res = "";
		Object type = getFeature(eObject, "type");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			res += getName(eType);
		}
		res += " ";
		Object fragments = getFeature(eObject, "fragments");
		if (fragments instanceof EList) {
			EList<EObject> eFragments = (EList<EObject>) fragments;
			int nbFragments = eFragments.size();
			for(int i = 0; i < nbFragments; i++){
				if(i > 0 && i < nbFragments) res += ", ";
				res += getName(eFragments.get(i));
			}
			
		}
		name = res;
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getVariableDeclarationFragmentName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	@SuppressWarnings("unchecked")
	private final String getVariableDeclarationStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// VariableDeclarationStatement -> type + fragments
		String res = "";
		Object type = getFeature(eObject, "type");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			res += getName(eType);
		}
		res += " ";
		Object fragments = getFeature(eObject, "fragments");
		if (fragments instanceof EList) {
			EList<EObject> eFragments = (EList<EObject>) fragments;
			int nbFragments = eFragments.size();
			for(int i = 0; i < nbFragments; i++){
				if(i > 0 && i < nbFragments) res += ", ";
				res += getName(eFragments.get(i));
			}
			
		}
		name = res;
		return name;
	}

	/**
	 * 
	 */
	private final String getWildCardTypeName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// WildCardType -> bound
		Object expression = getFeature(eObject, "bound");
		if (expression instanceof EObject) {
			EObject eExpression = (EObject) expression;
			name = this.getName(eExpression);
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getAbstractTypeQualifiedExpressionName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getAnnotationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// Annotation -> type
		Object type = this.getFeature(eObject, "type");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			name = this.getName(eType);
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getAssertStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getAnnotationMemberValuePairName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getArrayAccessName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// ArrayAccess -> array
		Object array = getFeature(eObject, "array");
		if (array instanceof EObject) {
			EObject eArray = (EObject) array;
			name = this.getName(eArray);
		}
		return name;
	}

	/**
	 * 
	 */
	@SuppressWarnings("unchecked")
	private final String getArrayCreationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// ArrayCreation -> type
		// get number of dimensions
		Object dimensions = getFeature(eObject, "dimensions");
		int dimension = 0;
		if (dimensions instanceof EList) {
			EList<?> eDimensions = (EList<?>) dimensions;
			dimension = eDimensions.size();
		}

		Object type = getFeature(eObject, "type");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			name = this.getName(eType);
			for (int i = 0; i < dimension; i++) {
				name = name + "[]";
			}
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getArrayInitializerName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getArrayLengthAccessName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// ArrayLengthAccess -> array
		Object array = getFeature(eObject, "array");
		if (array instanceof EObject) {
			EObject eArray = (EObject) array;
			name = this.getName(eArray);
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getAssignmentName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getBodyDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getBooleanLiteralName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// BooleanLiteral -> value
		Object value = getFeature(eObject, "value");
		if (value instanceof Boolean) {
			name = value.toString();
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getBlockCommentName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	@SuppressWarnings("unchecked")
	private final String getBlockName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// Block -> statements.length
		// get number of statements
		Object statements = getFeature(eObject, "statements");
		int nStatements = 0;
		if (statements instanceof EList) {
			EList<?> eStatements = (EList<?>) statements;
			nStatements = eStatements.size();
		}
		name = String.valueOf(nStatements);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getBreakStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getCastExpressionName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// CastExpression -> type
		Object type = getFeature(eObject, "type");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			name = this.getName(eType);
		}
		return name;
	}

	/**
	 * 
	 */
	private final String getCatchClauseName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// CatchClause -> exception -> type
		Object exception = getFeature(eObject, "exception");
		if (exception instanceof EObject) {
			EObject eException = (EObject) exception;
			Object type = getFeature(eException, "type");
			if (type instanceof EObject) {
				EObject eType = (EObject) type;
				name = this.getName(eType);
			}
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getCharacterLiteralName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getConditionalExpressionName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getCompilationUnitName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getContinueStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getDoStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getEmptyStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getEnhancedForStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// EnhancedForStatement -> parameter -> type
		Object parameter = getFeature(eObject, "parameter");
		if (parameter instanceof EObject) {
			EObject eParameter = (EObject) parameter;
			Object type = getFeature(eParameter, "type");
			if (type instanceof EObject) {
				EObject eType = (EObject) type;
				name = this.getName(eType);
			}
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getExpressionStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getFieldAccessName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// FieldAccess -> field
		Object field = getFeature(eObject, "field");
		if (field instanceof EObject) {
			EObject eField = (EObject) field;
			name = this.getName(eField);
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getForStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getIfStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getInfixExpressionName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// InfixExpression -> operator
		Object operator = getFeature(eObject, "operator");
		name = operator.toString();
		return name;
	}

	/**
	 * 
	 */
	private final String getInstanceofExpressionName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// InstanceofExpression -> rightOperand
		Object type = getFeature(eObject, "rightOperand");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			name = this.getName(eType);
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getJavadocName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getLineCommentName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getNumberLiteralName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getNullLiteralName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getPackageName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getPackageAccessName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// PackageAccess -> package
		Object type = this.getFeature(eObject, "package");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			name = this.getName(eType);
			
			EClass eElementClass = eType.eClass();
			String strElementClass = "";
			if (eElementClass != null) {
				strElementClass = " (" + eElementClass.getName() + ")";
			}

			name = "-> " + name + strElementClass;
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getParenthesizedExpressionName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getPostfixExpressionName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// PostfixExpression -> operator
		Object operator = getFeature(eObject, "operator");
		name = operator.toString();
		return name;
	}

	/**
	 * 
	 */
	private final String getPrefixExpressionName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// PrefixExpression -> operator
		Object operator = getFeature(eObject, "operator");
		name = operator.toString();
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getReturnStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getSingleVariableAccessName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// SingleVariableAccess -> variable
		Object variable = getFeature(eObject, "variable");
		if (variable instanceof EObject) {
			EObject eVariable = (EObject) variable;
			name = this.getName(eVariable);
			EClass eElementClass = eVariable.eClass();
			String strElementClass = "";
			if (eElementClass != null) {
				strElementClass = " (" + eElementClass.getName() + ")";
			}

			name = "-> " + name + strElementClass;
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getStringLiteralName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getSwitchCaseName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getSwitchStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getSynchronizedStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getThrowStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// ThrowStatement -> expression
		// the thrown class is often in the expression
		Object expression = getFeature(eObject, "expression");
		if (expression instanceof EObject) {
			EObject eExpression = (EObject) expression;
			name = this.getName(eExpression);
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getTryStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getTypeName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getTypeAccessName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// TypeAccess -> type
		Object type = this.getFeature(eObject, "type");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			name = this.getName(eType);
			EClass eElementClass = eType.eClass();
			String strElementClass = "";
			if (eElementClass != null) {
				strElementClass = " (" + eElementClass.getName() + ")";
			}

			name = "-> " + name + strElementClass;
		}
		return name;
	}

	/**
	 * 
	 */
	private final String getTypeDeclarationStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// TypeDeclarationStatement -> declaration
		Object expression = getFeature(eObject, "declaration");
		if (expression instanceof EObject) {
			EObject eExpression = (EObject) expression;
			name = this.getName(eExpression);
		}
		return name;
	}

	/**
	 * 
	 */
	private final String getTypeLiteralName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// TypeLiteral -> type
		Object expression = getFeature(eObject, "type");
		if (expression instanceof EObject) {
			EObject eExpression = (EObject) expression;
			name = this.getName(eExpression);
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getUnresolvedItemName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getUnresolvedItemAccessName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// UnresolvedItemAccess -> element
		Object type = this.getFeature(eObject, "element");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			name = this.getName(eType);
			EClass eElementClass = eType.eClass();
			String strElementClass = "";
			if (eElementClass != null) {
				strElementClass = " (" + eElementClass.getName() + ")";
			}

			name = "-> " + name + strElementClass;
		}
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getVariableDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getWhileStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getAbstractMethodInvocationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getAbstractVariablesContainerName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getAnonymousClassDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getCommentName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getExpressionName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * 
	 */
	private final String getImportDeclarationName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// ImportDeclaration -> importedElement
		Object importedElement = getFeature(eObject, "importedElement");
		if (importedElement instanceof EObject) {
			EObject eImportedElement = (EObject) importedElement;
			name = this.getName(eImportedElement);

			Object element = getFeature(eImportedElement, "qualifier");
			while (element instanceof EObject) {
				name = this.getName((EObject) element) + "." + name;
				element = getFeature((EObject) element, "qualifier");
			}

		}
		return name;
	}

	/**
	 * 
	 */
	private final String getMemberRefName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// MemberRef -> member
		Object type = getFeature(eObject, "member");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			name = this.getName(eType);
		}
		return name;
	}

	/**
	 * 
	 */
	private final String getMethodRefName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// MethodRef -> method
		Object type = getFeature(eObject, "method");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			name = this.getName(eType);
		}
		return name;
	}

	/**
	 * 
	 */
	private final String getMethodRefParameterName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		// MethodRefParameter -> type
		Object type = getFeature(eObject, "type");
		if (type instanceof EObject) {
			EObject eType = (EObject) type;
			name = this.getName(eType);
		}
		return name;
	}

	/**
	 * 
	 */
	private final String getModifierName(EObject eObject) {
		String name = "";
		// Modifier ->
		// visibility,isNative,isStatic,isStrictfp,isSynchronized,isTransient,isVolatile
		Object isNative = getFeature(eObject, "native");
		if (isNative instanceof Boolean && ((Boolean) isNative)) {
			name += " native";
		}
		Object isStatic = getFeature(eObject, "static");
		if (isStatic instanceof Boolean && ((Boolean) isStatic)) {
			name += " static";
		}
		Object isStrictfp = getFeature(eObject, "strictfp");
		if (isStrictfp instanceof Boolean && ((Boolean) isStrictfp)) {
			name += " strictfp";
		}
		Object isSynchronized = getFeature(eObject, "synchronized");
		if (isSynchronized instanceof Boolean && ((Boolean) isSynchronized)) {
			name += " synchronized";
		}
		Object isTransient = getFeature(eObject, "transient");
		if (isTransient instanceof Boolean && ((Boolean) isTransient)) {
			name += " transient";
		}
		Object isVolatile = getFeature(eObject, "volatile");
		if (isVolatile instanceof Boolean && ((Boolean) isVolatile)) {
			name += " volatile";
		}

		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getNamedElementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getStatementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getTagElementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getTextElementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getASTNodeName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}

	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getModelName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}


	/**
	 * @generated
	 */
	public NameProvider() {
	}

	/**
	 * @return the name that must be displayed for the given {@link EObject}, or <code>null</code>
	 *         to keep the default name (or let another {@link NameProvider} provide the name)
	 * 
	 * @generated
	 */
	public String getName(EObject eObject) {
		String result = this.getDefaultName(eObject);
    	if (eObject instanceof UnresolvedClassDeclaration) {
      		result = this.getUnresolvedClassDeclarationName(eObject);
    	} else
    	if (eObject instanceof UnresolvedInterfaceDeclaration) {
      		result = this.getUnresolvedInterfaceDeclarationName(eObject);
    	} else
    	if (eObject instanceof UnresolvedAnnotationDeclaration) {
      		result = this.getUnresolvedAnnotationDeclarationName(eObject);
    	} else
    	if (eObject instanceof UnresolvedEnumDeclaration) {
      		result = this.getUnresolvedEnumDeclarationName(eObject);
    	} else
    	if (eObject instanceof ClassDeclaration) {
      		result = this.getClassDeclarationName(eObject);
    	} else
    	if (eObject instanceof InterfaceDeclaration) {
      		result = this.getInterfaceDeclarationName(eObject);
    	} else
    	if (eObject instanceof UnresolvedMethodDeclaration) {
      		result = this.getUnresolvedMethodDeclarationName(eObject);
    	} else
    	if (eObject instanceof UnresolvedTypeDeclaration) {
      		result = this.getUnresolvedTypeDeclarationName(eObject);
    	} else
    	if (eObject instanceof AnnotationTypeDeclaration) {
      		result = this.getAnnotationTypeDeclarationName(eObject);
    	} else
    	if (eObject instanceof EnumDeclaration) {
      		result = this.getEnumDeclarationName(eObject);
    	} else
    	if (eObject instanceof TypeDeclaration) {
      		result = this.getTypeDeclarationName(eObject);
    	} else
    	if (eObject instanceof UnresolvedAnnotationTypeMemberDeclaration) {
      		result = this.getUnresolvedAnnotationTypeMemberDeclarationName(eObject);
    	} else
    	if (eObject instanceof UnresolvedLabeledStatement) {
      		result = this.getUnresolvedLabeledStatementName(eObject);
    	} else
    	if (eObject instanceof UnresolvedSingleVariableDeclaration) {
      		result = this.getUnresolvedSingleVariableDeclarationName(eObject);
    	} else
    	if (eObject instanceof UnresolvedVariableDeclarationFragment) {
      		result = this.getUnresolvedVariableDeclarationFragmentName(eObject);
    	} else
    	if (eObject instanceof AbstractTypeDeclaration) {
      		result = this.getAbstractTypeDeclarationName(eObject);
    	} else
    	if (eObject instanceof ConstructorDeclaration) {
      		result = this.getConstructorDeclarationName(eObject);
    	} else
    	if (eObject instanceof EnumConstantDeclaration) {
      		result = this.getEnumConstantDeclarationName(eObject);
    	} else
    	if (eObject instanceof FieldDeclaration) {
      		result = this.getFieldDeclarationName(eObject);
    	} else
    	if (eObject instanceof MethodDeclaration) {
      		result = this.getMethodDeclarationName(eObject);
    	} else
    	if (eObject instanceof PrimitiveTypeBoolean) {
      		result = this.getPrimitiveTypeBooleanName(eObject);
    	} else
    	if (eObject instanceof PrimitiveTypeByte) {
      		result = this.getPrimitiveTypeByteName(eObject);
    	} else
    	if (eObject instanceof PrimitiveTypeChar) {
      		result = this.getPrimitiveTypeCharName(eObject);
    	} else
    	if (eObject instanceof PrimitiveTypeDouble) {
      		result = this.getPrimitiveTypeDoubleName(eObject);
    	} else
    	if (eObject instanceof PrimitiveTypeShort) {
      		result = this.getPrimitiveTypeShortName(eObject);
    	} else
    	if (eObject instanceof PrimitiveTypeFloat) {
      		result = this.getPrimitiveTypeFloatName(eObject);
    	} else
    	if (eObject instanceof PrimitiveTypeInt) {
      		result = this.getPrimitiveTypeIntName(eObject);
    	} else
    	if (eObject instanceof PrimitiveTypeLong) {
      		result = this.getPrimitiveTypeLongName(eObject);
    	} else
    	if (eObject instanceof PrimitiveTypeVoid) {
      		result = this.getPrimitiveTypeVoidName(eObject);
    	} else
    	if (eObject instanceof SuperMethodInvocation) {
      		result = this.getSuperMethodInvocationName(eObject);
    	} else
    	if (eObject instanceof UnresolvedType) {
      		result = this.getUnresolvedTypeName(eObject);
    	} else
    	if (eObject instanceof AbstractMethodDeclaration) {
      		result = this.getAbstractMethodDeclarationName(eObject);
    	} else
    	if (eObject instanceof AnnotationTypeMemberDeclaration) {
      		result = this.getAnnotationTypeMemberDeclarationName(eObject);
    	} else
    	if (eObject instanceof ArrayType) {
      		result = this.getArrayTypeName(eObject);
    	} else
    	if (eObject instanceof ClassInstanceCreation) {
      		result = this.getClassInstanceCreationName(eObject);
    	} else
    	if (eObject instanceof ConstructorInvocation) {
      		result = this.getConstructorInvocationName(eObject);
    	} else
    	if (eObject instanceof Initializer) {
      		result = this.getInitializerName(eObject);
    	} else
    	if (eObject instanceof LabeledStatement) {
      		result = this.getLabeledStatementName(eObject);
    	} else
    	if (eObject instanceof MethodInvocation) {
      		result = this.getMethodInvocationName(eObject);
    	} else
    	if (eObject instanceof ParameterizedType) {
      		result = this.getParameterizedTypeName(eObject);
    	} else
    	if (eObject instanceof PrimitiveType) {
      		result = this.getPrimitiveTypeName(eObject);
    	} else
    	if (eObject instanceof SingleVariableDeclaration) {
      		result = this.getSingleVariableDeclarationName(eObject);
    	} else
    	if (eObject instanceof SuperConstructorInvocation) {
      		result = this.getSuperConstructorInvocationName(eObject);
    	} else
    	if (eObject instanceof SuperFieldAccess) {
      		result = this.getSuperFieldAccessName(eObject);
    	} else
    	if (eObject instanceof ThisExpression) {
      		result = this.getThisExpressionName(eObject);
    	} else
    	if (eObject instanceof TypeParameter) {
      		result = this.getTypeParameterName(eObject);
    	} else
    	if (eObject instanceof VariableDeclarationExpression) {
      		result = this.getVariableDeclarationExpressionName(eObject);
    	} else
    	if (eObject instanceof VariableDeclarationFragment) {
      		result = this.getVariableDeclarationFragmentName(eObject);
    	} else
    	if (eObject instanceof VariableDeclarationStatement) {
      		result = this.getVariableDeclarationStatementName(eObject);
    	} else
    	if (eObject instanceof WildCardType) {
      		result = this.getWildCardTypeName(eObject);
    	} else
    	if (eObject instanceof AbstractTypeQualifiedExpression) {
      		result = this.getAbstractTypeQualifiedExpressionName(eObject);
    	} else
    	if (eObject instanceof Annotation) {
      		result = this.getAnnotationName(eObject);
    	} else
    	if (eObject instanceof AssertStatement) {
      		result = this.getAssertStatementName(eObject);
    	} else
    	if (eObject instanceof AnnotationMemberValuePair) {
      		result = this.getAnnotationMemberValuePairName(eObject);
    	} else
    	if (eObject instanceof ArrayAccess) {
      		result = this.getArrayAccessName(eObject);
    	} else
    	if (eObject instanceof ArrayCreation) {
      		result = this.getArrayCreationName(eObject);
    	} else
    	if (eObject instanceof ArrayInitializer) {
      		result = this.getArrayInitializerName(eObject);
    	} else
    	if (eObject instanceof ArrayLengthAccess) {
      		result = this.getArrayLengthAccessName(eObject);
    	} else
    	if (eObject instanceof Assignment) {
      		result = this.getAssignmentName(eObject);
    	} else
    	if (eObject instanceof BodyDeclaration) {
      		result = this.getBodyDeclarationName(eObject);
    	} else
    	if (eObject instanceof BooleanLiteral) {
      		result = this.getBooleanLiteralName(eObject);
    	} else
    	if (eObject instanceof BlockComment) {
      		result = this.getBlockCommentName(eObject);
    	} else
    	if (eObject instanceof Block) {
      		result = this.getBlockName(eObject);
    	} else
    	if (eObject instanceof BreakStatement) {
      		result = this.getBreakStatementName(eObject);
    	} else
    	if (eObject instanceof CastExpression) {
      		result = this.getCastExpressionName(eObject);
    	} else
    	if (eObject instanceof CatchClause) {
      		result = this.getCatchClauseName(eObject);
    	} else
    	if (eObject instanceof CharacterLiteral) {
      		result = this.getCharacterLiteralName(eObject);
    	} else
    	if (eObject instanceof ConditionalExpression) {
      		result = this.getConditionalExpressionName(eObject);
    	} else
    	if (eObject instanceof CompilationUnit) {
      		result = this.getCompilationUnitName(eObject);
    	} else
    	if (eObject instanceof ContinueStatement) {
      		result = this.getContinueStatementName(eObject);
    	} else
    	if (eObject instanceof DoStatement) {
      		result = this.getDoStatementName(eObject);
    	} else
    	if (eObject instanceof EmptyStatement) {
      		result = this.getEmptyStatementName(eObject);
    	} else
    	if (eObject instanceof EnhancedForStatement) {
      		result = this.getEnhancedForStatementName(eObject);
    	} else
    	if (eObject instanceof ExpressionStatement) {
      		result = this.getExpressionStatementName(eObject);
    	} else
    	if (eObject instanceof FieldAccess) {
      		result = this.getFieldAccessName(eObject);
    	} else
    	if (eObject instanceof ForStatement) {
      		result = this.getForStatementName(eObject);
    	} else
    	if (eObject instanceof IfStatement) {
      		result = this.getIfStatementName(eObject);
    	} else
    	if (eObject instanceof InfixExpression) {
      		result = this.getInfixExpressionName(eObject);
    	} else
    	if (eObject instanceof InstanceofExpression) {
      		result = this.getInstanceofExpressionName(eObject);
    	} else
    	if (eObject instanceof Javadoc) {
      		result = this.getJavadocName(eObject);
    	} else
    	if (eObject instanceof LineComment) {
      		result = this.getLineCommentName(eObject);
    	} else
    	if (eObject instanceof NumberLiteral) {
      		result = this.getNumberLiteralName(eObject);
    	} else
    	if (eObject instanceof NullLiteral) {
      		result = this.getNullLiteralName(eObject);
    	} else
    	if (eObject instanceof Package) {
      		result = this.getPackageName(eObject);
    	} else
    	if (eObject instanceof PackageAccess) {
      		result = this.getPackageAccessName(eObject);
    	} else
    	if (eObject instanceof ParenthesizedExpression) {
      		result = this.getParenthesizedExpressionName(eObject);
    	} else
    	if (eObject instanceof PostfixExpression) {
      		result = this.getPostfixExpressionName(eObject);
    	} else
    	if (eObject instanceof PrefixExpression) {
      		result = this.getPrefixExpressionName(eObject);
    	} else
    	if (eObject instanceof ReturnStatement) {
      		result = this.getReturnStatementName(eObject);
    	} else
    	if (eObject instanceof SingleVariableAccess) {
      		result = this.getSingleVariableAccessName(eObject);
    	} else
    	if (eObject instanceof StringLiteral) {
      		result = this.getStringLiteralName(eObject);
    	} else
    	if (eObject instanceof SwitchCase) {
      		result = this.getSwitchCaseName(eObject);
    	} else
    	if (eObject instanceof SwitchStatement) {
      		result = this.getSwitchStatementName(eObject);
    	} else
    	if (eObject instanceof SynchronizedStatement) {
      		result = this.getSynchronizedStatementName(eObject);
    	} else
    	if (eObject instanceof ThrowStatement) {
      		result = this.getThrowStatementName(eObject);
    	} else
    	if (eObject instanceof TryStatement) {
      		result = this.getTryStatementName(eObject);
    	} else
    	if (eObject instanceof Type) {
      		result = this.getTypeName(eObject);
    	} else
    	if (eObject instanceof TypeAccess) {
      		result = this.getTypeAccessName(eObject);
    	} else
    	if (eObject instanceof TypeDeclarationStatement) {
      		result = this.getTypeDeclarationStatementName(eObject);
    	} else
    	if (eObject instanceof TypeLiteral) {
      		result = this.getTypeLiteralName(eObject);
    	} else
    	if (eObject instanceof UnresolvedItem) {
      		result = this.getUnresolvedItemName(eObject);
    	} else
    	if (eObject instanceof UnresolvedItemAccess) {
      		result = this.getUnresolvedItemAccessName(eObject);
    	} else
    	if (eObject instanceof VariableDeclaration) {
      		result = this.getVariableDeclarationName(eObject);
    	} else
    	if (eObject instanceof WhileStatement) {
      		result = this.getWhileStatementName(eObject);
    	} else
    	if (eObject instanceof AbstractMethodInvocation) {
      		result = this.getAbstractMethodInvocationName(eObject);
    	} else
    	if (eObject instanceof AbstractVariablesContainer) {
      		result = this.getAbstractVariablesContainerName(eObject);
    	} else
    	if (eObject instanceof AnonymousClassDeclaration) {
      		result = this.getAnonymousClassDeclarationName(eObject);
    	} else
    	if (eObject instanceof Comment) {
      		result = this.getCommentName(eObject);
    	} else
    	if (eObject instanceof Expression) {
      		result = this.getExpressionName(eObject);
    	} else
    	if (eObject instanceof ImportDeclaration) {
      		result = this.getImportDeclarationName(eObject);
    	} else
    	if (eObject instanceof MemberRef) {
      		result = this.getMemberRefName(eObject);
    	} else
    	if (eObject instanceof MethodRef) {
      		result = this.getMethodRefName(eObject);
    	} else
    	if (eObject instanceof MethodRefParameter) {
      		result = this.getMethodRefParameterName(eObject);
    	} else
    	if (eObject instanceof Modifier) {
      		result = this.getModifierName(eObject);
    	} else
    	if (eObject instanceof NamedElement) {
      		result = this.getNamedElementName(eObject);
    	} else
    	if (eObject instanceof Statement) {
      		result = this.getStatementName(eObject);
    	} else
    	if (eObject instanceof TagElement) {
      		result = this.getTagElementName(eObject);
    	} else
    	if (eObject instanceof TextElement) {
      		result = this.getTextElementName(eObject);
    	} else
    	if (eObject instanceof ASTNode) {
      		result = this.getASTNodeName(eObject);
    	} else
    	if (eObject instanceof Model) {
      		result = this.getModelName(eObject);
    	} 
		return result;
	}

}

