/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.actions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterImpl;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.actions.Messages;
import org.eclipse.gmt.modisco.java.emf.JavaFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultDiscoverer
implements Discoverer {
    private static final int FLUSH_LIMIT = 10000;
    public static final String JAVA_FILE_EXTENSION = "javaxmi";
    private Resource resourceResult = null;
    public static final DiscoveryParameter PARAMETER_SILENT_MODE = new DiscoveryParameterImpl("OPTION_SILENT_MODE", DiscoveryParameterDirectionKind.in, Boolean.class, false);
    public static final DiscoveryParameter PARAMETER_TARGET_RESOURCE = new DiscoveryParameterImpl("TARGET_RESOURCE", DiscoveryParameterDirectionKind.out, Resource.class, false);
    public static final DiscoveryParameter PARAMETER_BROWSE_RESULT = new DiscoveryParameterImpl("PARAMETER_BROWSE_RESULT", DiscoveryParameterDirectionKind.in, Boolean.class, false);

    protected Resource getResourceResult() {
        return this.resourceResult;
    }

    protected void setResourceResult(Resource resourceResult) {
        this.resourceResult = resourceResult;
    }

    protected Resource getResource(String resourceName, IJavaProject javaProject) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)("platform:/resource/" + javaProject.getProject().getName() + "/" + javaProject.getProject().getName() + "." + JAVA_FILE_EXTENSION)));
        return resource;
    }

    public Resource discoverElement(Object source, URI target) {
        HashMap<DiscoveryParameter, Boolean> parameters = new HashMap<DiscoveryParameter, Boolean>();
        parameters.put(PARAMETER_SILENT_MODE, false);
        this.discoverElement(source, parameters);
        return (Resource)parameters.get(PARAMETER_TARGET_RESOURCE);
    }

    protected void saveResource(URI target, IPath path, Resource resource, IProgressMonitor monitor) throws IOException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", System.getProperty("file.encoding"));
        options.put("FLUSH_THRESHOLD", 10000);
        options.put("USE_FILE_BUFFER", true);
        if (target != null) {
            resource.setURI(target);
        } else {
            URI uri = URI.createFileURI((String)path.toString());
            resource.setURI(uri);
        }
        monitor.subTask(Messages.DefaultDiscoverer_savingTaskLabel);
        resource.save(options);
    }

    protected JavaFactory getEFactory() {
        return JavaFactory.eINSTANCE;
    }

    protected void openEditor(IFile source, Map<DiscoveryParameter, Object> parameters) {
        boolean isSilent = false;
        boolean browseResult = true;
        if (parameters != null) {
            isSilent = Boolean.TRUE.equals(parameters.get(PARAMETER_SILENT_MODE));
            boolean bl = browseResult = !Boolean.FALSE.equals(parameters.get(PARAMETER_BROWSE_RESULT));
        }
        if (!isSilent && browseResult) {
            this.openEditor(source);
        }
    }

    private final void openEditor(final IFile source) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IEditorDescriptor editDesc;
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorPart existingEditorOnResource = page.findEditor((IEditorInput)new FileEditorInput(source));
                    if (existingEditorOnResource != null) {
                        page.closeEditor(existingEditorOnResource, true);
                    }
                    if ((editDesc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.gmt.modisco.infra.browser.editorID")) != null) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)source, (String)editDesc.getId());
                    } else {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)source);
                    }
                }
                catch (PartInitException e) {
                    Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer", e.getMessage(), (Throwable)e);
                    JavaActivator.getDefault().getLog().log((IStatus)status);
                }
            }
        });
    }

    protected void scheduleEditorOpening(final IFile source, Job job, Map<DiscoveryParameter, Object> parameters) {
        boolean isSilent = false;
        boolean browseResult = true;
        if (parameters != null) {
            isSilent = Boolean.TRUE.equals(parameters.get(PARAMETER_SILENT_MODE));
            boolean bl = browseResult = !Boolean.FALSE.equals(parameters.get(PARAMETER_BROWSE_RESULT));
        }
        if (!isSilent && browseResult) {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getJob().getResult().isOK()) {
                        DefaultDiscoverer.this.openEditor(source);
                    }
                }
            });
        }
    }
}

