/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.actions;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.common.core.utils.UriUtils;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.actions.Messages;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.core.ui.vm.asm.ASMModelWrapper;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class TranslateJavaModelToKdm {
    private static final String KDM_MM_URI = "http://www.eclipse.org/MoDisco/kdm/action";
    private static final String JAVA_MM_URI = "http://www.eclipse.org/MoDisco/Java/0.2.incubation/java";
    protected static final Logger logger = Logger.getLogger("org.eclipse.m2m.atl");

    public Resource getKDMModelFromJavaModelWithCustomTransformation(URI javaSourceModelUri, URI kdmTargetModelUri) throws IOException, ATLCoreException {
        URL transformation = TranslateJavaModelToKdm.class.getResource("resources/transformations/javaToKdm.asm");
        return this.getKDMModelFromJavaModelWithCustomTransformation(javaSourceModelUri, transformation, kdmTargetModelUri);
    }

    public Resource getKDMModelFromJavaModelWithCustomTransformation(URI javaSourceModelUri, final URL transformation, URI kdmTargetModelUri) throws IOException, ATLCoreException {
        HashMap<String, String> modelHandlers = new HashMap<String, String>();
        String javaMetaModelName = "java";
        modelHandlers.put(javaMetaModelName, "EMF");
        String kdmMetaModelName = "kdm";
        modelHandlers.put(kdmMetaModelName, "EMF");
        HashMap<String, HashMap<String, String>> launcherOptions = new HashMap<String, HashMap<String, String>>();
        launcherOptions.put("modelHandlers", modelHandlers);
        String launcherName = "EMF-specific VM";
        final ILauncher launcher = CoreService.getLauncher((String)launcherName);
        launcher.initialize(launcherOptions);
        ModelFactory factory = CoreService.createModelFactory((String)launcher.getDefaultModelFactoryName());
        IInjector injector = CoreService.getInjector((String)factory.getDefaultInjectorName());
        IExtractor extractor = CoreService.getExtractor((String)factory.getDefaultExtractorName());
        HashMap referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(javaMetaModelName));
        referenceModelOptions.put("modelName", javaMetaModelName);
        referenceModelOptions.put("path", JAVA_MM_URI);
        IReferenceModel javaMM = factory.newReferenceModel(referenceModelOptions);
        injector.inject((IModel)javaMM, JAVA_MM_URI);
        HashMap<String, Object> modelOptions = new HashMap<String, Object>();
        String inModelName = "IN";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", UriUtils.toString((URI)javaSourceModelUri));
        modelOptions.put("newModel", false);
        IModel input = factory.newModel(javaMM, modelOptions);
        injector.inject(input, UriUtils.toString((URI)javaSourceModelUri));
        launcher.addInModel(input, inModelName, javaMetaModelName);
        referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(kdmMetaModelName));
        referenceModelOptions.put("modelName", kdmMetaModelName);
        referenceModelOptions.put("path", KDM_MM_URI);
        IReferenceModel kdmMM = factory.newReferenceModel(referenceModelOptions);
        injector.inject((IModel)kdmMM, KDM_MM_URI);
        modelOptions = new HashMap();
        inModelName = "OUT";
        modelOptions.put("modelName", inModelName);
        if (kdmTargetModelUri == null) {
            modelOptions.put("path", UriUtils.toString((URI)javaSourceModelUri.trimFileExtension().appendFileExtension("kdm")));
        }
        modelOptions.put("path", UriUtils.toString((URI)kdmTargetModelUri));
        modelOptions.put("newModel", true);
        IModel outputInstance = factory.newModel(kdmMM, modelOptions);
        launcher.addOutModel(outputInstance, inModelName, kdmMetaModelName);
        final String targetLogFile = String.valueOf(kdmTargetModelUri.toFileString()) + ".log";
        final HashMap<String, String> options = new HashMap<String, String>();
        options.put("continueAfterError", "true");
        options.put("printExecutionTime", "true");
        Job transformationThread = new Job(Messages.TranslateJavaModelToKdm_ConvertJavaToKDM){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                AtlLogHandler logHandler = new AtlLogHandler(targetLogFile);
                logger.addHandler((Handler)logHandler);
                try {
                    try {
                        launcher.launch("run", monitor, options, new Object[]{transformation.openStream()});
                    }
                    catch (IOException e) {
                        result = Status.CANCEL_STATUS;
                        Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer", "Unkown error.", (Throwable)e);
                        JavaActivator.getDefault().getLog().log((IStatus)status);
                        logger.removeHandler((Handler)logHandler);
                        logHandler.close();
                    }
                }
                finally {
                    logger.removeHandler((Handler)logHandler);
                    logHandler.close();
                }
                return result;
            }
        };
        transformationThread.schedule();
        try {
            transformationThread.join();
        }
        catch (InterruptedException e) {
            Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer", "Unkown error.", (Throwable)e);
            JavaActivator.getDefault().getLog().log((IStatus)status);
        }
        extractor.extract(outputInstance, UriUtils.toString((URI)kdmTargetModelUri));
        Resource output = null;
        if (outputInstance instanceof ASMModelWrapper) {
            ASMModelWrapper wrapper = (ASMModelWrapper)outputInstance;
            ASMModel model = wrapper.getAsmModel();
            if (model instanceof ASMEMFModel) {
                output = ((ASMEMFModel)model).getExtent();
            }
        } else if (outputInstance instanceof EMFModel) {
            output = ((EMFModel)outputInstance).getResource();
        }
        return output;
    }
}

