/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.core;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.AbstractTypeDeclaration;
import org.eclipse.gmt.modisco.java.BodyDeclaration;
import org.eclipse.gmt.modisco.java.EnumDeclaration;
import org.eclipse.gmt.modisco.java.FieldDeclaration;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.NamedElement;
import org.eclipse.gmt.modisco.java.SingleVariableDeclaration;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.TypeAccess;
import org.eclipse.gmt.modisco.java.VariableDeclaration;
import org.eclipse.gmt.modisco.java.VariableDeclarationExpression;
import org.eclipse.gmt.modisco.java.VariableDeclarationStatement;
import org.eclipse.gmt.modisco.java.core.Messages;
import org.eclipse.gmt.modisco.java.emf.util.JavaUtil;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class JavaJdtBridge {
    private final boolean debug = false;

    public final Type getJavaType(Resource resource, IType jdtType) {
        String qualifiedName;
        NamedElement element;
        Type result = null;
        Model rootModel = null;
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof Model)) continue;
            rootModel = (Model)eObject;
        }
        if (rootModel != null && (element = JavaUtil.getNamedElementByQualifiedName(rootModel, (String)(qualifiedName = jdtType.getFullyQualifiedName()))) instanceof Type) {
            result = (Type)element;
        }
        return result;
    }

    public final AbstractMethodDeclaration getJavaOperation(Resource resource, IMethod jdtMethod) {
        String qualifiedName;
        NamedElement element;
        AbstractMethodDeclaration result = null;
        Model rootModel = null;
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof Model)) continue;
            rootModel = (Model)eObject;
        }
        if (rootModel != null && (element = JavaUtil.getNamedElementByQualifiedName(rootModel, (String)(qualifiedName = jdtMethod.getDeclaringType().getFullyQualifiedName()))) instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration parentClass = (AbstractTypeDeclaration)element;
            for (BodyDeclaration bodyDeclaration : parentClass.getBodyDeclarations()) {
                if (!(bodyDeclaration instanceof AbstractMethodDeclaration)) continue;
                AbstractMethodDeclaration operation = (AbstractMethodDeclaration)bodyDeclaration;
                if (!jdtMethod.getElementName().equals(operation.getName()) || jdtMethod.getNumberOfParameters() != operation.getParameters().size()) continue;
                result = operation;
            }
        }
        return result;
    }

    public final IMethod getJdtOperation(IJavaProject javaProject, AbstractMethodDeclaration operation) {
        IMethod result = null;
        if (operation.getAbstractTypeDeclaration() != null) {
            String containerQN = JavaUtil.getQualifiedName((ASTNode)operation.getAbstractTypeDeclaration());
            try {
                IType jdtType = javaProject.findType(containerQN);
                if (jdtType != null) {
                    result = this.findCorrespondingMethod(jdtType, operation);
                }
            }
            catch (JavaModelException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            }
        }
        return result;
    }

    private final IMethod findCorrespondingMethod(IType jdtType, AbstractMethodDeclaration operation) throws JavaModelException {
        IMethod result = null;
        int size = operation.getParameters().size();
        IMethod[] iMethodArray = jdtType.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod jdtMethod = iMethodArray[n2];
            if (jdtMethod.getElementName().equals(operation.getName()) && jdtMethod.getNumberOfParameters() == size) {
                boolean found = true;
                int index = 0;
                while (found && index < size) {
                    SingleVariableDeclaration javaParameter = (SingleVariableDeclaration)operation.getParameters().get(index);
                    String jdtName = jdtMethod.getParameterNames()[index];
                    String jdtTypeName = jdtMethod.getParameterTypes()[index];
                    found = javaParameter.getName().equals(jdtName);
                    boolean typeNameFixed = false;
                    if (typeNameFixed && found) {
                        found = this.getTypeName(javaParameter).equals(jdtTypeName);
                    }
                    ++index;
                }
                if (found) {
                    result = jdtMethod;
                }
            }
            ++n2;
        }
        return result;
    }

    public final IJavaElement getJdtField(IJavaProject javaProject, VariableDeclaration field) {
        IField result = null;
        Type parent = this.getParentContainer((EObject)field);
        if (parent != null) {
            String containerQN = JavaUtil.getQualifiedName((ASTNode)parent);
            try {
                IType jdtType = javaProject.findType(containerQN);
                if (jdtType != null) {
                    EObject container = field.eContainer();
                    if (container instanceof FieldDeclaration || container instanceof EnumDeclaration) {
                        IField ifield = jdtType.getField(field.getName());
                        if (ifield != null) {
                            result = ifield;
                        } else {
                            System.out.println(Messages.JavaJdtBridge_6);
                        }
                    } else if (container instanceof AbstractMethodDeclaration) {
                        AbstractMethodDeclaration operation = (AbstractMethodDeclaration)container;
                        IMethod jdtMethod = this.findCorrespondingMethod(jdtType, operation);
                        result = jdtMethod;
                    } else if (!(container instanceof VariableDeclarationStatement)) {
                        boolean cfr_ignored_0 = container instanceof VariableDeclarationExpression;
                    }
                }
            }
            catch (JavaModelException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            }
        }
        return result;
    }

    private final String getTypeName(SingleVariableDeclaration javaParameter) {
        String result = Messages.JavaJdtBridge_7;
        TypeAccess realType = javaParameter.getType();
        result = realType.getType().getName();
        return result;
    }

    private final Type getParentContainer(EObject node) {
        Type parent = null;
        if (node instanceof Type) {
            parent = (Type)node;
        } else if (node.eContainer() != null) {
            parent = this.getParentContainer(node.eContainer());
        }
        return parent;
    }
}

