/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.io.java;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.Comment;
import org.eclipse.gmt.modisco.java.CompilationUnit;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.gmt.modisco.java.io.java.JDTVisitor;
import org.eclipse.gmt.modisco.java.io.java.binding.PendingElement;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommentsManager {
    private CommentsManager() {
    }

    public static void resolveCommentPositions(JDTVisitor visitor) {
        org.eclipse.jdt.core.dom.CompilationUnit cuJdtNode = visitor.getCuNode();
        CompilationUnit moDiscoCuNode = (CompilationUnit)visitor.getBijectiveMap().getValue((org.eclipse.jdt.core.dom.ASTNode)cuJdtNode);
        ArrayList<Comment> commentsList = new ArrayList<Comment>(visitor.getCommentsBinding().getValues());
        List<Comment> unLocatedComments = CommentsManager.jdtLocationSearch(visitor, cuJdtNode, moDiscoCuNode, commentsList);
        for (Comment comment : unLocatedComments) {
            boolean locationFound = CommentsManager.alternateLocationSearch(comment, visitor);
            if (locationFound) continue;
            if (visitor.getRootTypeOrEnum() != null) {
                visitor.getRootTypeOrEnum().getComments().add((Object)comment);
                continue;
            }
            EcoreUtil.delete((EObject)comment);
        }
    }

    private static List<Comment> jdtLocationSearch(JDTVisitor visitor, org.eclipse.jdt.core.dom.CompilationUnit cuJdtNode, CompilationUnit moDiscoCuNode, List<Comment> commentsList) {
        int index;
        ArrayList<Comment> localCommentList = new ArrayList<Comment>(commentsList);
        TreeMap<Integer, org.eclipse.jdt.core.dom.ASTNode> nodesMap = new TreeMap<Integer, org.eclipse.jdt.core.dom.ASTNode>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -o1.compareTo(o2);
            }
        });
        for (org.eclipse.jdt.core.dom.ASTNode node : visitor.getBijectiveMap().getKeys()) {
            index = cuJdtNode.firstLeadingCommentIndex(node);
            if (index == -1) continue;
            nodesMap.put(index, node);
        }
        for (Integer indexMap : nodesMap.keySet()) {
            ASTNode element;
            index = indexMap;
            org.eclipse.jdt.core.dom.ASTNode jdtNode = (org.eclipse.jdt.core.dom.ASTNode)nodesMap.get(indexMap);
            int lastIndex = cuJdtNode.lastTrailingCommentIndex(jdtNode);
            if (lastIndex == -1) {
                lastIndex = indexMap + 1;
            }
            if ((element = visitor.getBijectiveMap().getValue(jdtNode)) instanceof PendingElement) {
                element = ((PendingElement)element).getClientNode() != null ? ((PendingElement)element).getClientNode() : visitor.getBijectiveMap().getValue(jdtNode.getParent());
            }
            while (index != -1 && index < cuJdtNode.getCommentList().size()) {
                org.eclipse.jdt.core.dom.ASTNode jdtComment = (org.eclipse.jdt.core.dom.ASTNode)cuJdtNode.getCommentList().get(index);
                Comment comment = visitor.getCommentsBinding().get(jdtComment);
                if (comment != null && localCommentList.contains(comment)) {
                    if (index < lastIndex) {
                        ++index;
                        if (!(element instanceof Package)) {
                            element.getComments().add((Object)comment);
                            comment.setPrefixOfParent(true);
                        } else {
                            moDiscoCuNode.getComments().add((Object)comment);
                            comment.setPrefixOfParent(true);
                        }
                        localCommentList.remove(comment);
                        continue;
                    }
                    index = -1;
                    continue;
                }
                index = -1;
            }
        }
        return localCommentList;
    }

    public static String extractCommentContent(org.eclipse.jdt.core.dom.Comment comment, String originalFileContent) {
        String result = originalFileContent.substring(comment.getStartPosition(), comment.getStartPosition() + comment.getLength());
        return result;
    }

    private static boolean alternateLocationSearch(Comment comment, JDTVisitor visitor) {
        ASTNode bestParent = null;
        org.eclipse.jdt.core.dom.ASTNode jdtComment = visitor.getCommentsBinding().getKey(comment);
        int bestFollowingNodeStart = Integer.MAX_VALUE;
        int bestFollowingNodeEnd = Integer.MIN_VALUE;
        int bestEnclosingNodeStart = Integer.MIN_VALUE;
        int bestEnclosingNodeEnd = Integer.MAX_VALUE;
        for (org.eclipse.jdt.core.dom.ASTNode jdtNode : visitor.getBijectiveMap().getKeys()) {
            if (!CommentsManager.mayOwnComment(jdtNode)) continue;
            int sp = jdtNode.getStartPosition();
            int ep = jdtNode.getStartPosition() + jdtNode.getLength();
            if (sp >= jdtComment.getStartPosition() + jdtComment.getLength() && (sp < bestFollowingNodeStart || sp == bestFollowingNodeStart && ep > bestFollowingNodeEnd) && sp < bestEnclosingNodeEnd) {
                bestFollowingNodeStart = sp;
                bestFollowingNodeEnd = ep;
                bestParent = visitor.getBijectiveMap().get(jdtNode);
                comment.setEnclosedByParent(false);
                comment.setPrefixOfParent(true);
            }
            if (sp > jdtComment.getStartPosition() || ep <= jdtComment.getStartPosition() || ep >= bestFollowingNodeStart || ep > bestEnclosingNodeEnd || sp < bestEnclosingNodeStart) continue;
            bestEnclosingNodeEnd = ep;
            bestEnclosingNodeStart = sp;
            bestParent = visitor.getBijectiveMap().get(jdtNode);
            comment.setEnclosedByParent(true);
            comment.setPrefixOfParent(false);
        }
        if (bestParent != null) {
            CommentsManager.attachComment(comment, jdtComment, bestParent, visitor);
            return true;
        }
        return false;
    }

    private static void attachComment(Comment comment, org.eclipse.jdt.core.dom.ASTNode jdtComment, ASTNode receiver, JDTVisitor visitor) {
        if (receiver.getComments().contains((Object)comment)) {
            return;
        }
        int insertIndex = 0;
        while (insertIndex < receiver.getComments().size()) {
            org.eclipse.jdt.core.dom.ASTNode jdtOtherComment = visitor.getCommentsBinding().getKey((Comment)receiver.getComments().get(insertIndex));
            if (jdtOtherComment != null && jdtOtherComment.getStartPosition() > jdtComment.getStartPosition()) break;
            ++insertIndex;
        }
        receiver.getComments().add(insertIndex, (Object)comment);
    }

    private static boolean mayOwnComment(org.eclipse.jdt.core.dom.ASTNode element) {
        return !(element instanceof org.eclipse.jdt.core.dom.Comment) && !(element instanceof TagElement) && !(element instanceof TextElement) && !(element instanceof MemberRef) && !(element instanceof MethodRef);
    }
}

