/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.io.library;

import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.NamedElement;
import org.eclipse.gmt.modisco.java.PrimitiveTypeInt;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.TypeAccess;
import org.eclipse.gmt.modisco.java.emf.JavaFactory;
import org.eclipse.gmt.modisco.java.io.java.binding.Binding;
import org.eclipse.gmt.modisco.java.io.java.binding.BindingManager;
import org.eclipse.gmt.modisco.java.io.java.binding.ClassBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.PendingElement;
import org.eclipse.gmt.modisco.java.io.library.ClassFileParser;
import org.eclipse.gmt.modisco.java.io.library.binding.JavaModelDelegateBindingFactory;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.PrimitiveType;

public final class ClassFileParserUtils {
    private ClassFileParserUtils() {
    }

    public static void manageBindingDeclaration(NamedElement element, IJavaElement javaElement, ClassFileParser visitor) {
        Binding id = JavaModelDelegateBindingFactory.getInstance().getBindingForElement(javaElement, visitor);
        visitor.globalBindings.addTarget(id, element);
    }

    public static void manageBindingRef(TypeAccess element, String name, ClassFileParser visitor) {
        ClassBinding id = JavaModelDelegateBindingFactory.getInstance().getBindingForName(name, visitor, false);
        NamedElement target = visitor.globalBindings.getTarget(id);
        if (target != null) {
            element.setType((Type)target);
        } else {
            PendingElement pending = new PendingElement(visitor.factory);
            pending.setClientNode((ASTNode)element);
            pending.setLinkName("type");
            visitor.globalBindings.addPending(pending, id);
        }
    }

    public static void initializePrimitiveTypes(JavaFactory factory, Model model, BindingManager globalBindings) {
        PrimitiveTypeInt primitiveType;
        if (globalBindings.getTarget(PrimitiveType.INT.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeInt();
            primitiveType.setName(PrimitiveType.INT.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(PrimitiveType.INT.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(PrimitiveType.LONG.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeLong();
            primitiveType.setName(PrimitiveType.LONG.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(PrimitiveType.LONG.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(PrimitiveType.FLOAT.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeFloat();
            primitiveType.setName(PrimitiveType.FLOAT.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(PrimitiveType.FLOAT.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(PrimitiveType.DOUBLE.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeDouble();
            primitiveType.setName(PrimitiveType.DOUBLE.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(PrimitiveType.DOUBLE.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(PrimitiveType.BOOLEAN.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeBoolean();
            primitiveType.setName(PrimitiveType.BOOLEAN.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(PrimitiveType.BOOLEAN.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(PrimitiveType.VOID.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeVoid();
            primitiveType.setName(PrimitiveType.VOID.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(PrimitiveType.VOID.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(PrimitiveType.CHAR.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeChar();
            primitiveType.setName(PrimitiveType.CHAR.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(PrimitiveType.CHAR.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(PrimitiveType.SHORT.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeShort();
            primitiveType.setName(PrimitiveType.SHORT.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(PrimitiveType.SHORT.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(PrimitiveType.BYTE.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeByte();
            primitiveType.setName(PrimitiveType.BYTE.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(PrimitiveType.BYTE.toString(), (NamedElement)primitiveType);
        }
    }

    public static String escapeString(String value) {
        int len = value.length();
        StringBuilder b = new StringBuilder(len + 2);
        b.append("\"");
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            switch (c) {
                case '\b': {
                    b.append("\\b");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\f': {
                    b.append("\\f");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\"': {
                    b.append("\\\"");
                    break;
                }
                case '\'': {
                    b.append("\\'");
                    break;
                }
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '\u0000': {
                    b.append("\\0");
                    break;
                }
                case '\u0001': {
                    b.append("\\1");
                    break;
                }
                case '\u0002': {
                    b.append("\\2");
                    break;
                }
                case '\u0003': {
                    b.append("\\3");
                    break;
                }
                case '\u0004': {
                    b.append("\\4");
                    break;
                }
                case '\u0005': {
                    b.append("\\5");
                    break;
                }
                case '\u0006': {
                    b.append("\\6");
                    break;
                }
                case '\u0007': {
                    b.append("\\7");
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            ++i;
        }
        b.append("\"");
        return b.toString();
    }

    public static String escapeCharacter(char value) {
        StringBuilder b = new StringBuilder(3);
        b.append('\'');
        switch (value) {
            case '\b': {
                b.append("\\b");
                break;
            }
            case '\t': {
                b.append("\\t");
                break;
            }
            case '\n': {
                b.append("\\n");
                break;
            }
            case '\f': {
                b.append("\\f");
                break;
            }
            case '\r': {
                b.append("\\r");
                break;
            }
            case '\"': {
                b.append("\\\"");
                break;
            }
            case '\'': {
                b.append("\\'");
                break;
            }
            case '\\': {
                b.append("\\\\");
                break;
            }
            case '\u0000': {
                b.append("\\0");
                break;
            }
            case '\u0001': {
                b.append("\\1");
                break;
            }
            case '\u0002': {
                b.append("\\2");
                break;
            }
            case '\u0003': {
                b.append("\\3");
                break;
            }
            case '\u0004': {
                b.append("\\4");
                break;
            }
            case '\u0005': {
                b.append("\\5");
                break;
            }
            case '\u0006': {
                b.append("\\6");
                break;
            }
            case '\u0007': {
                b.append("\\7");
                break;
            }
            default: {
                b.append(value);
            }
        }
        b.append('\'');
        return b.toString();
    }

    public static boolean isJavaLangObject(String signature) {
        return JavaModelDelegateBindingFactory.javaLangObjectSignature.equals(signature);
    }
}

