/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.discoverer.kdm.source.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.common.core.utils.Tools;
import org.eclipse.gmt.modisco.discoverer.kdm.source.KDMSourceDiscoverer;
import org.eclipse.gmt.modisco.discoverer.kdm.source.actions.Messages;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverSourceModelFromContainer
implements Discoverer {
    private final String targetExtension = "kdm";
    private final DiscoveryParameterImpl targetModel;
    private final DiscoveryParameterImpl targetUri;
    private final List<DiscoveryParameter> discovererParameters = new ArrayList<DiscoveryParameter>();

    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IJavaProject) {
            result = true;
        } else if (source instanceof IContainer) {
            result = true;
        }
        return result;
    }

    public Resource discoverElement(Object source, URI target) {
        IPath path;
        Resource resource;
        block17: {
            resource = null;
            Logger logger = Logger.getLogger(this.getClass().getName());
            IProject tempProject = null;
            if (source instanceof IJavaProject) {
                tempProject = ((IJavaProject)source).getProject();
            } else if (source instanceof IContainer) {
                tempProject = (IContainer)source;
            }
            IProject project = tempProject;
            Object tempPath = project.getProject().getLocation().addTrailingSeparator().append(String.valueOf(project.getName()) + "_Source").addFileExtension("kdm");
            if (target != null) {
                tempPath = target.isRelative() ? ResourcesPlugin.getWorkspace().getRoot().getFullPath().append(target.path()) : new Path(target.toFileString());
            }
            path = tempPath;
            AtlLogHandler logHandler = new AtlLogHandler(String.valueOf(path.toString()) + ".log");
            logger.addHandler((Handler)logHandler);
            try {
                try {
                    KDMSourceDiscoverer disco = new KDMSourceDiscoverer();
                    resource = disco.getKDMModelFromContainer((IContainer)project);
                    if (target != null) {
                        Tools.saveModel((Resource)resource, (URI)target);
                    } else {
                        Tools.saveModel((Resource)resource, (String)path.toString());
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error in discovery of container", e);
                    logger.removeHandler((Handler)logHandler);
                    logHandler.close();
                    try {
                        project.refreshLocal(1, null);
                    }
                    catch (Exception exception) {}
                    break block17;
                }
            }
            catch (Throwable throwable) {
                logger.removeHandler((Handler)logHandler);
                logHandler.close();
                try {
                    project.refreshLocal(1, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            logger.removeHandler((Handler)logHandler);
            logHandler.close();
            try {
                project.refreshLocal(1, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IFile ifile = root.getFileForLocation(path);
                    if (ifile != null && ifile.exists()) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)ifile);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
        return resource;
    }

    public String toString() {
        return Messages.DiscoverSourceModelFromContainer_0;
    }

    public DiscoverSourceModelFromContainer() {
        this.targetModel = new DiscoveryParameterImpl("TargetModel", DiscoveryParameterDirectionKind.out, Resource.class, false);
        this.discovererParameters.add((DiscoveryParameter)this.targetModel);
        this.targetUri = new DiscoveryParameterImpl("TargetUri", DiscoveryParameterDirectionKind.in, URI.class, false);
        this.discovererParameters.add((DiscoveryParameter)this.targetUri);
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        Object value;
        URI targetUri = null;
        if (parameters.containsKey(this.targetUri) && (value = parameters.get(this.targetUri)) instanceof URI) {
            targetUri = (URI)value;
        }
        Resource result = this.discoverElement(source, targetUri);
        parameters.put((DiscoveryParameter)this.targetModel, result);
    }

    public List<DiscoveryParameter> getDiscovererParameters() {
        return Collections.unmodifiableList(this.discovererParameters);
    }
}

