/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.discoverer.kdm.source.popup.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.utils.Tools;
import org.eclipse.gmt.modisco.discoverer.kdm.source.KDMSourceDiscoverer;
import org.eclipse.gmt.modisco.discoverer.kdm.source.popup.actions.Messages;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromContainerToKDMSource
implements IObjectActionDelegate {
    private static final String KDM_EXTENSION = "kdm";
    private List<IContainer> selectedContainers = new ArrayList<IContainer>();

    public final void run(IAction action) {
        final ArrayList newModelsPaths = new ArrayList();
        Job job = new Job(Messages.FromContainerToKDMSource_1){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    KDMSourceDiscoverer disco = new KDMSourceDiscoverer();
                    Resource kdmResource = null;
                    if (FromContainerToKDMSource.this.getSelectedContainers() != null) {
                        for (IContainer aContainer : FromContainerToKDMSource.this.getSelectedContainers()) {
                            kdmResource = disco.getKDMModelFromContainer(aContainer);
                            if (kdmResource == null) continue;
                            IPath path = aContainer.getLocation().addTrailingSeparator().append(aContainer.getName()).addFileExtension(FromContainerToKDMSource.KDM_EXTENSION);
                            Tools.saveModel((Resource)kdmResource, (String)path.toString());
                            aContainer.refreshLocal(1, monitor);
                            newModelsPaths.add(path);
                        }
                    }
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                FromContainerToKDMSource.this.openEditor(newModelsPaths);
            }
        });
        job.schedule();
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        this.getSelectedContainers().clear();
        for (Object selectedElement : ((IStructuredSelection)selection).toList()) {
            if (selectedElement instanceof IJavaProject) {
                this.getSelectedContainers().add((IContainer)((IJavaProject)selectedElement).getResource());
                continue;
            }
            if (!(selectedElement instanceof IContainer)) continue;
            this.getSelectedContainers().add((IContainer)selectedElement);
        }
    }

    private void openEditor(final List<IPath> newModelsPaths) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    for (IPath aNewModelPath : newModelsPaths) {
                        IFile ifile = root.getFileForLocation(aNewModelPath);
                        if (!ifile.exists()) continue;
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)ifile);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public final List<IContainer> getSelectedContainers() {
        return this.selectedContainers;
    }
}

