/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.kdm.uml2converter.actions;

import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterImpl;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.gmt.modisco.kdm.uml2converter.KdmToUml2Activator;
import org.eclipse.gmt.modisco.kdm.uml2converter.KdmToUmlConverterInterface;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/**
 * @author Gabriel Barbier
 * 
 */
public class DiscoverUmlModelFromKdmModel extends AbstractDiscovererImpl implements Discoverer {

	private final String sourceExtension = "kdm"; //$NON-NLS-1$
	private final String targetExtension = "uml"; //$NON-NLS-1$
	
	private final DiscoveryParameter customTransformationParameter;
	
	public final DiscoveryParameter getCustomTransformationParameter() {
		return this.customTransformationParameter;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.gmt.modisco.infra.discoverymanager.DiscovererInterface#applyTo
	 * (java.lang.Object)
	 */
	public boolean isApplicableTo(final Object source) {
		boolean result = false;
		if (source instanceof IFile) {
			IFile iFile = (IFile) source;
			String extension = iFile.getFileExtension();
			if ((extension != null) && (extension.equals(this.sourceExtension))) {
				result = true;
			}
		}
		return result;
	}

	public String toString() {
		return Messages.DiscoverUmlModelFromKdmModel_4;
	}

	public DiscoverUmlModelFromKdmModel() {
		super();
		this.customTransformationParameter = new DiscoveryParameterImpl("CustomTransformation", DiscoveryParameterDirectionKind.in, IFile.class, false); //$NON-NLS-1$
		this.getBasicDiscovererParameters().add(this.customTransformationParameter);
	}

	
	public void discoverElement(final Object source,
			final Map<DiscoveryParameter, Object> parameters) {
		Resource result = null;
		URI target = null;
		if (parameters.containsKey(this.getTargetUriParameter())) {
			Object value = parameters.get(this.getTargetUriParameter());
			if (value instanceof URI) {
				target = (URI) value;
			}
		}
		
		// retrieval of Java project
		final IFile iFile = (IFile) source;
		final String sourcePath = iFile.getLocation().toString();
		
		// retrieval of target path
		IPath tempPath = iFile.getLocation().removeFileExtension().addFileExtension(this.targetExtension);
		if (target != null) {
			if (target.isRelative()) {
				tempPath = ResourcesPlugin.getWorkspace().getRoot()
						.getFullPath().append(target.path());
			} else {
				tempPath = new Path(target.toFileString());
			}
		}

		final IPath path = tempPath;

		try {
			final KdmToUmlConverterInterface transfo = new KDMtoUML2Converter();
			Resource kdmModel = new XMIResourceImpl();
			kdmModel.setURI(URI.createFileURI(sourcePath));
			URI outputURI = URI.createFileURI(path.toString());
			Resource[] resources = null;
			if (parameters.containsKey(this.getCustomTransformationParameter())) {
				Object object = parameters.get(this.getCustomTransformationParameter());
				System.out.println(object);
				System.out.println(object.getClass());
//				IFile customTransfo = (IFile) parameters.get(this.getCustomTransformationParameter());
//				resources = transfo.getUML2ModelFromKDMModelWithCustomTransformation(kdmModel.getURI(),
//						false, customTransfo.getLocationURI().toURL(), outputURI);
			} else {
				resources = transfo.getUML2ModelFromKDMModel(kdmModel, false, outputURI);
			}
			result = resources[0];
		} catch (Exception e) {
			MoDiscoLogger.logError(e, KdmToUml2Activator.getDefault());
		} finally {
			try {
				iFile.getParent().refreshLocal(1, null);
			} catch (Exception e1) {
				MoDiscoLogger.logWarning(e1, KdmToUml2Activator.getDefault());
			}
		}
		// access UI resources so that we can obtain the current eclipse
		// workbench activePage
		Display.getDefault().asyncExec(new Runnable() {
			public void run() {
				try {
					IWorkspaceRoot root = ResourcesPlugin.getWorkspace()
							.getRoot();
					IFile ifile = root.getFileForLocation(path);
					if ((ifile != null) && ifile.exists()) {
						IWorkbenchPage page = PlatformUI.getWorkbench()
								.getActiveWorkbenchWindow().getActivePage();
						// programmatically opens the model using the
						// default editor if one is present
						IDE.openEditor(page, ifile);
					}
				} catch (PartInitException e) {
					MoDiscoLogger.logWarning(e, KdmToUml2Activator.getDefault());
				}
			}
		});
		
		parameters.put(this.getTargetModelParameter(), result);
	}

}
