/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.modelfilter.dependencies.actions;

import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.core.JavaJdtBridge;
import org.eclipse.gmt.modisco.usecase.modelfilter.dependencies.Activator;
import org.eclipse.gmt.modisco.usecase.modelfilter.dependencies.editor.PrefuseGraphInput;
import org.eclipse.gmt.modisco.usecases.modelfilter.converter.MethodCallsJavaConverter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverDependenciesFromJdtType
extends AbstractDiscovererImpl
implements Discoverer {
    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IType) {
            result = true;
        } else if (source instanceof ICompilationUnit) {
            result = true;
            ICompilationUnit compilationUnit = (ICompilationUnit)source;
            System.out.println(compilationUnit.getElementName());
        }
        return result;
    }

    public String toString() {
        return "Discover dependencies from java type";
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        Resource resource = null;
        IType jdtType = null;
        if (source instanceof IType) {
            jdtType = (IType)source;
        } else {
            ICompilationUnit compilationUnit = (ICompilationUnit)source;
            String typeName = compilationUnit.getPath().removeFileExtension().lastSegment();
            jdtType = compilationUnit.getType(typeName);
        }
        IJavaProject project = jdtType.getJavaProject();
        if (project != null) {
            try {
                MethodCallsJavaConverter discoverer = new MethodCallsJavaConverter(project);
                resource = discoverer.convertJavaProjectToJavaModel();
                JavaJdtBridge bridge = new JavaJdtBridge();
                Type modelType = bridge.getJavaType(resource, jdtType);
                PrefuseGraphInput inputTemp = null;
                inputTemp = modelType != null ? new PrefuseGraphInput(modelType, project) : new PrefuseGraphInput(resource, project);
                final PrefuseGraphInput input = inputTemp;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"org.eclipse.gmt.modisco.usecase.modelfilter.dependencies.modeleditor.prefuse.EditorID", (boolean)true);
                        }
                        catch (PartInitException e) {
                            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                        }
                    }
                });
            }
            catch (JavaModelException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        } else {
            MoDiscoLogger.logInfo((String)"No corresponding java project found.", (Plugin)Activator.getDefault());
        }
        parameters.put(this.getTargetModelParameter(), resource);
    }
}

