/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.actions;

import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor.MethodCallsPrefuseGraphEditor;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor.PrefuseGraphInput;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/**
 * @author Gabriel Barbier
 * 
 */
public class DiscoverPrefuseGraphOfMethodCallsFromJavaModel extends AbstractDiscovererImpl implements Discoverer {
	private final String sourceSuffix = "javaxmi";
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.gmt.modisco.discoverersmanager.DiscovererInterface#applyTo
	 * (java.lang.Object)
	 */
	public boolean isApplicableTo(final Object source) {
		boolean result = false;
		if (source instanceof IFile) {
			IFile ifile = (IFile) source;
			if (ifile.getFileExtension().equalsIgnoreCase(this.sourceSuffix)) {
				result = true;
			}
		}
		return result;
	}

	
	public String toString() {
		return "Discover MethodCalls model from Java model";
	}

	public void discoverElement(final Object source,
			final Map<DiscoveryParameter, Object> parameters) {
		Resource resource = null;
		final IFile ifile = (IFile) source;
		IProject tempProject = ifile.getProject();
		IJavaProject project = null;
		try {
			if (tempProject.hasNature(JavaCore.NATURE_ID)) {
				project = JavaCore.create(tempProject);
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
//		MethodCallsPrefuseGraphReader prefuseReader = new MethodCallsPrefuseGraphReader();
//		prefuseReader.initializePrefuse(ifile);
		
		final PrefuseGraphInput input = new PrefuseGraphInput(ifile, project);
		
		// access UI resources so that we can obtain the current eclipse
		// workbench activePage
		Display.getDefault().asyncExec(new Runnable() {
			public void run() {
				try {
					IWorkbenchPage page = PlatformUI.getWorkbench()
								.getActiveWorkbenchWindow().getActivePage();
						// programmatically opens the j2se5 model using the
						// default editor if one is present
					IDE.openEditor(page, input, MethodCallsPrefuseGraphEditor.EditorID, true);
				} catch (PartInitException e) {
					e.printStackTrace();
				}
			}
		});
		parameters.put(this.getTargetModelParameter(), resource);
	}

}
