/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.actions;

import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.Activator;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor.NewMethodCallsPrefuseGraphEditor;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor.NewPrefuseGraphInput;
import org.eclipse.gmt.modisco.usecases.modelfilter.converter.MethodCallsJavaConverter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/**
 * @author Gabriel Barbier
 * 
 */
public class DiscoverPrefuseGraphOfMethodCallsFromJavaProject extends AbstractDiscovererImpl implements Discoverer {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.gmt.modisco.discoverersmanager.DiscovererInterface#applyTo
	 * (java.lang.Object)
	 */
	public boolean isApplicableTo(final Object source) {
		boolean result = false;
		if (source instanceof IJavaProject) {
			result = true;
		} else if (source instanceof IProject) {
			IProject project = (IProject) source;
			try {
				if (project.hasNature(JavaCore.NATURE_ID)) {
					result = true;
				}
			} catch (CoreException e) {
				e.printStackTrace();
			}
		}
		return result;
	}

	
	public String toString() {
		return "Discover MethodCalls model from Java project";
	}

	public void discoverElement(final Object source,
			final Map<DiscoveryParameter, Object> parameters) {
		Resource resource = null;
		// retrieval of Java project
		IJavaProject tempProject = null;
		if (source instanceof IJavaProject) {
			tempProject = (IJavaProject) source;
		} else if (source instanceof IProject) {
			IProject project = (IProject) source;
			try {
				if (project.hasNature(JavaCore.NATURE_ID)) {
					tempProject = JavaCore.create(project);
				}
			} catch (CoreException e) {
				e.printStackTrace();
			}
		}
		final IJavaProject project = tempProject;
		if (project != null) {
			
			try {
				MethodCallsJavaConverter discoverer;
				discoverer = new MethodCallsJavaConverter(project);
				resource = discoverer.convertJavaProjectToJavaModel();
				
//				MethodCallsPrefuseGraphReader prefuseReader = new MethodCallsPrefuseGraphReader();
				NewPrefuseGraphInput inputTemp = null;
				
				inputTemp = new NewPrefuseGraphInput(resource, project);
								
				final NewPrefuseGraphInput input = inputTemp;
				
				// access UI resources so that we can obtain the current eclipse
				// workbench activePage
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						try {
							IWorkbenchPage page = PlatformUI.getWorkbench()
										.getActiveWorkbenchWindow().getActivePage();
								// programmatically opens the j2se5 model using the
								// default editor if one is present
							IDE.openEditor(page, input, NewMethodCallsPrefuseGraphEditor.EditorID, true);
						} catch (PartInitException e) {
							e.printStackTrace();
						}
					}
				});
			} catch (JavaModelException e) {
				MoDiscoLogger.logError(e, Activator.getDefault());
			}
		} else {
			
		}
		parameters.put(this.getTargetModelParameter(), resource);
	}

}
