/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterImpl;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter.JavaUmlBridge;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor.MethodCallsZestGraphEditor;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor.ZestGraphInput;
import org.eclipse.gmt.modisco.usecases.modelfilter.converter.MethodCallsJavaConverter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.uml2.uml.Operation;

/**
 * @author Gabriel Barbier
 * 
 */
public class DiscoverZestGraphOfMethodCallsFromJavaOperation implements Discoverer {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.gmt.modisco.discoverersmanager.DiscovererInterface#applyTo
	 * (java.lang.Object)
	 */
	public boolean isApplicableTo(final Object source) {
		boolean result = false;
		if (source instanceof IMethod) {
			result = true;
		}
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seeorg.eclipse.gmt.modisco.discoverersmanager.DiscovererInterface#
	 * discoverElement(java.lang.Object, org.eclipse.emf.common.util.URI)
	 */
	public Resource discoverElement(final Object source, final URI target) {
		Resource resource = null;
		
		IMethod method = (IMethod) source;
		// retrieval of Java project
		final IJavaProject project = method.getJavaProject();
		if (project != null) {
			
			try {
				MethodCallsJavaConverter discoverer;
				discoverer = new MethodCallsJavaConverter(project);
				resource = discoverer.convertJavaProjectToUml2();
				
				ZestGraphInput inputTemp = null;
				/*
				 * we will retrieve uml operation, corresponding to java method
				 * if not, we will use the whole model
				 */
				JavaUmlBridge bridge = new JavaUmlBridge();
				Operation targetOperation = bridge.getUmlOperation(resource, method);
				if (targetOperation != null) {
					inputTemp = new ZestGraphInput(targetOperation);
				} else {
					inputTemp = new ZestGraphInput(resource);
				}
				
				final ZestGraphInput input = inputTemp;
				
				// access UI resources so that we can obtain the current eclipse
				// workbench activePage
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						try {
							IWorkbenchPage page = PlatformUI.getWorkbench()
										.getActiveWorkbenchWindow().getActivePage();
								// programmatically opens the j2se5 model using the
								// default editor if one is present
							IDE.openEditor(page, input, MethodCallsZestGraphEditor.EditorID, true);
						} catch (PartInitException e) {
							e.printStackTrace();
						}
					}
				});
			} catch (JavaModelException e) {
				e.printStackTrace();
			} catch (ATLCoreException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
		} else {
			System.out.println("No java project ???");
		}
		return resource;
	}

	public String toString() {
		return "Discover MethodCalls model from Java operation";
	}

	public DiscoverZestGraphOfMethodCallsFromJavaOperation() {
		this.targetModel = new DiscoveryParameterImpl("TargetModel", DiscoveryParameterDirectionKind.out, Resource.class, false);
		this.discovererParameters.add(this.targetModel);
		this.targetUri = new DiscoveryParameterImpl("TargetUri", DiscoveryParameterDirectionKind.in, URI.class, false);
		this.discovererParameters.add(this.targetUri);
	}

	private final DiscoveryParameterImpl targetModel;
	private final DiscoveryParameterImpl targetUri;
	private final List<DiscoveryParameter> discovererParameters = new ArrayList<DiscoveryParameter>();
	
	public void discoverElement(final Object source,
			final Map<DiscoveryParameter, Object> parameters) {
		URI targetUri = null;
		if (parameters.containsKey(this.targetUri)) {
			Object value = parameters.get(this.targetUri);
			if (value instanceof URI) {
				targetUri = (URI) value;
			}
		}
		Resource result = this.discoverElement(source, targetUri);
		parameters.put(this.targetModel, result);
	}

	public List<DiscoveryParameter> getDiscovererParameters() {
		return Collections.unmodifiableList(this.discovererParameters);
	}
}
