/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PackageableElement;

/**
 * @author Gabriel Barbier
 *
 */
public class JavaUmlBridge {

	public final Operation getUmlOperation(Resource resource, IMethod javaMethod) {
		Operation result = null;
		/*
		 * To retrieve the uml operation corresponding to the java method,
		 * we have to navigate in uml model ...
		 * 1. get the root model
		 * 2. retrieve sub model which name is equals to java project name
		 *  which contains the java method
		 * 3. navigate in packages hierarchy
		 * 4. navigate in classes hierarchy (inner classes)
		 * 5. get the good operation using signature :
		 * 		- name
		 * 		- number of parameters
		 * 		- type of parameters
		 * 		- name of parameters
		 * 
		 * Warning, return parameter has not to be used !
		 */
		/*
		 * 1. get the root model
		 */
		Model rootModel = null;
		for (EObject eObject : resource.getContents()) {
			if (eObject instanceof Model) {
				rootModel = (Model) eObject;
			}
		}
		if (rootModel != null) {
			/*
			 * 2. retrieve sub model which name is equals to java project name
			 *  which contains the java method
			 */
			org.eclipse.uml2.uml.Package projectPackage =
				rootModel.getNestedPackage(javaMethod.getJavaProject().getElementName());
			if (projectPackage != null) {
				/*
				 * 3. navigate in packages hierarchy
				 */
				ICompilationUnit icu = javaMethod.getCompilationUnit();
				try {
					IPackageDeclaration pack = null;
					for (IPackageDeclaration temp : icu.getPackageDeclarations()) {
						pack = temp; // it should have only one !
					}
					if (pack != null) {
						org.eclipse.uml2.uml.Package parentPackage = projectPackage;
						for (String subPack : pack.getElementName().split("\\.")) {
							if (parentPackage != null) {
								parentPackage = parentPackage.getNestedPackage(subPack);
							}
						}
						if (parentPackage != null) {
							/*
							 * 4. navigate in classes hierarchy (inner classes)
							 */
							// TODO manage inner classes
							PackageableElement parentClass = parentPackage.getPackagedElement(javaMethod.getDeclaringType().getElementName());
							if (parentClass != null) {
								/*
								 * 5. get the good operation using signature :
								 * 		- name
								 * 		- number of parameters
								 * 		- type of parameters
								 * 		- name of parameters
								 */
								for (Operation operation : ((Classifier) parentClass).getOperations()) {
									if (javaMethod.getElementName().equals(operation.getName())) {
										if (javaMethod.getNumberOfParameters() == (operation.getOwnedParameters().size() - 1)) {
											// check attributes name and type
											result = operation;
										}
									}
								}
							}
						}
					}
				} catch (JavaModelException e1) {
					e1.printStackTrace();
				}
			}
		}
		
		return result;
	}
	
	public final IMethod getJavaOperation(final IJavaProject javaProject, final Operation operation) {
		IMethod result = null;
		/*
		 * Typically, we have the class containing this method, and will
		 * use its qualified name to retrieve corresponding element in java project
		 * ie, the real artifact (java file).
		 * So before any operation, we have to remove two levels,
		 * first level corresponds to root model
		 * second level corresponds to java project model (in uml)
		 */
		String containerQN = operation.getNamespace().getQualifiedName();
		containerQN = containerQN.replaceFirst("root model::", "");
		containerQN = containerQN.replaceFirst(javaProject.getElementName()+"::", "");
		containerQN = containerQN.replaceAll("::", ".");
		
		try {
			IType javaType = javaProject.findType(containerQN);
			if (javaType != null) {
				int size = operation.getOwnedParameters().size();
				for (IMethod javaMethod : javaType.getMethods()) {
					if (javaMethod.getElementName().equals(operation.getName())) {
						if (javaMethod.getNumberOfParameters() == (
								size == 0 ? size : size - 1)) {
							// check attributes name and type
							result = javaMethod;
						}
					}
				}
			}
		} catch (JavaModelException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return result;
	}
}
