package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter;

import java.awt.event.MouseEvent;

import javax.swing.JPanel;

import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.actions.BrowseJavaCode;
import org.eclipse.modisco.prefuse.PrefuseGraphContainer;

import prefuse.controls.ControlAdapter;
import prefuse.data.Graph;
import prefuse.data.Tuple;
import prefuse.visual.VisualItem;


public class PrefuseGraphContainerForJava extends PrefuseGraphContainer {

	private static PrefuseGraphContainerForJava instance = new PrefuseGraphContainerForJava();
	private PrefuseGraphContainerForJava() {
		
	}
	
	public static PrefuseGraphContainerForJava getInstance() {
		return PrefuseGraphContainerForJava.instance;
	}
	
	public final static String javaOperation = "javaOperation";
	public final static String jdtProject = "jdtProject";
	
	
    /* (non-Javadoc)
	 * @see org.eclipse.modisco.prefuse.PrefuseGraphContainer#initializeTreeViewContainer(prefuse.data.Graph, java.lang.String)
	 */
	@Override
	public JPanel initializeTreeViewContainer(final Graph graph, final String label, final String image) {
		ControlAdapter controlAdapter = new ControlAdapter() {
            /* (non-Javadoc)
			 * @see prefuse.controls.ControlAdapter#itemClicked(prefuse.visual.VisualItem, java.awt.event.MouseEvent)
			 */
			@Override
			public void itemClicked(VisualItem item, MouseEvent e) {
				/*
				 * Left button and double click
				 */
				if ((e.getButton() == MouseEvent.BUTTON1) && (e.getClickCount() > 1)) {
					/*
					 * We get the source object (Node)
					 * with method "item.getSourceTuple()"
					 * 
					 * From the tuple, we could get the source Uml operation
					 * (underground attribute)
					 */
					Tuple tuple = item.getSourceTuple();
					if (tuple.canGet(PrefuseGraphContainerForJava.javaOperation, AbstractMethodDeclaration.class)) {
						AbstractMethodDeclaration operation = (AbstractMethodDeclaration) tuple.get(PrefuseGraphContainerForJava.javaOperation);
						/*
						 * we don't have to browse the code it is a proxy element ...
						 */
						if (operation.isProxy() == false) {
							/*
							 * go back to the corresponding java code !!!
							 */
							BrowseJavaCode browserUtil = new BrowseJavaCode();
							browserUtil.browseJavaCode(operation);
						}
					}
				}
			}
        };
		JPanel result = this.initializeTreeViewContainer(graph, label, image, controlAdapter);
		return result;
	}
    
}
