package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter;

import java.awt.event.MouseEvent;

import javax.swing.JPanel;

import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.Activator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.modisco.prefuse.PrefuseGraphContainer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.uml2.uml.Operation;

import prefuse.controls.ControlAdapter;
import prefuse.data.Graph;
import prefuse.data.Tuple;
import prefuse.visual.VisualItem;


public class PrefuseGraphContainerForUml extends PrefuseGraphContainer {
	private static PrefuseGraphContainerForUml instance = new PrefuseGraphContainerForUml();
	private PrefuseGraphContainerForUml() {
		
	}
	
	public static PrefuseGraphContainerForUml getInstance() {
		return PrefuseGraphContainerForUml.instance;
	}
	
	public final static String umlOperation = "umlOperation";
	public final static String javaProject = "javaProject";
	
	/* (non-Javadoc)
	 * @see org.eclipse.modisco.prefuse.PrefuseGraphContainer#initializeTreeViewContainer(prefuse.data.Graph, java.lang.String)
	 */
	@Override
	public JPanel initializeTreeViewContainer(final Graph graph, final String label, final String image) {
		ControlAdapter controlAdapter = new ControlAdapter() {
            /* (non-Javadoc)
			 * @see prefuse.controls.ControlAdapter#itemClicked(prefuse.visual.VisualItem, java.awt.event.MouseEvent)
			 */
			@Override
			public void itemClicked(VisualItem item, MouseEvent e) {
				/*
				 * Left button and double click
				 */
				if ((e.getButton() == MouseEvent.BUTTON1) && (e.getClickCount() > 1)) {
					/*
					 * We get the source object (Node)
					 * with method "item.getSourceTuple()"
					 * 
					 * From the tuple, we could get the source Uml operation
					 * (underground attribute)
					 */
					Tuple tuple = item.getSourceTuple();
					if (tuple.canGet(PrefuseGraphContainerForUml.umlOperation, Operation.class)) {
						Operation operation = (Operation) tuple.get(PrefuseGraphContainerForUml.umlOperation);
						IJavaProject javaProject = (IJavaProject) tuple.get(PrefuseGraphContainerForUml.javaProject);
						/*
						 * go back to the corresponding java code !!!
						 */
						JavaUmlBridge bridge = new JavaUmlBridge();
						final IMethod method = bridge.getJavaOperation(javaProject, operation);
						if (method != null) {
							Display.getDefault().asyncExec(new Runnable() {
								public void run() {
									try {
										// programmatically opens the jdt element using the
										// default editor if one is present							
										JavaUI.openInEditor(method);											
									} catch (PartInitException e) {
										MoDiscoLogger.logError(e, Activator.getDefault());
									} catch (JavaModelException e) {
										MoDiscoLogger.logError(e, Activator.getDefault());
									}
								}
							});
							
							
						}
					}
				}
			}
        };
		JPanel result = this.initializeTreeViewContainer(graph, label, image, controlAdapter);
		return result;
	}

}
