/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

/**
 * @author Gabriel Barbier
 *
 */
public class NewPrefuseGraphInput implements IEditorInput {

	private final IFile javaxmiFile;
	private final Resource javaxmiResource;
	private final AbstractMethodDeclaration inputOperation;
	private final IJavaProject javaProject;
	
	/**
	 * @param ifile
	 */
	public NewPrefuseGraphInput(IFile ifile, IJavaProject project) {
		this.javaxmiFile = ifile;
		this.javaProject = project;
		this.inputOperation = null;
		this.javaxmiResource = null;
	}

	/**
	 * @param ifile
	 */
	public NewPrefuseGraphInput(Resource resource, IJavaProject project) {
		this.javaxmiFile = null;
		this.inputOperation = null;
		this.javaxmiResource = resource;
		this.javaProject = project;
	}
	/**
	 * @param ifile
	 */
	public NewPrefuseGraphInput(AbstractMethodDeclaration operation, IJavaProject project) {
		this.javaxmiFile = null;
		this.inputOperation = operation;
		this.javaProject = project;
		this.javaxmiResource = null;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#exists()
	 */
	public boolean exists() {
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getImageDescriptor()
	 */
	public ImageDescriptor getImageDescriptor() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getName()
	 */
	public String getName() {
		return "Prefuse Graph viewer";
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getPersistable()
	 */
	public IPersistableElement getPersistable() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getToolTipText()
	 */
	public String getToolTipText() {
		return "Prefuse Graph viewer";
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	@SuppressWarnings("unchecked")
	public Object getAdapter(Class adapter) {
		return null;
	}

	/**
	 * @return the inputFile
	 */
	public IFile getJavaxmiFile() {
		return this.javaxmiFile;
	}

	/**
	 * @return the inputResource
	 */
	public Resource getJavaxmiResource() {
		return this.javaxmiResource;
	}

	/**
	 * @return the inputOperation
	 */
	public AbstractMethodDeclaration getInputOperation() {
		return this.inputOperation;
	}

	/**
	 * @return the javaProject
	 */
	public IJavaProject getJavaProject() {
		return this.javaProject;
	}

}
