/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.uml2.uml.Operation;

/**
 * @author Gabriel Barbier
 *
 */
public class ZestGraphInput implements IEditorInput {

	private final IFile inputFile;
	private final Resource inputResource;
	private final Operation inputOperation;
	
	/**
	 * @param ifile
	 */
	public ZestGraphInput(IFile ifile) {
		this.inputFile = ifile;
		this.inputOperation = null;
		this.inputResource = null;
	}

	/**
	 * @param ifile
	 */
	public ZestGraphInput(Resource resource) {
		this.inputFile = null;
		this.inputOperation = null;
		this.inputResource = resource;
	}
	/**
	 * @param ifile
	 */
	public ZestGraphInput(Operation operation) {
		this.inputFile = null;
		this.inputOperation = operation;
		this.inputResource = null;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#exists()
	 */
	public boolean exists() {
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getImageDescriptor()
	 */
	public ImageDescriptor getImageDescriptor() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getName()
	 */
	public String getName() {
		return "Zest Graph viewer";
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getPersistable()
	 */
	public IPersistableElement getPersistable() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getToolTipText()
	 */
	public String getToolTipText() {
		return "Zest Graph viewer";
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	@SuppressWarnings("unchecked")
	public Object getAdapter(Class adapter) {
		return null;
	}

	/**
	 * @return the inputFile
	 */
	public IFile getInputFile() {
		return this.inputFile;
	}

	/**
	 * @return the inputResource
	 */
	public Resource getInputResource() {
		return this.inputResource;
	}

	/**
	 * @return the inputOperation
	 */
	public Operation getInputOperation() {
		return this.inputOperation;
	}

}
