package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.modiscoworks;	
	
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.workflow.DriverExecutionInterface;
import org.eclipse.gmt.modisco.workflow.controller.ControllerDriverPage;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Workflow;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Work;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterValue;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Direction;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.ModiscoworkflowPackage;
import org.eclipse.core.resources.ResourcesPlugin;

public class DiscoverMethodCallsUmlModel{
	private Workflow workflow;
	private Resource resource;
	private Work element;
	

	public DiscoverMethodCallsUmlModel(){
		initialization();
	}
	
	private void initialization(){
		ModiscoworkflowPackage.eINSTANCE.eClass();
		URI uri = URI.createFileURI(ResourcesPlugin.getWorkspace().getRoot().getLocation().append("org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls").append("org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls").addFileExtension("modiscoworkflow").toString());
		ResourceSet resSet = new ResourceSetImpl();
		this.resource = resSet.getResource(uri,true);
		this.workflow = (Workflow)this.resource.getContents().get(0);
		findMoDiscoWork(this.workflow.getElements());
	}
	
	private void findMoDiscoWork(List<Element> elements) {
		for(Element elmt : elements){
			if(elmt.getName().equals("DiscoverMethodCallsUmlModel")){
				this.element = (Work)elmt;
				break;
			}
			if(elmt instanceof Workflow){
				findMoDiscoWork(((Workflow)elmt).getElements());
			}
		}
	}
	
	public void launch(){
		try {
			this.resource.save(null);
		} catch (IOException e) {
			e.printStackTrace();
		}
		ControllerDriverPage controller = new ControllerDriverPage();
		DriverExecutionInterface driver = controller.findPlugIn(getType());
		driver.launch(this.element);
	}

	public String getName(){
		return this.element.getName();
	}
	
	public String getType(){
		return this.element.getType();
	}
	
	public int getIndex(){
		return this.element.getIndex();
	}
	
	public Map<String,WorkParameterValue> getParameters(){
		Map<String, WorkParameterValue> valueMap = new HashMap<String, WorkParameterValue>();
		for(WorkParameter parameter :this.element.getParameters()){
			valueMap.put(parameter.getName(), parameter.getValue());
		}
		return valueMap;
	}	

	public Map<String,WorkParameterValue> getInputs(){
		Map<String, WorkParameterValue> valueMap = new HashMap<String, WorkParameterValue>();
		for(WorkParameter parameter :this.element.getParameters()){
			if(parameter.getDirection().equals(Direction.IN)){
				valueMap.put(parameter.getName(), parameter.getValue());
			}
		}
		return valueMap;
	}
}

