/*******************************************************************************
 * Copyright (c) 2008, 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gabriel Barbier - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.popup.actions;

import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter.MethodCallsPrefuseGraphReader;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.uml2.uml.Operation;


/**
 * Acceleo PrefuseInheritanceTreeGenerator code generation.
 * 
 * 
 */
public class FromUmlOperationPrefuseMethodCallsTreeAction extends ActionDelegate implements IActionDelegate {
	
	/**
	 * Selected model files.
	 */
	protected Operation operation;

	/**{@inheritDoc}
	 *
	 * @see org.eclipse.ui.actions.ActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 * @generated
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			Object select = ((IStructuredSelection) selection).getFirstElement();
			if (select instanceof Operation) {
				this.operation = (Operation) select;
			}
		}
	}

	/**{@inheritDoc}
	 *
	 * @see org.eclipse.ui.actions.ActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @generated
	 */
	public void run(IAction action) {
		if (this.operation != null) {
			MethodCallsPrefuseGraphReader reader = new MethodCallsPrefuseGraphReader();
			reader.initializePrefuse(this.operation);
		}
	}

}