/*******************************************************************************
 * Copyright (c) 2008, 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gabriel Barbier - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.popup.actions;

import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter.MethodCallsPrefuseGraphReader;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;


/**
 * Acceleo PrefuseInheritanceTreeGenerator code generation.
 * 
 * 
 */
public class PrefuseMethodCallsTreeAction extends ActionDelegate implements IActionDelegate {
	
	/**
	 * Selected model files.
	 */
	protected List<IFile> files;

	/**{@inheritDoc}
	 *
	 * @see org.eclipse.ui.actions.ActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			this.files = ((IStructuredSelection) selection).toList();
		}
	}

	/**{@inheritDoc}
	 *
	 * @see org.eclipse.ui.actions.ActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @generated
	 */
	public void run(IAction action) {
		if (this.files != null) {
			Iterator<IFile> filesIt = this.files.iterator();
			while (filesIt.hasNext()) {
				IFile model = filesIt.next();
				MethodCallsPrefuseGraphReader reader = new MethodCallsPrefuseGraphReader();
				reader.initializePrefuse(model);
			}
		}
	}

	

}