/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.actions;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.common.core.utils.ModelUtils;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.Activator;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter.MethodCallsGraphConverter;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor.PrefuseGraphInput;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverMethodCallsModelFromJavaModel
extends AbstractDiscovererImpl
implements Discoverer {
    private final String sourceSuffix = "javaxmi";
    private final String methodCallsModelExtension = "methodcalls";

    public boolean isApplicableTo(Object source) {
        IFile ifile;
        boolean result = false;
        if (source instanceof IFile && (ifile = (IFile)source).getFileExtension().equalsIgnoreCase("javaxmi")) {
            result = true;
        }
        return result;
    }

    public String toString() {
        return "Discover MethodCalls model from Java model";
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        Resource resource = null;
        IFile ifile = (IFile)source;
        IProject tempProject = ifile.getProject();
        IJavaProject project = null;
        try {
            if (tempProject.hasNature("org.eclipse.jdt.core.javanature")) {
                project = JavaCore.create((IProject)tempProject);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (project != null) {
            IPath methodCallsPath = ifile.getLocation().removeFileExtension().addFileExtension("methodcalls");
            if (methodCallsPath.toFile().exists()) {
                try {
                    resource = ModelUtils.load((File)methodCallsPath.toFile());
                }
                catch (IOException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            } else {
                Resource javaResource = this.loadJavaModel(ifile);
                URI targetUri = javaResource.getURI().trimFileExtension().appendFileExtension("methodcalls");
                if (parameters.containsKey(this.getTargetUriParameter())) {
                    targetUri = (URI)parameters.get(this.getTargetUriParameter());
                }
                MethodCallsGraphConverter callsConverter = new MethodCallsGraphConverter();
                resource = callsConverter.convertJavaResourceToMethodCallsResource(javaResource, targetUri);
                try {
                    project.getCorrespondingResource().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e1) {
                    MoDiscoLogger.logError((Throwable)e1, (Plugin)Activator.getDefault());
                }
            }
            final PrefuseGraphInput input = new PrefuseGraphInput(resource, project);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.modeleditor.prefuse.EditorID", (boolean)true);
                    }
                    catch (PartInitException e) {
                        MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                }
            });
        } else {
            MoDiscoLogger.logInfo((String)"Could not retrieve java project from selected resource.", (Plugin)Activator.getDefault());
        }
        parameters.put(this.getTargetModelParameter(), resource);
    }

    private Resource loadJavaModel(IFile ifile) {
        Resource result = null;
        try {
            result = ModelUtils.load((File)ifile.getLocation().toFile());
        }
        catch (IOException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return result;
    }
}

