/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.actions;

import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.core.JavaJdtBridge;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.Activator;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter.MethodCallsGraphConverter;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter.MethodCallsJavaBridge;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor.PrefuseGraphInput;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.model.methodcalls.CallNode;
import org.eclipse.gmt.modisco.usecases.modelfilter.converter.MethodCallsJavaConverter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverMethodCallsModelFromJavaOperation
extends AbstractDiscovererImpl
implements Discoverer {
    private final String methodCallsModelExtension = "methodcalls";

    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IMethod) {
            result = true;
        }
        return result;
    }

    public String toString() {
        return "Discover MethodCalls model from Java operation";
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        Resource resource = null;
        IMethod method = (IMethod)source;
        IJavaProject project = method.getJavaProject();
        if (project != null) {
            try {
                MethodCallsJavaConverter discoverer = new MethodCallsJavaConverter(project);
                Resource javaResource = discoverer.convertJavaProjectToJavaModel();
                URI targetUri = javaResource.getURI().trimFileExtension().appendFileExtension("methodcalls");
                if (parameters.containsKey(this.getTargetUriParameter())) {
                    targetUri = (URI)parameters.get(this.getTargetUriParameter());
                }
                MethodCallsGraphConverter callsConverter = new MethodCallsGraphConverter();
                resource = callsConverter.convertJavaResourceToMethodCallsResource(javaResource, targetUri);
                PrefuseGraphInput inputTemp = null;
                MethodCallsJavaBridge callBridge = new MethodCallsJavaBridge();
                JavaJdtBridge bridge = new JavaJdtBridge();
                AbstractMethodDeclaration targetOperation = bridge.getJavaOperation(javaResource, method);
                CallNode callNode = callBridge.getCallNode(resource, targetOperation);
                inputTemp = callNode != null ? new PrefuseGraphInput(callNode, project) : new PrefuseGraphInput(resource, project);
                final PrefuseGraphInput input = inputTemp;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.modeleditor.prefuse.EditorID", (boolean)true);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (JavaModelException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        parameters.put(this.getTargetModelParameter(), resource);
    }
}

