/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.actions;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.Activator;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor.NewPrefuseGraphInput;
import org.eclipse.gmt.modisco.usecases.modelfilter.converter.MethodCallsJavaConverter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverPrefuseGraphOfMethodCallsFromJavaProject
extends AbstractDiscovererImpl
implements Discoverer {
    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IJavaProject) {
            result = true;
        } else if (source instanceof IProject) {
            IProject project = (IProject)source;
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    result = true;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String toString() {
        return "Discover MethodCalls model from Java project";
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        IJavaProject project;
        Resource resource = null;
        IJavaProject tempProject = null;
        if (source instanceof IJavaProject) {
            tempProject = (IJavaProject)source;
        } else if (source instanceof IProject) {
            project = (IProject)source;
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    tempProject = JavaCore.create((IProject)project);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        project = tempProject;
        if (project != null) {
            try {
                MethodCallsJavaConverter discoverer = new MethodCallsJavaConverter(project);
                resource = discoverer.convertJavaProjectToJavaModel();
                NewPrefuseGraphInput inputTemp = null;
                final NewPrefuseGraphInput input = inputTemp = new NewPrefuseGraphInput(resource, project);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.newprefuseeditor.EditorID", (boolean)true);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (JavaModelException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        parameters.put(this.getTargetModelParameter(), resource);
    }
}

