/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterImpl;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter.JavaUmlBridge;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor.ZestGraphInput;
import org.eclipse.gmt.modisco.usecases.modelfilter.converter.MethodCallsJavaConverter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.uml2.uml.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverZestGraphOfMethodCallsFromJavaOperation
implements Discoverer {
    private final DiscoveryParameterImpl targetModel;
    private final DiscoveryParameterImpl targetUri;
    private final List<DiscoveryParameter> discovererParameters = new ArrayList<DiscoveryParameter>();

    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IMethod) {
            result = true;
        }
        return result;
    }

    public Resource discoverElement(Object source, URI target) {
        Resource resource = null;
        IMethod method = (IMethod)source;
        IJavaProject project = method.getJavaProject();
        if (project != null) {
            try {
                MethodCallsJavaConverter discoverer = new MethodCallsJavaConverter(project);
                resource = discoverer.convertJavaProjectToUml2();
                ZestGraphInput inputTemp = null;
                JavaUmlBridge bridge = new JavaUmlBridge();
                Operation targetOperation = bridge.getUmlOperation(resource, method);
                inputTemp = targetOperation != null ? new ZestGraphInput(targetOperation) : new ZestGraphInput(resource);
                final ZestGraphInput input = inputTemp;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.zesteditor.EditorID", (boolean)true);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            catch (ATLCoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No java project ???");
        }
        return resource;
    }

    public String toString() {
        return "Discover MethodCalls model from Java operation";
    }

    public DiscoverZestGraphOfMethodCallsFromJavaOperation() {
        this.targetModel = new DiscoveryParameterImpl("TargetModel", DiscoveryParameterDirectionKind.out, Resource.class, false);
        this.discovererParameters.add((DiscoveryParameter)this.targetModel);
        this.targetUri = new DiscoveryParameterImpl("TargetUri", DiscoveryParameterDirectionKind.in, URI.class, false);
        this.discovererParameters.add((DiscoveryParameter)this.targetUri);
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        Object value;
        URI targetUri = null;
        if (parameters.containsKey(this.targetUri) && (value = parameters.get(this.targetUri)) instanceof URI) {
            targetUri = (URI)value;
        }
        Resource result = this.discoverElement(source, targetUri);
        parameters.put((DiscoveryParameter)this.targetModel, result);
    }

    public List<DiscoveryParameter> getDiscovererParameters() {
        return Collections.unmodifiableList(this.discovererParameters);
    }
}

