/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.common.core.utils.Tools;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.AbstractMethodInvocation;
import org.eclipse.gmt.modisco.java.Assignment;
import org.eclipse.gmt.modisco.java.Block;
import org.eclipse.gmt.modisco.java.BodyDeclaration;
import org.eclipse.gmt.modisco.java.ClassDeclaration;
import org.eclipse.gmt.modisco.java.ClassInstanceCreation;
import org.eclipse.gmt.modisco.java.Expression;
import org.eclipse.gmt.modisco.java.MethodInvocation;
import org.eclipse.gmt.modisco.java.SingleVariableAccess;
import org.eclipse.gmt.modisco.java.TypeAccess;
import org.eclipse.gmt.modisco.java.TypeDeclaration;
import org.eclipse.gmt.modisco.java.VariableDeclaration;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.model.methodcalls.CallNode;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.model.methodcalls.CallsModel;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.model.methodcalls.MethodCall;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.model.methodcalls.MethodcallsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCallsGraphConverter {
    private final MethodcallsFactory factory = MethodcallsFactory.eINSTANCE;
    private final Map<AbstractMethodDeclaration, CallNode> javaOperationToCallNode = new HashMap<AbstractMethodDeclaration, CallNode>();
    private final List<AbstractMethodInvocation> allInvocations = new ArrayList<AbstractMethodInvocation>();
    private final List<TypeDeclaration> allTypes = new ArrayList<TypeDeclaration>();

    public Resource convertJavaResourceToMethodCallsResource(Resource javaResource, URI targetUri) {
        CallNode callNode;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource result = resourceSet.createResource(targetUri);
        CallsModel callsModel = this.factory.createCallsModel();
        callsModel.setName(targetUri.trimFileExtension().lastSegment());
        result.getContents().add((Object)callsModel);
        List<AbstractMethodDeclaration> allOperations = this.getAllOperations(javaResource);
        for (AbstractMethodDeclaration javaOperation : allOperations) {
            callNode = this.factory.createCallNode();
            callNode.setJavaMethod(javaOperation);
            callsModel.getCallNodes().add((Object)callNode);
            if (javaOperation.getUsages().isEmpty()) {
                callsModel.getRootNodes().add((Object)callNode);
            }
            this.javaOperationToCallNode.put(javaOperation, callNode);
        }
        for (AbstractMethodDeclaration javaOperation : allOperations) {
            callNode = this.javaOperationToCallNode.get(javaOperation);
            List<AbstractMethodInvocation> calledMethods = this.getCalledMethods(javaOperation);
            String parentName = "";
            if (javaOperation.getAbstractTypeDeclaration() != null) {
                parentName = javaOperation.getAbstractTypeDeclaration().getName();
            }
            String name = String.valueOf(parentName) + " :: " + javaOperation.getName();
            if (!calledMethods.isEmpty()) {
                name = String.valueOf(name) + " (" + calledMethods.size() + ")";
            }
            callNode.setName(name);
            int index = 0;
            while (index < calledMethods.size()) {
                MethodCall methodCall = this.factory.createMethodCall();
                methodCall.setOrder(index);
                CallNode callee = this.javaOperationToCallNode.get(calledMethods.get(index).getMethod());
                methodCall.setCallee(callee);
                VariableDeclaration variableDeclaration = this.getVariableDeclaration(calledMethods.get(index));
                if (variableDeclaration != null) {
                    for (TypeDeclaration subtype : this.getFilteredPotentialTypes(variableDeclaration)) {
                        for (BodyDeclaration body : subtype.getBodyDeclarations()) {
                            if (!(body instanceof AbstractMethodDeclaration)) continue;
                            AbstractMethodDeclaration subMethod = (AbstractMethodDeclaration)body;
                            if (!javaOperation.getName().equals(body.getName()) || javaOperation.getParameters().size() != subMethod.getParameters().size()) continue;
                            CallNode subNode = this.javaOperationToCallNode.get(subMethod);
                            methodCall.getFilteredSubMethods().add((Object)subNode);
                        }
                    }
                }
                callNode.getMethodCalls().add((Object)methodCall);
                ++index;
            }
            TypeDeclaration parentType = this.getTypeDeclaration((EObject)javaOperation);
            for (TypeDeclaration subtype : this.getAllSubTypes(parentType)) {
                for (BodyDeclaration body : subtype.getBodyDeclarations()) {
                    if (!(body instanceof AbstractMethodDeclaration)) continue;
                    AbstractMethodDeclaration subMethod = (AbstractMethodDeclaration)body;
                    if (!javaOperation.getName().equals(body.getName()) || javaOperation.getParameters().size() != subMethod.getParameters().size()) continue;
                    CallNode subNode = this.javaOperationToCallNode.get(subMethod);
                    callNode.getSubMethods().add((Object)subNode);
                }
            }
        }
        Tools.saveModel((Resource)result, (URI)targetUri);
        return result;
    }

    private final List<AbstractMethodDeclaration> getAllOperations(Resource javaResource) {
        ArrayList<AbstractMethodDeclaration> result = new ArrayList<AbstractMethodDeclaration>();
        TreeIterator iterator = javaResource.getAllContents();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            if (object instanceof AbstractMethodDeclaration) {
                AbstractMethodDeclaration operation = (AbstractMethodDeclaration)object;
                result.add(operation);
                continue;
            }
            if (object instanceof AbstractMethodInvocation) {
                AbstractMethodInvocation invocation = (AbstractMethodInvocation)object;
                this.allInvocations.add(invocation);
                continue;
            }
            if (!(object instanceof TypeDeclaration)) continue;
            TypeDeclaration currentClassDeclaration = (TypeDeclaration)object;
            this.allTypes.add(currentClassDeclaration);
        }
        return result;
    }

    private final List<AbstractMethodInvocation> getCalledMethods(AbstractMethodDeclaration parent) {
        List<AbstractMethodInvocation> invocations = this.getInvocations(parent);
        Collections.sort(invocations, new MethodInvocationComparator());
        return invocations;
    }

    private final List<AbstractMethodInvocation> getInvocations(AbstractMethodDeclaration parent) {
        ArrayList<AbstractMethodInvocation> invocations = new ArrayList<AbstractMethodInvocation>();
        for (AbstractMethodInvocation invocation : this.allInvocations) {
            if (parent != this.getInvoker((EObject)invocation)) continue;
            invocations.add(invocation);
        }
        return invocations;
    }

    private final AbstractMethodDeclaration getInvoker(EObject element) {
        AbstractMethodDeclaration result = null;
        if (element != null) {
            result = element instanceof AbstractMethodDeclaration ? (AbstractMethodDeclaration)element : this.getInvoker(element.eContainer());
        }
        return result;
    }

    private final TypeDeclaration getTypeDeclaration(EObject element) {
        TypeDeclaration result = null;
        if (element != null) {
            result = element instanceof TypeDeclaration ? (TypeDeclaration)element : this.getTypeDeclaration(element.eContainer());
        }
        return result;
    }

    private final Set<TypeDeclaration> getAllSubTypes(TypeDeclaration contextClass) {
        HashSet<TypeDeclaration> result = new HashSet<TypeDeclaration>();
        if (contextClass != null) {
            for (TypeDeclaration currentClassDeclaration : this.allTypes) {
                if (!this.isSuperTypeOf(contextClass, currentClassDeclaration)) continue;
                result.add(currentClassDeclaration);
                result.addAll(this.getAllSubTypes(currentClassDeclaration));
            }
        }
        return result;
    }

    private final boolean isSuperTypeOf(TypeDeclaration self, TypeDeclaration typeDeclaration) {
        if (typeDeclaration.getSuperInterfaces().contains((Object)self)) {
            return true;
        }
        for (TypeAccess superTypeAccess : typeDeclaration.getSuperInterfaces()) {
            TypeDeclaration superType;
            if (!(superTypeAccess.getType() instanceof TypeDeclaration) || (superType = (TypeDeclaration)superTypeAccess.getType()) != self && !this.isSuperTypeOf(self, superType)) continue;
            return true;
        }
        if (typeDeclaration instanceof ClassDeclaration) {
            TypeDeclaration superType;
            ClassDeclaration classDeclaration = (ClassDeclaration)typeDeclaration;
            if (classDeclaration.getSuperClass() != null && classDeclaration.getSuperClass().getType() == self) {
                return true;
            }
            if (classDeclaration.getSuperClass() != null && classDeclaration.getSuperClass().getType() instanceof TypeDeclaration && this.isSuperTypeOf(self, superType = (TypeDeclaration)classDeclaration.getSuperClass().getType())) {
                return true;
            }
        }
        return false;
    }

    private final VariableDeclaration getVariableDeclaration(AbstractMethodInvocation abstractMethodInvocation) {
        MethodInvocation methodInvocation;
        VariableDeclaration result = null;
        if (abstractMethodInvocation instanceof MethodInvocation && (methodInvocation = (MethodInvocation)abstractMethodInvocation).getExpression() != null && methodInvocation.getExpression() instanceof SingleVariableAccess) {
            SingleVariableAccess singleVariableAccess = (SingleVariableAccess)methodInvocation.getExpression();
            result = singleVariableAccess.getVariable();
        }
        return result;
    }

    private final Set<TypeDeclaration> getFilteredPotentialTypes(VariableDeclaration variableDeclaration) {
        ArrayList<VariableDeclaration> parents = new ArrayList<VariableDeclaration>();
        Set<TypeDeclaration> result = this.getBasicFilteredPotentialTypes(variableDeclaration, parents);
        return result;
    }

    private final Set<TypeDeclaration> getBasicFilteredPotentialTypes(VariableDeclaration source, List<VariableDeclaration> parents) {
        HashSet<TypeDeclaration> result = new HashSet<TypeDeclaration>();
        if (!parents.contains(source)) {
            ClassInstanceCreation classInstanceCreation;
            parents.add(source);
            Expression initializer = source.getInitializer();
            if (initializer != null && initializer instanceof ClassInstanceCreation && (classInstanceCreation = (ClassInstanceCreation)initializer).getType().getType() instanceof TypeDeclaration) {
                result.add((TypeDeclaration)classInstanceCreation.getType().getType());
            }
            result.addAll(this.filterAssignement(source, parents));
        }
        return result;
    }

    private final Set<TypeDeclaration> filterAssignement(VariableDeclaration source, List<VariableDeclaration> parents) {
        HashSet<TypeDeclaration> result = new HashSet<TypeDeclaration>();
        for (SingleVariableAccess access : source.getUsageInVariableAccess()) {
            EObject container = access.eContainer();
            if (!(container instanceof Assignment)) continue;
            Assignment assignment = (Assignment)container;
            Expression expression = assignment.getRightHandSide();
            if (expression instanceof ClassInstanceCreation) {
                ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
                if (!(classInstanceCreation.getType().getType() instanceof TypeDeclaration)) continue;
                result.add((TypeDeclaration)classInstanceCreation.getType().getType());
                continue;
            }
            if (!(expression instanceof SingleVariableAccess)) continue;
            SingleVariableAccess singleVariableAccess = (SingleVariableAccess)expression;
            result.addAll(this.getBasicFilteredPotentialTypes(singleVariableAccess.getVariable(), parents));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodInvocationComparator
    implements Comparator<AbstractMethodInvocation> {
        private MethodInvocationComparator() {
        }

        @Override
        public int compare(AbstractMethodInvocation invocation1, AbstractMethodInvocation invocation2) {
            int result = -1;
            Block rootBlock1 = this.getRootBlock((EObject)invocation1);
            Block rootBlock2 = this.getRootBlock((EObject)invocation2);
            if (rootBlock1 == null || rootBlock2 == null) {
                result = 0;
            } else {
                int index2;
                int index1 = this.computeIndex((EObject)invocation1, rootBlock1);
                if (index1 == (index2 = this.computeIndex((EObject)invocation2, rootBlock2)) && rootBlock1 == rootBlock2) {
                    Block commonBlock = this.getFirstCommonParentBlock((EObject)invocation1, (EObject)invocation2, rootBlock1);
                    index1 = this.computeIndex((EObject)invocation1, commonBlock);
                    index2 = this.computeIndex((EObject)invocation2, commonBlock);
                }
                result = Integer.valueOf(index1).compareTo(index2);
            }
            return result;
        }

        private final int computeIndex(EObject element, Block rootBlock) {
            int result = -2;
            result = element.eContainer() == rootBlock ? rootBlock.getStatements().indexOf((Object)element) : this.computeIndex(element.eContainer(), rootBlock);
            return result;
        }

        private final Block getRootBlock(EObject element) {
            Block result = null;
            if (element != null) {
                result = element instanceof AbstractMethodDeclaration ? ((AbstractMethodDeclaration)element).getBody() : this.getRootBlock(element.eContainer());
            }
            return result;
        }

        private final Block getFirstCommonParentBlock(EObject sourceElement, EObject element2, Block stopper) {
            Block result = this.getParentBlock(sourceElement);
            if (result != stopper && !this.isParentBlock(element2, result, stopper)) {
                result = this.getFirstCommonParentBlock((EObject)result, element2, stopper);
            }
            return result;
        }

        private final boolean isParentBlock(EObject element, Block target, Block stopper) {
            boolean result = false;
            Block parent = this.getParentBlock(element);
            if (parent != stopper) {
                result = parent == target ? true : this.isParentBlock((EObject)parent, target, stopper);
            }
            return result;
        }

        private final Block getParentBlock(EObject element) {
            Block result = null;
            if (element != null) {
                result = element.eContainer() instanceof Block ? (Block)element.eContainer() : this.getParentBlock(element.eContainer());
            }
            return result;
        }
    }
}

