/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.modisco.prefuse.examples.treeview.Princ;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;
import prefuse.data.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCallsPrefuseGraphReader {
    private final String attribute = "name";
    private final List<Operation> parents = new ArrayList<Operation>();

    public final void initializePrefuse(Operation operation) {
        Tree graph = this.initializeMethodCallsGraph(operation);
        String label = "name";
        JPanel treeview = Princ.demo((Graph)graph, (String)label);
        JFrame frame = new JFrame(String.valueOf(operation.getName()) + "  |  p r e f u s e  |  m e t h o d s  c a l l s  v i e w");
        frame.setDefaultCloseOperation(2);
        frame.setContentPane(treeview);
        frame.pack();
        frame.setVisible(true);
    }

    public final void initializePrefuse(IFile model) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)model.getFullPath().toString(), (boolean)false), true);
        Tree graph = this.initializeMethodCallsGraph(resource);
        resource.unload();
        String packageName = model.getProjectRelativePath().removeFileExtension().lastSegment().toLowerCase();
        String label = "name";
        JPanel treeview = Princ.demo((Graph)graph, (String)label);
        JFrame frame = new JFrame(String.valueOf(packageName) + "  |  p r e f u s e  |  m e t h o d s  c a l l s  v i e w");
        frame.setDefaultCloseOperation(2);
        frame.setContentPane(treeview);
        frame.pack();
        frame.setVisible(true);
    }

    public final void initializePrefuse(Resource resource) {
        Tree graph = this.initializeMethodCallsGraph(resource);
        String packageName = "";
        if (resource.getURI() != null) {
            packageName = resource.getURI().trimFileExtension().lastSegment().toLowerCase();
        }
        String label = "name";
        JPanel treeview = Princ.demo((Graph)graph, (String)label);
        JFrame frame = new JFrame(String.valueOf(packageName) + "  |  p r e f u s e  |  m e t h o d s  c a l l s  v i e w");
        frame.setDefaultCloseOperation(2);
        frame.setContentPane(treeview);
        frame.pack();
        frame.setVisible(true);
    }

    private final Tree initializeMethodCallsGraph(Resource resource) {
        Tree result = new Tree();
        Table nodes = result.getNodeTable();
        Node activeNode = null;
        nodes.addColumn("name", String.class);
        activeNode = result.addRoot();
        activeNode.set("name", (Object)"Method Calls Graph");
        List<Operation> allOperations = this.getAllOperations(resource);
        Node parentNode = activeNode;
        for (Operation rootElement : this.getRootOperationsForMethodCallsGraph(allOperations)) {
            this.generateMethodCallsNode(result, parentNode, rootElement);
        }
        return result;
    }

    private final Tree initializeMethodCallsGraph(Operation rootElement) {
        Tree result = new Tree();
        Table nodes = result.getNodeTable();
        Node activeNode = null;
        nodes.addColumn("name", String.class);
        activeNode = result.addRoot();
        activeNode.set("name", (Object)"Method Calls Graph");
        Node parentNode = activeNode;
        this.generateMethodCallsNode(result, parentNode, rootElement);
        return result;
    }

    private final void generateMethodCallsNode(Tree result, Node parentNode, Operation element) {
        Node activeNode = result.addChild(parentNode);
        String name = String.valueOf(element.getNamespace().getName()) + " :: " + element.getName();
        if (this.parents.contains(element)) {
            activeNode.set("name", (Object)("/recursion/ " + name));
        } else {
            this.parents.add(element);
            List<Operation> calledMethods = this.getCalledMethods(element);
            if (calledMethods.isEmpty()) {
                activeNode.set("name", (Object)name);
            } else {
                activeNode.set("name", (Object)(String.valueOf(name) + " (" + calledMethods.size() + ")"));
            }
            for (Operation child : calledMethods) {
                this.generateMethodCallsNode(result, activeNode, child);
            }
            this.parents.remove(element);
        }
    }

    private final List<Operation> getAllOperations(Resource resource) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            Operation operation;
            EObject object = (EObject)iterator.next();
            if (!(object instanceof Operation) || (operation = (Operation)object).getName().equalsIgnoreCase("dummy")) continue;
            result.add(operation);
        }
        return result;
    }

    private final List<Operation> getRootOperationsForMethodCallsGraph(List<Operation> elements) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        ArrayList methodCalls = new ArrayList();
        for (Operation element : elements) {
            methodCalls.addAll(element.getClientDependencies());
        }
        for (Operation element : elements) {
            boolean root = true;
            for (Dependency methodCall : methodCalls) {
                if (!methodCall.getSuppliers().contains((Object)element)) continue;
                root = false;
            }
            if (!root) continue;
            result.add(element);
        }
        return result;
    }

    private final List<Operation> getCalledMethods(Operation parent) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        EList methodCalls = parent.getClientDependencies();
        Collections.sort(methodCalls, new Comparator<Dependency>(){

            private final Integer extractCallRank(Dependency dependency) {
                Integer result = 0;
                String name = dependency.getName();
                if (name != null) {
                    String[] parts = name.split(" ");
                    String number = parts[parts.length - 1];
                    result = Integer.valueOf(number);
                }
                return result;
            }

            @Override
            public int compare(Dependency o1, Dependency o2) {
                return this.extractCallRank(o1).compareTo(this.extractCallRank(o2));
            }
        });
        for (Dependency methodCall : methodCalls) {
            for (NamedElement callee : methodCall.getSuppliers()) {
                if (!(callee instanceof Operation)) continue;
                result.add((Operation)callee);
            }
        }
        return result;
    }
}

