/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCallsZestGraphReader {
    private final List<Operation> parents = new ArrayList<Operation>();

    /*
     * Unable to fully structure code
     */
    public final void initializeZest(Operation operation) {
        d = new Display();
        shell = new Shell(d);
        shell.setText(String.valueOf(operation.getName()) + "  |  z e s t  |  m e t h o d s  c a l l s  v i e w");
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(400, 400);
        this.initializeMethodCallsGraph(operation, shell);
        shell.open();
        ** GOTO lbl14
        {
            d.sleep();
            do {
                if (!d.readAndDispatch()) continue block0;
lbl14:
                // 2 sources

            } while (!shell.isDisposed());
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void initializeZest(IFile model) {
        packageName = model.getProjectRelativePath().removeFileExtension().lastSegment().toLowerCase();
        d = new Display();
        shell = new Shell(d);
        shell.setText(String.valueOf(packageName) + "  |  z e s t  |  m e t h o d s  c a l l s  v i e w");
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(400, 400);
        resourceSet = new ResourceSetImpl();
        resource = resourceSet.getResource(URI.createPlatformResourceURI((String)model.getFullPath().toString(), (boolean)false), true);
        this.initializeMethodCallsGraph(resource, shell);
        resource.unload();
        shell.open();
        ** GOTO lbl18
        {
            d.sleep();
            do {
                if (!d.readAndDispatch()) continue block0;
lbl18:
                // 2 sources

            } while (!shell.isDisposed());
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void initializeZest(Resource resource) {
        packageName = "";
        if (resource.getURI() != null) {
            packageName = resource.getURI().trimFileExtension().lastSegment().toLowerCase();
        }
        d = new Display();
        shell = new Shell(d);
        shell.setText(String.valueOf(packageName) + "  |  z e s t  |  m e t h o d s  c a l l s  v i e w");
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(400, 400);
        this.initializeMethodCallsGraph(resource, shell);
        resource.unload();
        shell.open();
        ** GOTO lbl18
        {
            d.sleep();
            do {
                if (!d.readAndDispatch()) continue block0;
lbl18:
                // 2 sources

            } while (!shell.isDisposed());
        }
    }

    private final Graph initializeMethodCallsGraph(Resource resource, Shell shell) {
        Graph result = new Graph((Composite)shell, 0);
        GraphNode parentNode = new GraphNode((IContainer)result, 0, "Method Calls Graph");
        result.setLayoutAlgorithm((LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1), true);
        List<Operation> allOperations = this.getAllOperations(resource);
        for (Operation rootElement : this.getRootOperationsForMethodCallsGraph(allOperations)) {
            this.generateMethodCallsNode(result, parentNode, rootElement);
        }
        return result;
    }

    private final Graph initializeMethodCallsGraph(Operation rootElement, Shell shell) {
        Graph result = new Graph((Composite)shell, 0);
        GraphNode parentNode = new GraphNode((IContainer)result, 0, "Method Calls Graph");
        result.setLayoutAlgorithm((LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1), true);
        this.generateMethodCallsNode(result, parentNode, rootElement);
        return result;
    }

    private final void generateMethodCallsNode(Graph result, GraphNode parentNode, Operation element) {
        GraphNode activeNode = null;
        String name = String.valueOf(element.getNamespace().getName()) + " :: " + element.getName();
        if (this.parents.contains(element)) {
            activeNode = new GraphNode((IContainer)result, 0, "/recursion/ " + name);
            new GraphConnection(result, 0, parentNode, activeNode);
        } else {
            this.parents.add(element);
            List<Operation> calledMethods = this.getCalledMethods(element);
            activeNode = calledMethods.isEmpty() ? new GraphNode((IContainer)result, 0, name) : new GraphNode((IContainer)result, 0, String.valueOf(name) + " (" + calledMethods.size() + ")");
            new GraphConnection(result, 0, parentNode, activeNode);
            for (Operation child : calledMethods) {
                this.generateMethodCallsNode(result, activeNode, child);
            }
            this.parents.remove(element);
        }
    }

    private final List<Operation> getAllOperations(Resource resource) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            Operation operation;
            EObject object = (EObject)iterator.next();
            if (!(object instanceof Operation) || (operation = (Operation)object).getName().equalsIgnoreCase("dummy")) continue;
            result.add(operation);
        }
        return result;
    }

    private final List<Operation> getRootOperationsForMethodCallsGraph(List<Operation> elements) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        ArrayList methodCalls = new ArrayList();
        for (Operation element : elements) {
            methodCalls.addAll(element.getClientDependencies());
        }
        for (Operation element : elements) {
            boolean root = true;
            for (Dependency methodCall : methodCalls) {
                if (!methodCall.getSuppliers().contains((Object)element)) continue;
                root = false;
            }
            if (!root) continue;
            result.add(element);
        }
        return result;
    }

    private final List<Operation> getCalledMethods(Operation parent) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        EList methodCalls = parent.getClientDependencies();
        Collections.sort(methodCalls, new Comparator<Dependency>(){

            private final Integer extractCallRank(Dependency dependency) {
                Integer result = 0;
                String name = dependency.getName();
                if (name != null) {
                    String[] parts = name.split(" ");
                    String number = parts[parts.length - 1];
                    result = Integer.valueOf(number);
                }
                return result;
            }

            @Override
            public int compare(Dependency o1, Dependency o2) {
                return this.extractCallRank(o1).compareTo(this.extractCallRank(o2));
            }
        });
        for (Dependency methodCall : methodCalls) {
            for (NamedElement callee : methodCall.getSuppliers()) {
                if (!(callee instanceof Operation)) continue;
                result.add((Operation)callee);
            }
        }
        return result;
    }
}

