/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter.PrefuseGraphContainerForUml;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor.PrefuseGraphInput;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;
import prefuse.data.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCallsPrefuseGraphEditor
extends EditorPart {
    public static final String EditorID = "org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.prefuseeditor.EditorID";
    private PrefuseGraphInput editorInput;
    private final String nameAttribute = "name";
    private final List<Operation> parents = new ArrayList<Operation>();

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof PrefuseGraphInput)) {
            throw new PartInitException("Input should be of type PrefuseGraphInput");
        }
        this.editorInput = (PrefuseGraphInput)input;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(this.editorInput);
        this.setPartName("Prefuse Graph Viewer Part Name");
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        if (this.editorInput != null) {
            String packageName;
            Composite composite = new Composite(parent, 0x1040000);
            Frame frame = SWT_AWT.new_Frame((Composite)composite);
            Tree graph = null;
            if (this.editorInput.getInputFile() != null) {
                IFile model = this.editorInput.getInputFile();
                packageName = model.getProjectRelativePath().removeFileExtension().lastSegment().toLowerCase();
                this.setPartName(packageName);
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)model.getFullPath().toString(), (boolean)false), true);
                graph = this.initializeMethodCallsGraph(resource);
                resource.unload();
            } else if (this.editorInput.getInputResource() != null) {
                Resource resource = this.editorInput.getInputResource();
                packageName = "";
                if (resource.getURI() != null) {
                    packageName = resource.getURI().trimFileExtension().lastSegment().toLowerCase();
                }
                this.setPartName(packageName);
                graph = this.initializeMethodCallsGraph(resource);
            } else if (this.editorInput.getInputOperation() != null) {
                Operation operation = this.editorInput.getInputOperation();
                String name = operation.getName();
                this.setPartName(name);
                graph = this.initializeMethodCallsGraph(operation);
            }
            JPanel treeview = PrefuseGraphContainerForUml.getInstance().initializeTreeViewContainer((Graph)graph, "name", null);
            Panel panel = new Panel(new BorderLayout()){

                public void update(Graphics g) {
                    this.paint(g);
                }
            };
            frame.add(panel);
            panel.add(treeview);
            panel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    System.out.println(e.getButton());
                    System.out.println(e.getClickCount());
                    System.out.println(e.getSource());
                    System.out.println(e.getComponent());
                }
            });
        }
    }

    public void setFocus() {
    }

    private final Tree initializeMethodCallsGraph(Resource resource) {
        Tree result = new Tree();
        Table nodes = result.getNodeTable();
        Node activeNode = null;
        nodes.addColumn("name", String.class);
        activeNode = result.addRoot();
        activeNode.set("name", (Object)"Method Calls Graph");
        nodes.addColumn("umlOperation", Operation.class);
        nodes.addColumn("javaProject", IJavaProject.class);
        List<Operation> allOperations = this.getAllOperations(resource);
        Node parentNode = activeNode;
        for (Operation rootElement : this.getRootOperationsForMethodCallsGraph(allOperations)) {
            this.generateMethodCallsNode(result, parentNode, rootElement);
        }
        return result;
    }

    private final Tree initializeMethodCallsGraph(Operation rootElement) {
        Tree result = new Tree();
        Table nodes = result.getNodeTable();
        Node activeNode = null;
        nodes.addColumn("name", String.class);
        nodes.addColumn("umlOperation", Operation.class);
        nodes.addColumn("javaProject", IJavaProject.class);
        activeNode = result.addRoot();
        activeNode.set("name", (Object)"Method Calls Graph");
        Node parentNode = activeNode;
        this.generateMethodCallsNode(result, parentNode, rootElement);
        return result;
    }

    private final void generateMethodCallsNode(Tree result, Node parentNode, Operation element) {
        Node activeNode = result.addChild(parentNode);
        activeNode.set("umlOperation", (Object)element);
        activeNode.set("javaProject", (Object)this.editorInput.getJavaProject());
        String name = String.valueOf(element.getNamespace().getName()) + " :: " + element.getName();
        if (this.parents.contains(element)) {
            activeNode.set("name", (Object)("/recursion/ " + name));
        } else {
            this.parents.add(element);
            List<Operation> calledMethods = this.getCalledMethods(element);
            if (calledMethods.isEmpty()) {
                activeNode.set("name", (Object)name);
            } else {
                activeNode.set("name", (Object)(String.valueOf(name) + " (" + calledMethods.size() + ")"));
            }
            for (Operation child : calledMethods) {
                this.generateMethodCallsNode(result, activeNode, child);
            }
            this.parents.remove(element);
        }
    }

    private final List<Operation> getAllOperations(Resource resource) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            Operation operation;
            EObject object = (EObject)iterator.next();
            if (!(object instanceof Operation) || (operation = (Operation)object).getName().equalsIgnoreCase("dummy")) continue;
            result.add(operation);
        }
        return result;
    }

    private final List<Operation> getRootOperationsForMethodCallsGraph(List<Operation> elements) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        ArrayList methodCalls = new ArrayList();
        for (Operation element : elements) {
            methodCalls.addAll(element.getClientDependencies());
        }
        for (Operation element : elements) {
            boolean root = true;
            for (Dependency methodCall : methodCalls) {
                if (!methodCall.getSuppliers().contains((Object)element)) continue;
                root = false;
            }
            if (!root) continue;
            result.add(element);
        }
        return result;
    }

    private final List<Operation> getCalledMethods(Operation parent) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        EList methodCalls = parent.getClientDependencies();
        Collections.sort(methodCalls, new Comparator<Dependency>(){

            private final Integer extractCallRank(Dependency dependency) {
                Integer result = 0;
                String name = dependency.getName();
                if (name != null) {
                    String[] parts = name.split(" ");
                    String number = parts[parts.length - 1];
                    result = Integer.valueOf(number);
                }
                return result;
            }

            @Override
            public int compare(Dependency o1, Dependency o2) {
                return this.extractCallRank(o1).compareTo(this.extractCallRank(o2));
            }
        });
        for (Dependency methodCall : methodCalls) {
            for (NamedElement callee : methodCall.getSuppliers()) {
                if (!(callee instanceof Operation)) continue;
                result.add((Operation)callee);
            }
        }
        return result;
    }
}

