/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor.ZestGraphInput;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCallsZestGraphEditor
extends EditorPart {
    public static final String EditorID = "org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.zesteditor.EditorID";
    private ZestGraphInput editorInput;
    private final List<Operation> parents = new ArrayList<Operation>();

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ZestGraphInput)) {
            throw new PartInitException("Input should be of type ZestGraphInput");
        }
        this.editorInput = (ZestGraphInput)input;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(this.editorInput);
        this.setPartName("Zest Graph Viewer Part Name");
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        if (this.editorInput != null) {
            if (this.editorInput.getInputFile() != null) {
                IFile model = this.editorInput.getInputFile();
                String packageName = model.getProjectRelativePath().removeFileExtension().lastSegment().toLowerCase();
                this.setPartName(packageName);
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)model.getFullPath().toString(), (boolean)false), true);
                this.initializeMethodCallsGraph(resource, parent);
                resource.unload();
            } else if (this.editorInput.getInputResource() != null) {
                Resource resource = this.editorInput.getInputResource();
                String packageName = "";
                if (resource.getURI() != null) {
                    packageName = resource.getURI().trimFileExtension().lastSegment().toLowerCase();
                }
                this.setPartName(packageName);
                this.initializeMethodCallsGraph(resource, parent);
            } else if (this.editorInput.getInputOperation() != null) {
                Operation operation = this.editorInput.getInputOperation();
                String name = operation.getName();
                this.setPartName(name);
                this.initializeMethodCallsGraph(operation, parent);
            }
        }
    }

    public void setFocus() {
    }

    private final Graph initializeMethodCallsGraph(Resource resource, Composite shell) {
        Graph result = new Graph(shell, 0);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodCallsZestGraphEditor.this.zestWidgetSelected(e);
            }
        });
        GraphNode parentNode = new GraphNode((IContainer)result, 0, "Method Calls Graph");
        result.setLayoutAlgorithm((LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1), true);
        List<Operation> allOperations = this.getAllOperations(resource);
        for (Operation rootElement : this.getRootOperationsForMethodCallsGraph(allOperations)) {
            this.generateMethodCallsNode(result, parentNode, rootElement);
        }
        return result;
    }

    private final Graph initializeMethodCallsGraph(Operation rootElement, Composite shell) {
        Graph result = new Graph(shell, 0);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodCallsZestGraphEditor.this.zestWidgetSelected(e);
            }
        });
        GraphNode parentNode = new GraphNode((IContainer)result, 0, "Method Calls Graph");
        result.setLayoutAlgorithm((LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1), true);
        this.generateMethodCallsNode(result, parentNode, rootElement);
        return result;
    }

    private final void zestWidgetSelected(SelectionEvent e) {
        System.out.println(((Graph)e.widget).getSelection());
        Graph current = (Graph)e.widget;
        List graphNodes = current.getSelection();
        for (GraphNode node : graphNodes) {
            System.out.println(node.getText());
            System.out.println(((Label)node.getTooltip()).getText());
        }
    }

    private final void generateMethodCallsNode(Graph result, GraphNode parentNode, Operation element) {
        GraphNode activeNode = null;
        String name = String.valueOf(element.getNamespace().getName()) + " :: " + element.getName();
        if (this.parents.contains(element)) {
            activeNode = new GraphNode((IContainer)result, 0, "/recursion/ " + name);
            Label tooltip = new Label(this.getQualifiedName(element));
            activeNode.setTooltip((IFigure)tooltip);
            new GraphConnection(result, 0, parentNode, activeNode);
        } else {
            this.parents.add(element);
            List<Operation> calledMethods = this.getCalledMethods(element);
            activeNode = calledMethods.isEmpty() ? new GraphNode((IContainer)result, 0, name) : new GraphNode((IContainer)result, 0, String.valueOf(name) + " (" + calledMethods.size() + ")");
            Label tooltip = new Label(this.getQualifiedName(element));
            activeNode.setTooltip((IFigure)tooltip);
            new GraphConnection(result, 0, parentNode, activeNode);
            for (Operation child : calledMethods) {
                this.generateMethodCallsNode(result, activeNode, child);
            }
            this.parents.remove(element);
        }
    }

    private final String getQualifiedName(Operation operation) {
        StringBuilder result = new StringBuilder();
        int index = operation.allNamespaces().size() - 1;
        while (index >= 0) {
            NamedElement element = (NamedElement)operation.allNamespaces().get(index);
            if (!(element instanceof Model)) {
                result.append(element.getName());
                result.append(".");
            }
            --index;
        }
        result.append(operation.getName());
        return result.toString();
    }

    private final List<Operation> getAllOperations(Resource resource) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            Operation operation;
            EObject object = (EObject)iterator.next();
            if (!(object instanceof Operation) || (operation = (Operation)object).getName().equalsIgnoreCase("dummy")) continue;
            result.add(operation);
        }
        return result;
    }

    private final List<Operation> getRootOperationsForMethodCallsGraph(List<Operation> elements) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        ArrayList methodCalls = new ArrayList();
        for (Operation element : elements) {
            methodCalls.addAll(element.getClientDependencies());
        }
        for (Operation element : elements) {
            boolean root = true;
            for (Dependency methodCall : methodCalls) {
                if (!methodCall.getSuppliers().contains((Object)element)) continue;
                root = false;
            }
            if (!root) continue;
            result.add(element);
        }
        return result;
    }

    private final List<Operation> getCalledMethods(Operation parent) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        EList methodCalls = parent.getClientDependencies();
        Collections.sort(methodCalls, new Comparator<Dependency>(){

            private final Integer extractCallRank(Dependency dependency) {
                Integer result = 0;
                String name = dependency.getName();
                if (name != null) {
                    String[] parts = name.split(" ");
                    String number = parts[parts.length - 1];
                    result = Integer.valueOf(number);
                }
                return result;
            }

            @Override
            public int compare(Dependency o1, Dependency o2) {
                return this.extractCallRank(o1).compareTo(this.extractCallRank(o2));
            }
        });
        for (Dependency methodCall : methodCalls) {
            for (NamedElement callee : methodCall.getSuppliers()) {
                if (!(callee instanceof Operation)) continue;
                result.add((Operation)callee);
            }
        }
        return result;
    }
}

