/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.AbstractMethodInvocation;
import org.eclipse.gmt.modisco.java.Block;
import org.eclipse.gmt.modisco.java.BodyDeclaration;
import org.eclipse.gmt.modisco.java.ClassDeclaration;
import org.eclipse.gmt.modisco.java.TypeAccess;
import org.eclipse.gmt.modisco.java.TypeDeclaration;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.converter.PrefuseGraphContainerForJava;
import org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.editor.NewPrefuseGraphInput;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;
import prefuse.data.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewMethodCallsPrefuseGraphEditor
extends EditorPart {
    public static final String EditorID = "org.eclipse.gmt.modisco.usecase.modelfilter.methodcalls.newprefuseeditor.EditorID";
    private NewPrefuseGraphInput editorInput;
    private final String nameAttribute = "name";
    private final List<AbstractMethodDeclaration> parents = new ArrayList<AbstractMethodDeclaration>();
    private List<AbstractMethodInvocation> allInvocations;
    private final Map<AbstractMethodDeclaration, List<AbstractMethodDeclaration>> mapInvocations = new HashMap<AbstractMethodDeclaration, List<AbstractMethodDeclaration>>();

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof NewPrefuseGraphInput)) {
            throw new PartInitException("Input should be of type PrefuseGraphInput");
        }
        this.editorInput = (NewPrefuseGraphInput)input;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(this.editorInput);
        this.setPartName("Prefuse Graph Viewer Part Name");
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        if (this.editorInput != null) {
            Composite composite = new Composite(parent, 0x1040000);
            Frame frame = SWT_AWT.new_Frame((Composite)composite);
            Tree graph = null;
            if (this.editorInput.getJavaxmiFile() != null) {
                IFile model = this.editorInput.getJavaxmiFile();
                String packageName = model.getProjectRelativePath().removeFileExtension().lastSegment().toLowerCase();
                this.setPartName(packageName);
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)model.getFullPath().toString(), (boolean)false), true);
                graph = this.initializeMethodCallsGraph(resource);
                resource.unload();
            } else if (this.editorInput.getJavaxmiResource() != null) {
                Resource resource = this.editorInput.getJavaxmiResource();
                String packageName = "";
                if (resource.getURI() != null) {
                    packageName = resource.getURI().trimFileExtension().lastSegment().toLowerCase();
                }
                this.setPartName(packageName);
                graph = this.initializeMethodCallsGraph(resource);
            } else if (this.editorInput.getInputOperation() != null) {
                AbstractMethodDeclaration operation = this.editorInput.getInputOperation();
                String name = operation.getName();
                this.setPartName(name);
                graph = this.initializeMethodCallsGraph(operation);
            }
            JPanel treeview = PrefuseGraphContainerForJava.getInstance().initializeTreeViewContainer((Graph)graph, "name", null);
            frame.add(treeview);
        }
    }

    public void setFocus() {
    }

    private final Tree initializeMethodCallsGraph(Resource resource) {
        Tree result = new Tree();
        Node parentNode = this.intializeMethodCallsGraph(result, resource);
        List<AbstractMethodDeclaration> allOperations = this.getAllOperations(resource);
        for (AbstractMethodDeclaration rootElement : this.getRootOperationsForMethodCallsGraph(allOperations)) {
            this.generateMethodCallsNode(result, parentNode, rootElement);
        }
        return result;
    }

    private final Tree initializeMethodCallsGraph(AbstractMethodDeclaration rootElement) {
        Tree result = new Tree();
        Node parentNode = this.intializeMethodCallsGraph(result, rootElement.eResource());
        this.generateMethodCallsNode(result, parentNode, rootElement);
        return result;
    }

    private final Node intializeMethodCallsGraph(Tree result, Resource resource) {
        this.computeMethodCallsHierarchy(resource);
        Table nodes = result.getNodeTable();
        Node activeNode = null;
        nodes.addColumn("name", String.class);
        nodes.addColumn("javaOperation", AbstractMethodDeclaration.class);
        nodes.addColumn("jdtProject", IJavaProject.class);
        activeNode = result.addRoot();
        activeNode.set("name", (Object)"Method Calls Graph");
        return activeNode;
    }

    private final void generateMethodCallsNode(Tree result, Node parentNode, AbstractMethodDeclaration element) {
        Node activeNode = result.addChild(parentNode);
        activeNode.set("javaOperation", (Object)element);
        activeNode.set("jdtProject", (Object)this.editorInput.getJavaProject());
        String parentName = "";
        if (element.getAbstractTypeDeclaration() != null) {
            parentName = element.getAbstractTypeDeclaration().getName();
        }
        String name = String.valueOf(parentName) + " :: " + element.getName();
        if (this.parents.contains(element)) {
            activeNode.set("name", (Object)("/recursion/ " + name));
        } else {
            this.parents.add(element);
            List<AbstractMethodDeclaration> calledMethods = this.getCalledMethods(element);
            if (calledMethods.isEmpty()) {
                activeNode.set("name", (Object)name);
                if (element.getBody() == null) {
                    TypeDeclaration parentType = this.getTypeDeclaration((EObject)element);
                    for (TypeDeclaration subtype : this.getAllSubTypes(parentType)) {
                        for (BodyDeclaration body : subtype.getBodyDeclarations()) {
                            if (!(body instanceof AbstractMethodDeclaration)) continue;
                            AbstractMethodDeclaration subMethod = (AbstractMethodDeclaration)body;
                            if (!element.getName().equals(body.getName()) || element.getParameters().size() != subMethod.getParameters().size()) continue;
                            this.generateMethodCallsNode(result, activeNode, subMethod);
                        }
                    }
                }
            } else {
                activeNode.set("name", (Object)(String.valueOf(name) + " (" + calledMethods.size() + ")"));
            }
            for (AbstractMethodDeclaration child : calledMethods) {
                this.generateMethodCallsNode(result, activeNode, child);
            }
            this.parents.remove(element);
        }
    }

    private final Set<TypeDeclaration> getAllSubTypes(TypeDeclaration contextClass) {
        HashSet<TypeDeclaration> result = new HashSet<TypeDeclaration>();
        if (contextClass != null) {
            TreeIterator content = contextClass.eResource().getAllContents();
            while (content.hasNext()) {
                TypeDeclaration currentClassDeclaration;
                EObject eObject = (EObject)content.next();
                if (!(eObject instanceof TypeDeclaration) || !this.isSuperTypeOf(contextClass, currentClassDeclaration = (TypeDeclaration)eObject)) continue;
                result.add(currentClassDeclaration);
                result.addAll(this.getAllSubTypes(currentClassDeclaration));
            }
        }
        return result;
    }

    private final boolean isSuperTypeOf(TypeDeclaration self, TypeDeclaration typeDeclaration) {
        if (typeDeclaration.getSuperInterfaces().contains((Object)self)) {
            return true;
        }
        for (TypeAccess superTypeAccess : typeDeclaration.getSuperInterfaces()) {
            TypeDeclaration superType;
            if (!(superTypeAccess.getType() instanceof TypeDeclaration) || (superType = (TypeDeclaration)superTypeAccess.getType()) != self && !this.isSuperTypeOf(self, superType)) continue;
            return true;
        }
        if (typeDeclaration instanceof ClassDeclaration) {
            TypeDeclaration superType;
            ClassDeclaration classDeclaration = (ClassDeclaration)typeDeclaration;
            if (classDeclaration.getSuperClass() != null && classDeclaration.getSuperClass().getType() == self) {
                return true;
            }
            if (classDeclaration.getSuperClass() != null && classDeclaration.getSuperClass().getType() instanceof TypeDeclaration && this.isSuperTypeOf(self, superType = (TypeDeclaration)classDeclaration.getSuperClass().getType())) {
                return true;
            }
        }
        return false;
    }

    private final List<AbstractMethodDeclaration> getAllOperations(Resource resource) {
        ArrayList<AbstractMethodDeclaration> result = new ArrayList<AbstractMethodDeclaration>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            AbstractMethodDeclaration operation;
            EObject object = (EObject)iterator.next();
            if (!(object instanceof AbstractMethodDeclaration) || (operation = (AbstractMethodDeclaration)object).getName().equalsIgnoreCase("dummy")) continue;
            result.add(operation);
        }
        return result;
    }

    private final List<AbstractMethodInvocation> getAllInvocations(Resource resource) {
        if (this.allInvocations == null) {
            this.allInvocations = new ArrayList<AbstractMethodInvocation>();
            TreeIterator iterator = resource.getAllContents();
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                if (!(object instanceof AbstractMethodInvocation)) continue;
                AbstractMethodInvocation invocation = (AbstractMethodInvocation)object;
                this.allInvocations.add(invocation);
            }
        }
        return this.allInvocations;
    }

    private final List<AbstractMethodDeclaration> getRootOperationsForMethodCallsGraph(List<AbstractMethodDeclaration> elements) {
        ArrayList<AbstractMethodDeclaration> result = new ArrayList<AbstractMethodDeclaration>();
        for (AbstractMethodDeclaration element : elements) {
            boolean root = element.getUsages().isEmpty();
            if (!root) continue;
            result.add(element);
        }
        return result;
    }

    private final List<AbstractMethodDeclaration> getCalledMethods(AbstractMethodDeclaration parent) {
        List<AbstractMethodDeclaration> result = new ArrayList<AbstractMethodDeclaration>();
        if (this.mapInvocations.containsKey(parent)) {
            result = this.mapInvocations.get(parent);
        }
        return result;
    }

    private final void computeMethodCallsHierarchy(Resource resource) {
        List<AbstractMethodInvocation> invocations = this.getAllInvocations(resource);
        Collections.sort(invocations, new MethodInvocationComparator());
        for (AbstractMethodInvocation invocation : invocations) {
            AbstractMethodDeclaration invoker = this.getInvoker((EObject)invocation);
            List<AbstractMethodDeclaration> invokeds = this.mapInvocations.get(invoker);
            if (invokeds == null) {
                invokeds = new ArrayList<AbstractMethodDeclaration>();
                this.mapInvocations.put(invoker, invokeds);
            }
            invokeds.add(invocation.getMethod());
        }
    }

    private final AbstractMethodDeclaration getInvoker(EObject element) {
        AbstractMethodDeclaration result = null;
        if (element != null) {
            result = element instanceof AbstractMethodDeclaration ? (AbstractMethodDeclaration)element : this.getInvoker(element.eContainer());
        }
        return result;
    }

    private final TypeDeclaration getTypeDeclaration(EObject element) {
        TypeDeclaration result = null;
        if (element != null) {
            result = element instanceof TypeDeclaration ? (TypeDeclaration)element : this.getTypeDeclaration(element.eContainer());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodInvocationComparator
    implements Comparator<AbstractMethodInvocation> {
        private MethodInvocationComparator() {
        }

        @Override
        public int compare(AbstractMethodInvocation invocation1, AbstractMethodInvocation invocation2) {
            int result = -1;
            Block rootBlock1 = this.getRootBlock((EObject)invocation1);
            Block rootBlock2 = this.getRootBlock((EObject)invocation2);
            if (rootBlock1 == null || rootBlock2 == null) {
                result = 0;
            } else {
                int index2;
                int index1 = this.computeIndex((EObject)invocation1, rootBlock1);
                if (index1 == (index2 = this.computeIndex((EObject)invocation2, rootBlock2)) && rootBlock1 == rootBlock2) {
                    Block commonBlock = this.getFirstCommonParentBlock((EObject)invocation1, (EObject)invocation2, rootBlock1);
                    index1 = this.computeIndex((EObject)invocation1, commonBlock);
                    index2 = this.computeIndex((EObject)invocation2, commonBlock);
                }
                result = Integer.valueOf(index1).compareTo(index2);
            }
            return result;
        }

        private final int computeIndex(EObject element, Block rootBlock) {
            int result = -2;
            result = element.eContainer() == rootBlock ? rootBlock.getStatements().indexOf((Object)element) : this.computeIndex(element.eContainer(), rootBlock);
            return result;
        }

        private final Block getRootBlock(EObject element) {
            Block result = null;
            if (element != null) {
                result = element instanceof AbstractMethodDeclaration ? ((AbstractMethodDeclaration)element).getBody() : this.getRootBlock(element.eContainer());
            }
            return result;
        }

        private final Block getFirstCommonParentBlock(EObject sourceElement, EObject element2, Block stopper) {
            Block result = this.getParentBlock(sourceElement);
            if (result != stopper && !this.isParentBlock(element2, result, stopper)) {
                result = this.getFirstCommonParentBlock((EObject)result, element2, stopper);
            }
            return result;
        }

        private final boolean isParentBlock(EObject element, Block target, Block stopper) {
            boolean result = false;
            Block parent = this.getParentBlock(element);
            if (parent != stopper) {
                result = parent == target ? true : this.isParentBlock((EObject)parent, target, stopper);
            }
            return result;
        }

        private final Block getParentBlock(EObject element) {
            Block result = null;
            if (element != null) {
                result = element.eContainer() instanceof Block ? (Block)element.eContainer() : this.getParentBlock(element.eContainer());
            }
            return result;
        }
    }
}

