/**
 * 
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gabriel Barbier (Mia-Software) - initial API and implementation
 * 
 * 
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.ModelFilterPropertiesFactory
 * @model kind="package"
 * @generated
 */
public interface ModelFilterPropertiesPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "modelfilterproperties";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/Modelplex/modelfilterproperties";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "modelfilterproperties";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ModelFilterPropertiesPackage eINSTANCE = org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.impl.ModelFilterPropertiesPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.impl.SelectedElementImpl <em>Selected Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.impl.SelectedElementImpl
	 * @see org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.impl.ModelFilterPropertiesPackageImpl#getSelectedElement()
	 * @generated
	 */
	int SELECTED_ELEMENT = 0;

	/**
	 * The feature id for the '<em><b>Element Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECTED_ELEMENT__ELEMENT_NAME = 0;

	/**
	 * The feature id for the '<em><b>Dependencies Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECTED_ELEMENT__DEPENDENCIES_LEVEL = 1;

	/**
	 * The number of structural features of the '<em>Selected Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECTED_ELEMENT_FEATURE_COUNT = 2;


	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.SelectedElement <em>Selected Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Selected Element</em>'.
	 * @see org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.SelectedElement
	 * @generated
	 */
	EClass getSelectedElement();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.SelectedElement#getElementName <em>Element Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Element Name</em>'.
	 * @see org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.SelectedElement#getElementName()
	 * @see #getSelectedElement()
	 * @generated
	 */
	EAttribute getSelectedElement_ElementName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.SelectedElement#getDependenciesLevel <em>Dependencies Level</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Dependencies Level</em>'.
	 * @see org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.SelectedElement#getDependenciesLevel()
	 * @see #getSelectedElement()
	 * @generated
	 */
	EAttribute getSelectedElement_DependenciesLevel();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ModelFilterPropertiesFactory getModelFilterPropertiesFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.impl.SelectedElementImpl <em>Selected Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.impl.SelectedElementImpl
		 * @see org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.impl.ModelFilterPropertiesPackageImpl#getSelectedElement()
		 * @generated
		 */
		EClass SELECTED_ELEMENT = eINSTANCE.getSelectedElement();

		/**
		 * The meta object literal for the '<em><b>Element Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SELECTED_ELEMENT__ELEMENT_NAME = eINSTANCE.getSelectedElement_ElementName();

		/**
		 * The meta object literal for the '<em><b>Dependencies Level</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SELECTED_ELEMENT__DEPENDENCIES_LEVEL = eINSTANCE.getSelectedElement_DependenciesLevel();

	}

} //ModelFilterPropertiesPackage
