/**
 * 
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gabriel Barbier (Mia-Software) - initial API and implementation
 * 
 * 
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.ModelFilterPropertiesFactory;
import org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.ModelFilterPropertiesPackage;
import org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.SelectedElement;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ModelFilterPropertiesPackageImpl extends EPackageImpl implements ModelFilterPropertiesPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass selectedElementEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.ModelFilterPropertiesPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ModelFilterPropertiesPackageImpl() {
		super(eNS_URI, ModelFilterPropertiesFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ModelFilterPropertiesPackage init() {
		if (isInited) return (ModelFilterPropertiesPackage)EPackage.Registry.INSTANCE.getEPackage(ModelFilterPropertiesPackage.eNS_URI);

		// Obtain or create and register package
		ModelFilterPropertiesPackageImpl theModelFilterPropertiesPackage = (ModelFilterPropertiesPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof ModelFilterPropertiesPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new ModelFilterPropertiesPackageImpl());

		isInited = true;

		// Create package meta-data objects
		theModelFilterPropertiesPackage.createPackageContents();

		// Initialize created meta-data
		theModelFilterPropertiesPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theModelFilterPropertiesPackage.freeze();

		return theModelFilterPropertiesPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSelectedElement() {
		return this.selectedElementEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSelectedElement_ElementName() {
		return (EAttribute)this.selectedElementEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSelectedElement_DependenciesLevel() {
		return (EAttribute)this.selectedElementEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelFilterPropertiesFactory getModelFilterPropertiesFactory() {
		return (ModelFilterPropertiesFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (this.isCreated) return;
		this.isCreated = true;

		// Create classes and their features
		this.selectedElementEClass = createEClass(SELECTED_ELEMENT);
		createEAttribute(this.selectedElementEClass, SELECTED_ELEMENT__ELEMENT_NAME);
		createEAttribute(this.selectedElementEClass, SELECTED_ELEMENT__DEPENDENCIES_LEVEL);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (this.isInitialized) return;
		this.isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes

		// Initialize classes and features; add operations and parameters
		initEClass(this.selectedElementEClass, SelectedElement.class, "SelectedElement", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSelectedElement_ElementName(), this.ecorePackage.getEString(), "elementName", null, 0, 1, SelectedElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSelectedElement_DependenciesLevel(), this.ecorePackage.getEInt(), "dependenciesLevel", null, 0, 1, SelectedElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);
	}

} //ModelFilterPropertiesPackageImpl
